/* 
 * io.c
 * Copyright (C) 2002, AVM GmbH. All rights reserved.
 * 
 * This Software is  free software. You can redistribute and/or
 * modify such free software under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * The free software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this Software; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA, or see
 * http://www.opensource.org/licenses/lgpl-license.html
 * 
 * Contact: AVM GmbH, Alt-Moabit 95, 10559 Berlin, Germany, email: info@avm.de
 */


#include <stdio.h>
#include "driver.h"
#include "io.h"
#include "tools.h"
#include "libstub.h"

//struct timer_list timer;

#define TEST

TGT Target[8];
int enabled = 1;
#ifdef TEST
int forcelog = 0;
#else
int forcelog = 1;
#endif
int first = 0;
int count = 0;
int sched = 0;
unsigned msec = 0;

#if 0
int FindCallRef( unsigned char bCallRef, card_t *card )
{
  int i, ret = -1;
  for( i = 0; i < MAX_CALL; i++ )
    {
      if( card->Call[i].bCallRef == bCallRef )
	{
	  ret = i;
	  break;
	}
    }
  if( ret == -1 )
    TRACE(("FindCallRef: %x failed\n", bCallRef ));
  return ret;
}

int NewCallRef( unsigned char bCallRef, card_t *card )
{
  int i, ret = -1;
  TRACE(("NewCallRef: %x\n", bCallRef ));
  for( i = 0; i < MAX_CALL; i++ )
    {
      if( card->Call[i].bCallRef == 0 )
	{
	  card->Call[i].bCallRef = bCallRef;
	  card->Call[i].bState = 0;
	  ret = i;
	  break;
	}
    }

  if( ret == -1 )
    TRACE(("NewCallRef: %x failed\n", bCallRef ));
  return ret;
}

int FreeCallRef( unsigned char bCallRef, card_t *card )
{
  int i, ret = -1;
  TRACE(("FreeCallRef: %x\n", bCallRef ));
  for( i = 0; i < MAX_CALL; i++ )
    {
      if( card->Call[i].bCallRef == bCallRef )
	{
	  card->Call[i].bCallRef = 0;
	  card->Call[i].bState = 0;
	  ret = i;
	  break;
	}
    }

  if( ret == -1 )
    TRACE(("FreeCallRef: %x failed\n", bCallRef ));

  return ret;
}
#endif

#if 1
void DumpBuffer( char *pData, int wDataLength )
{
  char string[1024];
  char *pStr = string;
  int i;

  if( wDataLength > 2048 )
    wDataLength = 2048;

  *pStr = 0;

  for( i = 0; i < wDataLength; i++ )
  {
    sprintf( pStr, "0x%02X, ", ( unsigned char )pData[i] );
    pStr += 6;
    if( !(( i + 1 ) % 16) )
    {
       sprintf( pStr,"\n" );
       pStr = string;
       TRACE(( string ));
    }
  }

  if( pStr != string )
  {
       sprintf( pStr,"\n" );
       pStr = string;
       TRACE(( string ));
  }
}
#else
void DumpBuffer( char *pData, int wDataLength )
{
  static char string[1024];
  char *pStr = string;
  int i;

  if( wDataLength > 2048 )
    wDataLength = 2048;

  for( i = 0; i < wDataLength; i++ )
  {
    TRACE(( "0x%02X, ", ( unsigned char )pData[i] ));
    if( !(( i + 1 ) % 16) )
    {
       TRACE(( "\n" ));
    }
  }
  TRACE(( "\n" ));
}

#endif

int intimercb = 0;

int timercb( unsigned long param )
{
  int ret = 0, eret = 0;
  if( intimercb )
    {
      TRACE(("timercb reentered\n" ));
      return 0;
    }
  intimercb = 1;

#if 0
  int i;
  for( i = 0; i < 63; i++ )
    {
      Target[TGT_CFG].bMem[REG_READ][0] &= ~4;
      (*capi_lib->cm_handle_events) (); 
    }
#endif
  if( param & 1 )
    {
      unsigned tick = os_msec();
      //printf( "time: %lu %lu\n", tick, msec );
      if( msec < tick )
	{
	  //      printf("timer interrupt %d\n", avm_time_base );
	  Target[TGT_CFG].bMem[REG_READ][0] &= ~0x04;
	  msec = tick + 1;
	}
      
      if( ((~Target[TGT_HSCX1].bMem[REG_WRITE][0]) & 
	   Target[TGT_HSCX1].bMem[REG_READ][0]) != 0 )
	Target[TGT_CFG].bMem[REG_READ][0] &= ~0x02;
      
      if( Target[TGT_ISAC].bMem[0][REG_READ] != 0 )
	Target[TGT_CFG].bMem[REG_READ][0] &= ~0x01;
      
    }
  
  if( param & 2 )
    {
      //  avm_time_base += 63;
      if( enabled && (( Target[TGT_CFG].bMem[REG_READ][0] & 0x0F ) != 7 ) )
	{
	  //TRACE(( "simulated interrupt: %x\n", Target[TGT_CFG].bMem[REG_READ][0]));
	  eret = (*capi_lib->cm_handle_events) ();
	  //TRACE(("eret: %x\n", eret ));
	  if( eret ) 
	    {
	      os_timer_poll ();
	      
	      while( ret = (*capi_lib->cm_schedule) ()) 
		{
		  scheduler_control (1);
		} 	
	      //TRACE(("scheduler ret: %d\n", ret ));
	    }
	}
    }

  if( param & 4 )
    {
      (*capi_lib->cm_schedule) ();
    }
  intimercb = 0;
  return ( ( Target[TGT_CFG].bMem[REG_READ][0] & 0x0F ) != 7 || ret );
}


unsigned long isac( unsigned port, unsigned length, 
		    unsigned char *pData, int access, int block )
{
  port -= 0x1400;
  if( access )
    {
      unsigned i;
      unsigned char reg = *pData, intstat = 0x17;
      //TRACE(("isac write: %x %x\n", port, *pData ));

      switch( port )
	{
	case 0x11:
	  if( ((reg>>2) & 0x0F ) == 0x09 )
	    {
	      Target[TGT_ISAC].bMem[REG_READ][0x11] = 0x74;
	      //Target[TGT_ISAC].bMem[REG_READ][0x00] |= 0x04;
	    }
	  break;
	  
	case 0x01:
	  if( reg == 0x0A )
	    {
	      Target[TGT_ISAC].bMem[REG_READ][0x00] |= 0x10;
	    }
	  else if( reg & 0x10 )
	    {
	      TRACE(("ISAC start timer\n" ));      
	    }	  

	  break;
	}

    }
  else
    {
      unsigned i;
      for( i = 0; i < length; i++ )
	pData[i] = Target[TGT_ISAC].bMem[REG_READ][port+i];
      //TRACE(("isac read: %x %x\n", port, *pData ));

      switch( port )
	{
	case 0x00:
	  Target[TGT_ISAC].bMem[REG_READ][0x00] = 0x00;
	  break;
	}

    }
  return 0;
}

unsigned long cfg( unsigned port, unsigned length, 
		     unsigned char *pData, int access, int block )
{
  port -= 0x1800;

  //TRACE(("cfg: %x\n", port ));
  if( access )
    {
      unsigned i;
      //TRACE(("cfg write: %x %x\n", port, *pData ));
#if 1
      for( i = 0; i < length; i++ )
	Target[TGT_CFG].bMem[REG_READ][port+i] ^= pData[i] & 0xF0;
#endif    
    }
  else
    {
      unsigned i;
      for( i = 0; i < length; i++ )
	pData[i] = Target[TGT_CFG].bMem[REG_READ][port+i];
      //TRACE(("cfg read: %x %x\n", port, *pData ));
      if( port == 0 )
	{
	  Target[TGT_CFG].bMem[REG_READ][port] = 0x14;
	  
	  if( Target[TGT_ISAC].bMem[REG_READ][0] == 0 )
	    Target[TGT_CFG].bMem[REG_READ][port] |= 0x01;
	    
	  if( Target[TGT_HSCX1].bMem[REG_READ][0] == 0 )
	    Target[TGT_CFG].bMem[REG_READ][port] |= 0x02;

	}
    }
  return 0;

}


unsigned long hscx0( unsigned port, unsigned length, 
		     unsigned char *pData, int access, int block )
{
  port -= 0x0400;
  if( access )
    {
      unsigned i;
      unsigned char reg = *pData, intstat = 0x17;
      switch( port )
	{
	case 0:
	  if( *pData )
	    TRACE(("HSCX_0 interrupts disabled\n" ));
	  else
	    TRACE(("HSCX_0 interrupts enabled\n" ));
	  break;
	  
	case 1: // CMD
	  if( reg & 0x01 )
	    {
	      Target[TGT_HSCX1].bMem[REG_READ][0] |= 0x04;
	      Target[TGT_HSCX0].bMem[REG_READ][0] |= 0x10;
	    }
	  else if( reg & 0x10 )
	    {
	      TRACE(("HSCX0 start timer\n" ));
	      Target[TGT_HSCX0].bMem[REG_READ][0] |= 0x08;
	    }	  
	  else if( reg & 0x08 )
	    {
	      //      TRACE(("HSCX0 start tx\n")); 
	      Target[TGT_HSCX0].dwFlags |= 0x01;
	      //Target[TGT_HSCX1].bMem[REG_READ][0] |= 0x04;
	      //Target[TGT_HSCX0].bMem[REG_READ][0] |= 0x10;
	    }	  
	  else if( reg & 0x80 )
	    {
	      //      TRACE(("HSCX0 start tx\n")); 
	      Target[TGT_HSCX0].dwFlags |= 0x02;
	      //Target[TGT_HSCX1].bMem[REG_READ][0] |= 0x04;
	      //Target[TGT_HSCX0].bMem[REG_READ][0] |= 0x10;
	    }	  
	  break;
	}
#if 1
      for( i = 0; i < length; i++ )
	Target[TGT_HSCX0].bMem[REG_WRITE][port+i] = pData[i];
#endif    
    }
  else
    {
      unsigned i;
      for( i = 0; i < length; i++ )
	pData[i] = Target[TGT_HSCX0].bMem[REG_READ][port+i];
#if 0    
      //if( port == 1 )
      TRACE(("read hscx0: %x %x\n", port, *pData ));
#endif     
      switch( port )
	{
	case 0: 
	  Target[TGT_HSCX0].bMem[REG_READ][port] = 0x00;
	  Target[TGT_HSCX1].bMem[REG_READ][port] &= ~0x04;
	  //	  TRACE(("STAT0: %x\n", *pData ));
	  break;
	  
	case 1: 
	  //Target[TGT_HSCX0].bMem[REG_READ][port] ^= 0x40;
	  break;
	}
	  
    }
  return 0;
}


unsigned long hscx1( unsigned port, unsigned length, 
		     unsigned char *pData, int access, int block )
{
  port -= 0x0c00;

  if( access )
    {
      unsigned i;
      unsigned char reg = *pData, intstat = 0x17;
      
      //      if( port == 0 )
      //      TRACE(("write hscx1: %x %x\n", port, *pData ));
      switch( port )
	{

	case 0:
	  if( *pData )
	    TRACE(("HSCX_1 interrupts disabled\n" ));
	  else
	    TRACE(("HSCX_1 interrupts enabled\n" ));
	  break;

	case 1: // CMD
	  if( reg & 0x01 )
	    {
	      Target[TGT_HSCX1].bMem[REG_READ][0] |= 0x10;
	    }
	  else if( reg & 0x10 )
	    {
	      TRACE(("HSCX1 start timer\n" ));
	      Target[TGT_HSCX1].bMem[REG_READ][0] |= 0x08;
	    }	  
	  else if( reg & 0x08 )
	    {
	      //      TRACE(("HSCX0 start tx\n")); 
	      Target[TGT_HSCX1].dwFlags |= 0x01;
	    }	  
	  else if( reg & 0x80 )
	    {
	      //      TRACE(("HSCX0 start tx\n")); 
	      Target[TGT_HSCX1].dwFlags |= 0x02;
	      //Target[TGT_HSCX1].bMem[REG_READ][0] |= 0x04;
	      //Target[TGT_HSCX0].bMem[REG_READ][0] |= 0x10;
	    }	  

	  break;
	}
#if 1
      for( i = 0; i < length; i++ )
	Target[TGT_HSCX1].bMem[REG_WRITE][port+i] = pData[i];
#endif      
 
    }
  else
    {
      unsigned i;
      for( i = 0; i < length; i++ )
	pData[i] = Target[TGT_HSCX1].bMem[REG_READ][port+i];
      
      //TRACE(("read hscx1: %x %x\n", port, *pData ));
      
      switch( port )
	{
	case 0: // CMD
	  Target[TGT_HSCX1].bMem[REG_READ][port] = 0x00;
	  //TRACE(("STAT1: %x\n", *pData ));
	  break;
	}

    }
  return 0;

}

void SendDFrame( unsigned char *pData, unsigned len )
{
  unsigned char intstat = 0x17;
  if( len )
    {
      if( pData )
	memcpy( Target[TGT_ISAC_FIFO].bMem[REG_READ], pData, len );
      Target[TGT_ISAC].bMem[REG_READ][5] = len;
      Target[TGT_ISAC].bMem[REG_READ][7] = 0xA0;
      Target[TGT_ISAC].bMem[REG_READ][0] |= 0x80;
    }
}

void QueueDFrame( unsigned char *pData, unsigned length, card_t *card )
{
  if( card->pFrmWrite[0] == 0 )
    {
      memcpy( &card->pFrmWrite[1], pData, length ); 
      card->pFrmWrite[0] = length;
      card->pFrmWrite += 256;
      if( card->pFrmWrite >= card->pFrmEnd )
	card->pFrmWrite = card->frmbuf;
    }  
  else
    TRACE(("dframe queue overflow !!!! %ld\n", 
	   (unsigned long)( card->pFrmWrite - card->frmbuf) ));

}

unsigned char *GetNextDFrame( card_t *card, unsigned char *plen )
{
  unsigned char *pRet = NULL;

  if( card->pFrmRead[0] && Target[TGT_ISAC_FIFO].bMem[REG_READ][1] == 0 )
    {
      *plen = card->pFrmRead[0];
      pRet = &card->pFrmRead[1]; 
      card->pFrmRead[0] = 0;
      card->pFrmRead += 256;
      if( card->pFrmRead >= card->pFrmEnd )
	card->pFrmRead = card->frmbuf;
    }  
  return pRet;
}

void QueueiFrame( unsigned char *pData, unsigned length, card_t *card )
{
  if( card->piFrmWrite[0] == 0 )
    {
      memcpy( &card->piFrmWrite[1], pData, length ); 
      card->piFrmWrite[0] = length;
      card->piFrmWrite += 256;
      if( card->piFrmWrite >= card->piFrmEnd )
	card->piFrmWrite = card->ifrmbuf;
    }  
  else
    TRACE(("iframe queue overflow !!!! %ld\n", 
	   (unsigned long)( card->piFrmWrite - card->ifrmbuf) ));

}

unsigned char *GetNextiFrame( card_t *card, unsigned char *plen )
{
  unsigned char *pRet = NULL;

  if( card->piFrmRead[0] )
    {
      *plen = card->piFrmRead[0];
      pRet = &card->piFrmRead[1]; 
      card->piFrmRead[0] = 0;
      card->piFrmRead += 256;
      if( card->piFrmRead >= card->piFrmEnd )
	card->piFrmRead = card->ifrmbuf;
    }  
  return pRet;
}

void ProcessDFrame( unsigned char *pData, unsigned length, card_t *card )
{
  unsigned char len = 0;
  unsigned char CallRef = 0;
  unsigned char tmp[256];

  TRACE(("Enter ProcessDFrame\n" ));
  if( *pData == 0xFC )
    {
      memcpy( tmp, pData, length );
      tmp[0] = 0xFE;
      tmp[7] = 0x81;
      tmp[6] = 0x02;
      len = length;
    }
  else if( *pData == 0x00 && length == 3 )
    {
      memcpy( tmp, pData, length );
      switch( pData[2] )
	{
	case 0x7F:
	  tmp[2] = 0x73;
	  break;
	  
	case 0x53:
	  tmp[2] = 0x73;
	  card->rec_cnt = 0;
	  card->snd_cnt = 0;
	  break;
	  
	}
      len = length;
    }
  else if( length > 4 )
    {
      card->rec_cnt += 2;
      tmp[0] = 0;
      tmp[1] = 0x81;
      tmp[2] = 1;
      tmp[3] = card->rec_cnt;
      //len = 4;
      QueueDFrame( tmp, 4, card );
      CallRef = pData[6];      
      CallRef = CallRef ^ 0x80;

      switch( pData[7] )
	{
	case 0x07:
	  tmp[0] = 2;
	  tmp[1] = 0x81;
	  tmp[2] = card->snd_cnt;
	  tmp[3] = card->rec_cnt;
	  tmp[4] = 0x08;
	  tmp[5] = 0x01;
	  tmp[6] = CallRef;
	  tmp[7] = 0x0F;
	  len = 8;
	  card->snd_cnt += 2;
	  break;

	case 0x05:
	  tmp[0] = 2;
	  tmp[1] = 0x81;
	  tmp[2] = card->snd_cnt;
	  tmp[3] = card->rec_cnt;
	  tmp[4] = 0x08;
	  tmp[5] = 0x01;
	  tmp[6] = CallRef;
	  tmp[7] = 0x07;
	  tmp[8] = 0x18;
	  tmp[9] = 0x01;
	  tmp[10] = 0x88 | ( pData[20] & 0x0F );

	  QueueiFrame( tmp, 11, card );

	  tmp[0] = 2;
	  tmp[1] = 0x81;
	  tmp[2] = card->snd_cnt;
	  tmp[3] = card->rec_cnt;
	  tmp[4] = 0x08;
	  tmp[5] = 0x01;
	  tmp[6] = CallRef;
	  tmp[7] = 0x02;
	  tmp[8] = 0x18;
	  tmp[9] = 0x01;
	  tmp[10] = 0x88 | ( pData[20] & 0x0F );
	  len = 11;
	  card->snd_cnt += 2;
	  break;
	
	case 0x5A:
	  break;

	case 0x4D:
	  tmp[0] = 2;
	  tmp[1] = 0x81;
	  tmp[2] = card->snd_cnt;
	  tmp[3] = card->rec_cnt;
	  tmp[4] = 0x08;
	  tmp[5] = 0x01;
	  tmp[6] = CallRef;
	  tmp[7] = 0x5A;
	  len = 8;
	  card->snd_cnt += 2;
	  break;

	case 0x45:
	  tmp[0] = 2;
	  tmp[1] = 0x81;
	  tmp[2] = card->snd_cnt;
	  tmp[3] = card->rec_cnt;
	  tmp[4] = 0x08;
	  tmp[5] = 0x01;
	  tmp[6] = CallRef;
	  tmp[7] = 0x4D;
	  tmp[8] = 0x08;
	  tmp[9] = 0x02; 
	  tmp[10] = 0x80;
	  tmp[11] = 0x90; 
	  len = 12;
	  card->snd_cnt += 2;
	  break;
	}

    }
  else
    {
      unsigned char *piFrame = GetNextiFrame( card, &len );
      if( piFrame )
	{
	  TRACE(("Send connect CallRef: %x\n", piFrame[6] ));
	  piFrame[2] = card->snd_cnt;
	  piFrame[3] = card->rec_cnt;
	  QueueDFrame( piFrame, len, card );
	  len = 0;
	  card->snd_cnt += 2;
	}
      else
	{
	  tmp[0] = 0;
	  tmp[1] = 0x81;
	  tmp[2] = 1;
	  tmp[3] = card->rec_cnt|1;
	  len = 4;
	}
    }
  if( len )
    QueueDFrame( tmp, len, card );
  TRACE(("Exit ProcessDFrame\n" ));
} 

void Ring( unsigned long dwPlci )
{
  unsigned char buffer[64];
  
  buffer[0] = 0x02;
  buffer[1] = 0xFF;
  buffer[2] = 0x03;
  buffer[3] = 0x08;
  buffer[4] = 0x01;
  buffer[5] = (unsigned char)(dwPlci >> 8 ) & 0x7F;
  buffer[6] = 0x05;
  buffer[7] = 0xA1;
  buffer[8] = 0x04;
  buffer[9] = 0x03;
  buffer[10] = 0x80;
  buffer[11] = 0x90;
  buffer[12] = 0xA3;
  buffer[13] = 0x18;
  buffer[14] = 0x01;
  buffer[15] = 0x88 | ( 0xFF & (dwPlci >> 16 ));
  buffer[16] = 0x1E;
  buffer[17] = 0x02;
  buffer[18] = 0x85;
  buffer[19] = 0x83;
  buffer[20] = 0x6C;
  buffer[21] = 0x03;
  buffer[22] = 0x01;
  buffer[23] = 0x81;
  buffer[24] = 0x31;
  buffer[25] = 0x70;
  buffer[26] = 0x02;
  buffer[27] = 0x81;
  buffer[28] = 0x32;
 
  Target[TGT_ISAC].bMem[REG_READ][0] |= 0x04;
  FaxPoll(3);
  SendDFrame( buffer, 29 );
}


void D_Disconnect( unsigned long dwPlci, card_t *card )
{
  unsigned char buffer[64];
  
  buffer[0] = 0x02;
  buffer[1] = 0x81;
  buffer[2] = card->snd_cnt;
  buffer[3] = card->rec_cnt;;
  buffer[4] = 0x08;
  buffer[5] = 0x01;
  buffer[6] = (unsigned char)(dwPlci >> 8 ) & 0x7F;
  buffer[7] = 0x4D;
  buffer[8] = 0x08;
  buffer[9] = 0x02;
  buffer[10] = 0x80;
  buffer[11] = 0x90;
  card->snd_cnt += 2;
  Target[TGT_ISAC].bMem[REG_READ][0] |= 0x04;
  FaxPoll(3);
  SendDFrame( buffer, 12 );
}


unsigned long isacfifo( unsigned port, unsigned length, 
		    unsigned char *pData, int access, int block )
{
  unsigned char *pNextDFrame = NULL;
  unsigned char len = 0;
  port -= 0x1000;
  if( access )
    {
      unsigned i;
      int len = 0;
      //TRACE(("isacfifo write: %x %x\n", port, *pData ));
#if 1
      TRACE(("-> "));
      DumpBuffer( pData, length );
#endif    
      for( i = 0; i < length; i++ )
	Target[TGT_ISAC_FIFO].bMem[REG_WRITE][port+i] = pData[i];
      //memcpy( Target[TGT_ISAC_FIFO].bMem[REG_READ], pData, length );

      ProcessDFrame( pData, length, capi_card );  
    }
  else
    {
      unsigned i;
      for( i = 0; i < length; i++ )
	pData[i] = Target[TGT_ISAC_FIFO].bMem[REG_READ][port+i];
      //TRACE(("isacfifo read: %x %x\n", port, *pData ));
      Target[TGT_ISAC_FIFO].bMem[REG_READ][1] = 0;
#if 1
      TRACE(("<- "));
      DumpBuffer( pData, length );
#endif
    }
  
  pNextDFrame = GetNextDFrame( capi_card, &len );
  if( pNextDFrame )
    SendDFrame( pNextDFrame, len );

  return 0;
}

unsigned long hscx0fifo( unsigned port, unsigned length, 
			 unsigned char *pData, int access, int block )
{
  if( access )
    {
      Target[TGT_HSCX0].writecnt++;
      //TRACE(("hscx0fifo write: %x %x %d\n", port, *pData, length ));
      Target[TGT_HSCX0].datacnt += length;
      if( capi_card->TxCB )
	capi_card->TxCB( pData, length, 0x00010000 );
    }
  else
    {
      Target[TGT_HSCX0].readcnt++;
      if( block )
	{
	  if( capi_card->RxCB && block )
	    {
	      capi_card->RxCB( pData, length, 0x00010000 );
	      memcpy( Target[TGT_HSCX0_FIFO].bMem[REG_READ], pData, length );
	    }
	}
      else
	{
	  *pData = Target[TGT_HSCX0_FIFO].bMem[REG_READ][port];
	  //TRACE(("Byte access hscx0fifo: %x\n", *pData ));
	}
    }
  return 0;
}

unsigned long hscx1fifo( unsigned port, unsigned length, 
		    unsigned char *pData, int access, int block )
{
  port -= 0x0800;
  if( access )
    {
      Target[TGT_HSCX1].writecnt++;
      //TRACE(("hscx1fifo write: %x %x\n", port, *pData ));
      Target[TGT_HSCX1].datacnt += length;
      if( capi_card->TxCB )
	capi_card->TxCB( pData, length, 0x00020000 );
    }
  else
    {
      Target[TGT_HSCX1].readcnt++;
      //TRACE(("hscx1fifo read: %x %x\n", block, length ));
      if( block )
	{
	  if( capi_card->RxCB && block )
	    {
	      capi_card->RxCB( pData, length, 0x00020000 );
	      memcpy( Target[TGT_HSCX1_FIFO].bMem[REG_READ], pData, length );
	    }
	}
      else
	*pData = Target[TGT_HSCX1_FIFO].bMem[REG_READ][port];
      //TRACE(("hscx1cfifo read: %x %x\n", port, *pData ));
    }
  return 0;
}

void GetRWCount( unsigned dwPlci )
{
  int tgt = (( dwPlci >> 16 ) & 0xFF ) - 1;
  
  if( tgt == 0 )
    {
      TRACE(("HSCX_0: r: %d w: %d\n", Target[TGT_HSCX0].readcnt,
	     Target[TGT_HSCX0].writecnt ));
    }
  else if( tgt == 1 )
    {
      TRACE(("HSCX_1: r: %d w: %d\n", Target[TGT_HSCX1].readcnt,
	     Target[TGT_HSCX1].writecnt ));
    }

}

unsigned long GetHscxFlags( unsigned dwPlci )
{
  int tgt = (( dwPlci >> 16 ) & 0xFF ) - 1;
  
  if( tgt == 0 )
    {
      return Target[TGT_HSCX0].dwFlags;
    }
  else if( tgt == 1 )
    {
      return Target[TGT_HSCX1].dwFlags;
    }
}

void NextB3Write( unsigned char bCh )
{
  int tgt = bCh - 1;
  
  if( tgt == 0 )
    {
      if( Target[TGT_HSCX0].dwFlags & 0x01 )
	{
	  Target[TGT_HSCX0].datacnt = 0;
	  Target[TGT_HSCX1].bMem[REG_READ][0] |= 0x04;
	  Target[TGT_HSCX0].bMem[REG_READ][0] |= 0x10;
	  Target[TGT_HSCX0].dwFlags &= ~0x01;
	}
    }
  else if( tgt == 1 )
    {
      if( Target[TGT_HSCX1].dwFlags & 0x01 )
	{
	  Target[TGT_HSCX1].bMem[REG_READ][0] |= 0x10;
	  Target[TGT_HSCX1].dwFlags &= ~0x01;
	  Target[TGT_HSCX1].datacnt = 0;
	}
    }
}

void NextB3Read( unsigned char bCh )
{
  int tgt = bCh - 1;
  if( tgt == 0 )
    {
      if( Target[TGT_HSCX0].dwFlags & 0x02 )
	{
	  //Target[TGT_HSCX0].datacnt = 0;
	  Target[TGT_HSCX1].bMem[REG_READ][0] |= 0x04;
	  Target[TGT_HSCX0].bMem[REG_READ][0] |= 0x40;
	  Target[TGT_HSCX0].dwFlags &= ~0x02;
	}
    }
  else if( tgt == 1 )
    {
      if( Target[TGT_HSCX1].dwFlags & 0x02 )
	{
	  //Target[TGT_HSCX1].datacnt = 0;
	  Target[TGT_HSCX1].bMem[REG_READ][0] |= 0x40;
	  Target[TGT_HSCX1].dwFlags &= ~0x02;
	}
    }
}

void target_init( void )
{
  memset( Target, 0x00, sizeof( Target ));
  
  Target[TGT_ISAC].pFunc = isac;
  Target[TGT_HSCX0].pFunc = hscx0;
  Target[TGT_HSCX1].pFunc = hscx1;
  Target[TGT_ISAC_FIFO].pFunc = isacfifo;
  Target[TGT_ISAC].bMem[REG_READ][1] = 0x48;
  Target[TGT_ISAC].bMem[REG_READ][0x11] = 0x74;
  Target[TGT_HSCX0].bMem[REG_READ][1] = 0x40;
  Target[TGT_HSCX1].bMem[REG_READ][1] = 0x40;
  Target[TGT_CFG].pFunc = cfg;
  Target[TGT_CFG].bMem[REG_READ][0] = 0x03;
  Target[TGT_HSCX0_FIFO].pFunc = hscx0fifo;
  Target[TGT_HSCX1_FIFO].pFunc = hscx1fifo;
  Target[TGT_HSCX0].bMem[REG_READ][0] = 0xFF;
  Target[TGT_HSCX1].bMem[REG_READ][0] = 0xFF;

#ifndef TEST
  init_timer( &timer );
  timer.expires = jiffies+ HZ;
  timer.function = timercb;
  add_timer( &timer );
#endif  
}

void target_exit( void )
{
#ifndef TEST
  del_timer_sync( &timer );
#endif
}
  
void disable( void )
{
  enabled = 0;
}

void enable( void )
{
  enabled = 1;
}

extern card_t *	capi_card;




int GetTarget( unsigned port, unsigned base )
{
  int ret = 0;
  unsigned addr = port - base;

  if( addr >= 0x1800 )
    ret = TGT_CFG;
  else if( addr >= 0x1400 )
    ret = TGT_ISAC;
  else if( addr >= 0x1000 )
    ret = TGT_ISAC_FIFO;
  else if( addr >= 0x0C00 )
    ret = TGT_HSCX1;
  else if( addr >= 0x0800 )
    ret = TGT_HSCX1_FIFO;
  else if( addr >= 0x0400 )
    ret = TGT_HSCX0;
  else if( addr >= 0x0000 )
    ret = TGT_HSCX0_FIFO;
  return ret;
}

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
unsigned char _InpByte (unsigned port) 
{
  unsigned char byte;
  int tgt = GetTarget( port, capi_card->base );
  
  if( Target[tgt].pFunc )
    Target[tgt].pFunc( port - capi_card->base, 1, &byte, 0, 0 );

  return byte;
} /* InpByte */

void _OutpByte (unsigned port, unsigned char data) { 

  int tgt;

  tgt = GetTarget( port, capi_card->base );
 
  if( Target[tgt].pFunc )
    Target[tgt].pFunc( port - capi_card->base, 1, &data, 1, 0 );

} /* OutpByte */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
unsigned long _InpDWord (unsigned port) { 

  unsigned long dword = 0;

  return dword;
} /* InpDWord */

void _OutpDWord (unsigned port, unsigned long data) { 



} /* OutpDWord */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void _InpByteBlock (unsigned port, unsigned char * buffer, unsigned length) {

  int tgt;
  tgt = GetTarget( port, capi_card->base );
  
  if( Target[tgt].pFunc )
    Target[tgt].pFunc( port - capi_card->base, length, buffer, 0, 1 );
} /* InpByteBlock */

void _OutpByteBlock (unsigned port, unsigned char * buffer, unsigned length) {

  int tgt;
  tgt = GetTarget( port, capi_card->base );
  if( Target[tgt].pFunc )
    Target[tgt].pFunc( port - capi_card->base, length, buffer, 1, 1 );
} /* OutpByteBlock */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
void _InpDWordBlock (unsigned port, unsigned char * buffer, unsigned length) {



} /* InpDWordBlock */

void _OutpDWordBlock (unsigned port, unsigned char * buffer, unsigned length) {
} /* OutpDWordBlock */

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/

