#include <stdio.h>
#include <stdarg.h>
#ifdef _LINUX_
#include <signal.h>
#include <unistd.h>
#endif

#include "lib.h"
#include "driver.h"
#include "io.h"
#include "tools.h"
#include "libstub.h"

#include <linuxcapi.h>

#include <c20req.h>
#include <c20ind.h>
#include <start.h>

card_t *capi_card;
lib_callback_t *capi_lib;
int timer_irq_enabled = 0;
char TrojaHook[7];
PFAX pFaxList = NULL;

void scheduler_control (unsigned ena) {
  int	enabled = (int) ena;
  int	changed;
  
  //  TRACE(("sched_control %d\n", ena ));
  enter_critical ();
  changed = (timer_irq_enabled != enabled);
  if (changed) {
    timer_irq_enabled = enabled;
    (*capi_lib->cm_timer_irq_control) (enabled);
  }
  leave_critical ();
} /* scheduler_control */


static functions_t	cafuncs = {
	
	1,
	scheduler_control,
	NULL
} ;

void UnHook( void *pOld, unsigned char *pData )
{
  unsigned char *pbOld = ( unsigned char *)pOld;
  memcpy( pbOld, pData, 7 );
}


void Hook( void *pOld, void *pNew, unsigned char *pData  )
{
  unsigned char *pbOld = ( unsigned char *)pOld;
  unsigned short reg = 0;
#ifdef _LINUX_
  __asm__ ( "mov %%cs, %0;"
             :"=r"(reg)
             );
#else
  _asm mov reg, cs;
#endif
  if( pData )
    memcpy( pData, pbOld, 7 );

  TRACE(("reg: %x\n", reg ));
  TRACE(( "Hook: old: %08lX new: %08lX\n", (unsigned long)pOld, 
	  (unsigned long)pNew ));
  *pbOld++ = 0xEA;
  *(( unsigned long *)pbOld ) = (unsigned long)pNew;  
  pbOld += 4;
  *(( unsigned short *)pbOld ) = reg;  
  TRACE(( "pOld: %lx\n", *((unsigned long *)pOld)));

}

void WriteCodeData( void *pOld, int offset, int count, unsigned char bData  )
{
  unsigned char *pbOld = ( unsigned char *)pOld;
  int i; 
  for( i = 0; i < count; i++ )
    pbOld[i+offset] = bData;
}

int TrojaCheckCall( unsigned a, unsigned b, unsigned c, unsigned d );

int _TrojaCheckCall( unsigned a, unsigned b, unsigned c, unsigned d )
{
  TRACE(("_TrojaCheckCall %x %x %x %x\n", *((unsigned *)a), b, c, d ));
  //  UnHook( TrojaCheckCall, TrojaHook );
  //TrojaCheckCall( a, b, c, d );
  TRACE(("_TrojaCheckCall %x %x %x %x\n", *((unsigned *)a), b, c, d ));
  return 0;
}

/*---------------------------------------------------------------------------*\
\*---------------------------------------------------------------------------*/
static void scan_version (card_t * card, const char * ver) {
	int	vlen, i;
	char *	vstr;

	vlen = (unsigned char) ver[0];
	card->version = vstr = (char *) hmalloc (vlen);
	if (NULL == card->version) {
		TRACE(("Could not allocate version buffer.\n"));
		return;
	}
	memcpy (card->version, ver + 1, vlen);
	i = 0;
	for (i = 0; i < 8; i++) {
		card->string[i] = vstr + 1;
		vstr += 1 + *vstr;
	} 
#ifdef NDEBUG
	printl ("Stack version %s\n", card->string[0]);
#endif
	printl  ("Library version:    %s\n", card->string[0]);
	printl  ("Card type:          %s\n", card->string[1]);
	printl  ("Capabilities:       %s\n", card->string[4]);
	printl  ("D-channel protocol: %s\n", card->string[5]);
} /* scan_version */


unsigned char GetBChannel( card_t *capi )
{
  unsigned char i;
  
  for( i = 1; i < 4; i++ )
    {
      if( capi->bChannel[i] == 0 )
	{
	  capi->bChannel[i] = 1;
	  break;
	}
    }
  if( i > 2 )
    i = 0xFF;
  return i;
} 

void PutBChannel( card_t *capi, unsigned char ch )
{
  capi->bChannel[ch] = 0;
} 

PFAX FaxFindEntityByChannel( unsigned long dwPlci )
{
  PFAX pFax = pFaxList;
  dwPlci >>= 16;
  dwPlci &= 0xFF;
  while( pFax )
    {
      if( pFax->bCh == dwPlci ) 
	break;
      pFax = pFax->pNext;
    }
  return pFax;
}

int TxFax( unsigned char *pData, unsigned len, unsigned hscx )
{
  PFAX pFax = FaxFindEntityByChannel( hscx );
  if( pFax )
    {
      if( pFax->length < ( B3_BLOCKS * 2048 ) )
	{
	  memcpy( pFax->pDataBufw, pData, len );
	  pFax->length += len;
	  pFax->blocklength += len;
	  pFax->pDataBufw += len;
	  if( pFax->pDataBufw >= &pFax->DataBuf[2048 * B3_BLOCKS] )
	    pFax->pDataBufw = pFax->DataBuf;
	}
      else
	TRACE(("TxFax: FATAL buffer overflow for hscx: %lx\n", hscx ));
    }
  else
    {
      PFAX pFax = pFaxList;
      TRACE(("TxFax: FATAL can't find fax entity for hscx: %lx\n", hscx ));

  
      while( pFax )
	{
	  TRACE(("Appl: %d plci %x\n", pFax->wApplId, pFax->dwPlci ));
	  pFax = pFax->pNext;
	}

    }
  return 0;
}

int RxFax( unsigned char *pData, unsigned len, unsigned hscx )
{
  PFAX pFax = FaxFindEntityByChannel( hscx );
  if( pFax )
    {
      if( pFax->pRxData )
	{
	  memcpy( pData, pFax->pRxData, len );
	  pFax->pRxData += len;
	}
      else
	TRACE(("RxFax: FATAL pRxData == NULL hscx: %lx\n", hscx ));

    }
  else
    TRACE(("RxFax: FATAL can't find fax entity for hscx: %lx\n", hscx ));
  return 0;
}


int faxstarted = 0;

int FaxStart( DATA_FUNC TxCB, DATA_FUNC RxCB )
{
  char *sVer;
  
  if( faxstarted )
    return 0;
  
  if( !Ret.pFunc[0] )
    return -1;

  faxstarted = 1;
  TRACE(("FaxStart\n"));

  capi_card = hcalloc( sizeof( card_t ));
  capi_card->base = 0x300;
  capi_card->pMsgRead = capi_card->msgbuf;
  capi_card->pMsgWrite = capi_card->msgbuf;
  capi_card->pMsgEnd = capi_card->msgbuf + 256 * 16;

  capi_card->pFrmRead = capi_card->frmbuf;
  capi_card->pFrmWrite = capi_card->frmbuf;
  capi_card->pFrmEnd = capi_card->frmbuf + 256 * 8;
  
  capi_card->piFrmRead = capi_card->ifrmbuf;
  capi_card->piFrmWrite = capi_card->ifrmbuf;
  capi_card->piFrmEnd = capi_card->ifrmbuf + 256 * 8;
  
  capi_card->rec_cnt = 0;
  capi_card->snd_cnt = 0;

  capi_card->RxCB = RxFax;
  capi_card->TxCB = TxFax;

  table_init (&capi_card->appls);

  Hook( Ret.pFunc[2], _OutpByte, NULL );
  Hook( Ret.pFunc[3], _InpByte, NULL );
  Hook( Ret.pFunc[4], _OutpByteBlock, NULL );
  Hook( Ret.pFunc[5], _InpByteBlock, NULL );
  WriteCodeData( Ret.pFunc[7], 0x19, 1, 0xCA );
  WriteCodeData( Ret.pFunc[7], 0x1d, 1, 0x55 );
  WriteCodeData( Ret.pFunc[7], 0x21, 1, 0x55 );
  WriteCodeData( Ret.pFunc[7], 0x2b, 1, 0x00 );
  WriteCodeData( Ret.pFunc[7], 0x2f, 1, 0x00 );
  WriteCodeData( Ret.pFunc[8], 0xa1, 1, 0x00 );
  target_init();
  capi_lib = link_library ();

  (*capi_lib->cm_register_ca_functions) (&cafuncs);

  (*capi_lib->cm_start) ();

  sVer = (*capi_lib->cm_init) ( capi_card->base, 5);
  
  TRACE(("Version: %s\n", sVer ));
  scan_version( capi_card, sVer );

  if ((*capi_lib->cm_activate) ()) {
    TRACE(("Activate failed.\n"));
    return -1;
  }

  (*capi_lib->cm_handle_events) ();
  return 0;
}

int FaxStop( void )
{
  if( !faxstarted )
    return 0;

  free_library ();  
  hfree( capi_card );
  return 0;
}


PFAX FaxNewEntity( unsigned short wApplId, 
		   unsigned char *pBProt, 
		   unsigned dwPlci )
{

  PFAX pFax = hcalloc( sizeof( FAX ));
  unsigned char *pB1Protocol;
  unsigned char *pB2Protocol;
  unsigned char *pB3Protocol;
  unsigned short wBLength, wB1Length, wB2Length, wB3Length, wMaxBitRate;
  
  TRACE(("FaxNewEntity: appl: %d plci: %lx pFax: %lx\n", 
	 wApplId, dwPlci, pFax ));
  if( pFax )
    {
      if( dwPlci )
	pFax->fInbound = 1;
      else
	pFax->fInbound = 0;

      pFax->fStartSend = 0;
      pFax->wApplId = wApplId;
      pFax->dwPlci = dwPlci;

      pB1Protocol = pBProt + 7;
      wB1Length = *pB1Protocol++;
      pB2Protocol = pB1Protocol + wB1Length;
      wB2Length = *pB2Protocol++;
      pB3Protocol = pB2Protocol + wB2Length;
      wB3Length = *pB3Protocol++;
      *(unsigned short *)(pB3Protocol+2) = 0;
      wMaxBitRate = *(unsigned short *)(pB1Protocol);

      if( wMaxBitRate > 0 && wMaxBitRate < 2400 )
	*(unsigned short *)(pB1Protocol) = wMaxBitRate * 2400;

      memcpy( pFax->BProt, pBProt, 7 );
      pFax->BProt[7] = 0x08;
      memcpy( &pFax->BProt[8], pB1Protocol, wB1Length );
      pFax->BProt[8+8] = 0x00;
      pFax->BProt[8+9] = wB3Length;
      memcpy( &pFax->BProt[8+10], pB3Protocol, wB3Length );
      pFax->BProt[0] = 9 + 8 + wB2Length + wB3Length;
   
      pFax->pDataBufw = pFax->DataBuf;
      pFax->pDataBufr = pFax->DataBuf;
      pFax->length = 0;
      pFax->byteswritten = 0;
      pFax->pRxData = NULL;
      pFax->pRxDataEnd = NULL;

      pFax->msgbuf[(2048+ 256)*8];
      pFax->pMsgRead = pFax->msgbuf;
      pFax->pMsgWrite = pFax->msgbuf;
      pFax->pMsgEnd = &pFax->msgbuf[(2048+ 256)*8];

      pFax->pNext = pFaxList;
      pFaxList = pFax;
    }
  return pFax;
}

PFAX FaxFindEntity( unsigned short wApplId, unsigned long dwPlci,
		    unsigned long dwPlciMask )
{
  PFAX pFax = pFaxList;
  
  while( pFax )
    {
      if( wApplId == pFax->wApplId || 
	  ( dwPlci && ( pFax->dwPlci & dwPlciMask ) == dwPlci ))
	break;
      pFax = pFax->pNext;
    }
  return pFax;
}

void FaxFreeEntity( PFAX pFax )
{
  PFAX pTmp = pFaxList;
  TRACE(("FaxFreeEntity: pFax: %lx\n", pFax ));

  if( pFax->fStarted )
    FaxStopConnection( pFax );

  if( pFaxList == pFax )
    pFaxList = pFax->pNext;
  else
    {
      while( pTmp )
	{
	  if( pTmp->pNext == pFax )
	    break;
	  pTmp = pTmp->pNext;
	}
      if( pTmp )
	pTmp->pNext = pTmp->pNext->pNext;
      
      hfree( pFax );
    }
}

unsigned long FaxStartConnection( PFAX pFax )
{
  TRACE(("StartFaxConnection\n" ));
  if( !pFax )
    return 0xFFFFFFFF;

  TRACE(("FaxStartConnection : %lx\n", pFax ));
  Register_Appl( pFax->wApplId, capi_card, 4, 2048 );

  pFax->fStarted = 1;

  pFax->bCh = GetBChannel( capi_card );

  if( !pFax->fInbound )
    {
      unsigned char num[5];
      num[0] = 0x04; num[1] = 0x80; num[2] = 0x32; num[4] = 0x00;
      num[3] = 0x30 | pFax->bCh;
 
      SF_CONNECT_REQ( pFax->wApplId, 1, 1, 
		      1, num, "", "", "", 
		      pFax->BProt, "", "", "", 
		      "" );
      FaxPoll( 4 );
    }
  else
    {
      unsigned long dwTmpPlci = pFax->bCh;
      dwTmpPlci <<= 16;
      dwTmpPlci |= ( pFax->dwPlci & 0xFFFF ); 

      SF_LISTEN_REQ( pFax->wApplId,
		     1,
		     1,
		     0,
		     0xFF,
		     0,
		     "",
		     "" );
      FaxPoll( 4 );
      Ring( dwTmpPlci );
    }
  return 0;
} 

unsigned long TestStartConnection( int passive )
{
  TRACE(("StartFaxConnection\n" ));

  Register_Appl(1, capi_card, 4, 2048 );
  TRACE(("StartFaxConnection do connect\n" ));
  SF_CONNECT_REQ( 1, 1, 1, 
	       1, "\x04\x80\x32\x30\x00", "", "", "", 
	       "\x09\x01\x00\x01\x00\x00\x00\x00\x00\x00", "", "", "", 
	       "" );
  TRACE(("StartFaxConnection do schedule\n" ));
  FaxPoll( 4 );
  return 0;
} 


void FaxDisconnect( PFAX pFax )
{
  D_Disconnect( pFax->dwPlciInternal, capi_card );
}

unsigned long FaxStopConnection( PFAX pFax )
{
  int i = 1000;
  TRACE(("FaxStopConnection : %lx\n", pFax ));
  PutBChannel( capi_card, pFax->bCh );
  D_Disconnect( pFax->dwPlciInternal, capi_card );
  while( i > 0 )
   {
     FaxPoll(7);
     i--;
   }
  Release_Appl( pFax->wApplId, capi_card ); 
  pFax->fStarted = 0;
  i = 1000;
  while( i > 0 )
   {
     if( 0x01 & GetHscxFlags( pFax->dwPlci ))
       NextB3Write( pFax->dwPlci );
     FaxPoll(7);
     i--;
   }
  TRACE(("FaxStopConnection : %ld\n", i ));
  return 0;
}

unsigned long FaxPoll( unsigned param )
{
#ifndef USE_THREAD
  timercb( param );
#endif
  return 0;
}


unsigned FaxProcessDataConf( PFAX pFax, unsigned short whData)
{
  //  TRACE(("FaxProcessDataConf for fax: %08X %d\n", pFax, pFax->wDataLen[whData] ));
  if( pFax )
    {
      FaxPoll(3);
      pFax->length -= pFax->wDataLen[whData];
      if( pFax->length <= 0 && pFax->fDisconnect )
	{
	  return 1;
	}
      else
	return 0;
    }
  else
    TRACE(("FaxProcessDataConf called with fax == NULL\n" ));
  return 0xFFFFFFFF;
}

unsigned FaxProcessDataInd( PFAX pFax, 
			    unsigned char *pData, unsigned short length )
{
  int len = 0;
  int count = 0;
  if( pFax )
    {
      int doWrite = 1, j;
      unsigned short i = (length >> 3 );
      pFax->pRxData = pData;
      pFax->pRxDataEnd = pData + length;

      while( pFax->pRxData < pFax->pRxDataEnd  && i > 0 )
	{
	  if( doWrite )
	    NextB3Write( pFax->bCh );
	  NextB3Read( pFax->bCh );
	  FaxPoll(3);
	  i--;
	  count++;
	  if( pFax->length % 2048 )
	    doWrite = 1;
	  else
	    doWrite = 0;
	}
      //      TRACE(("count %d for fax: %x\n", count, pFax ));
      //GetRWCount( pFax->dwPlci );
#if 0      
      for( j = 0; j < 256; j++ )
	{
	  FaxPoll(3);
	}
#endif

      if( pFax->length > ( 2048 * ( B3_BLOCKS - 2 )))
	pFax->fStartSend = 1;

      if( pFax->fStartSend )
	{
	  len = (int)pFax->pDataBufw - (int)pFax->pDataBufr;
	  if( len < 0 )
	    {
	      len += ( 2048 * B3_BLOCKS );
	    }
	  if( len == 0 )
	    TRACE(("no more tx data\n" ));

	}
      return len;
    }
  else
    {
      TRACE(("FaxProcessDataInd called with fax == NULL\n" ));
      return 0xFFFFFFFF;
    }
}

unsigned Fax_Get_Message( PFAX pFax, unsigned char **Buf)
{

  if( pFax->pMsgRead[0] == 1 )
    {
      unsigned short cmd = *((unsigned short *)( &pFax->pMsgRead[5] ));
      unsigned long dwMask;
      if( cmd & 0x0080 )
	dwMask = 0xFFFFFFFF;
      else
	dwMask = 0x0000FFFF;
      CONNECT_B3_IND_NCCI(&pFax->pMsgRead[1]) = pFax->dwPlci & dwMask;
      *Buf = &pFax->pMsgRead[1];
      pFax->pMsgRead[0] = 0;
      pFax->pMsgRead += (256+2048);
      if( pFax->pMsgRead >= pFax->pMsgEnd )
	pFax->pMsgRead = pFax->msgbuf;
	  
      return 0;
    }  
  else
    {
      return 0x1104;
    }
}


unsigned Fax_Put_Message_Internal( PFAX pFax, unsigned char *Buf)
{

  if( !pFax->pMsgWrite[0] )
    {
      unsigned short wCommand = CAPI_COMMAND( Buf );
      if( wCommand == _DATA_B3_IND )
	{
	  memcpy( &pFax->pMsgWrite[256], (char *)DATA_B3_IND_DATA(Buf),
		  DATA_B3_IND_DATA_LENGTH(Buf));
	  DATA_B3_IND_DATA(Buf) = (unsigned)&pFax->pMsgWrite[256];
	}
      memcpy( &pFax->pMsgWrite[1], Buf, CAPI_MESSAGE_LENGTH(Buf));
      pFax->pMsgWrite[0] = 1;
      pFax->pMsgWrite += (256+2048);
      if( pFax->pMsgWrite >= pFax->pMsgEnd )
	pFax->pMsgWrite = pFax->msgbuf;
      return 0;
    }  
  else
    {
      TRACE(("Fax_Put_Message queue overflow\n" ));
      return 0x1104;
    }
}

unsigned Fax_Put_Message( PFAX pFax, unsigned char *Buf)
{
  CONNECT_B3_IND_NCCI(Buf) = pFax->dwPlciInternal;
  return FaxPutMsg( 0, Buf );
}



