#include <stdio.h>
//#include <stdarg.h>
//#include <signal.h>
//#include <unistd.h>

#include "lib.h"
#include "driver.h"
#include "io.h"
#include "tools.h"

#include <linuxcapi.h>

#include <c20req.h>
#include <c20ind.h>
#include <sfax.h>

void HandleCapiMsg( unsigned char *pMsg )
{
  unsigned long dwNCCIcode = 0;
  unsigned short wCommand = CAPI_COMMAND( pMsg );
  unsigned short appl_id = CAPI_APPL_ID(pMsg);
  unsigned short wNumber = CAPI_MESSAGE_NUMBER(pMsg);
  PFAX pFax = FaxFindEntity( appl_id, 0, 0 );
  
  wNumber++;
  switch( wCommand )
    {
    case _LISTEN_CONF:
      TRACE(("ListenConf: %x\n", LISTEN_CONF_INFO(pMsg) ));
      break;

    case _CONNECT_CONF:
      TRACE(("ConnectConf: %x\n", CONNECT_CONF_INFO(pMsg) ));
      break;

    case _CONNECT_ACTIVE_IND:
      SF_CONNECT_ACTIVE_RESP( appl_id, wNumber++, 
			      CONNECT_ACTIVE_IND_PLCI(pMsg) );
      
      TRACE(("_CONNECT_ACTIVE_IND %d\n", appl_id ));
      if( pFax )
	{
	  pFax->dwPlciInternal = CONNECT_ACTIVE_IND_PLCI( pMsg );
	}
      if( !pFax->fInbound )
	SF_CONNECT_B3_REQ( appl_id, wNumber, 
			   CONNECT_ACTIVE_IND_PLCI(pMsg), 
			   (unsigned char *)"" );
      break;

    case _CONNECT_B3_CONF:
      TRACE(("_CONNECT_B3_CONF %x\n", CONNECT_B3_CONF_INFO(pMsg) ));
      if( pFax )
	{
	  pFax->dwPlciInternal = CONNECT_B3_CONF_NCCI( pMsg );
	}
      dwNCCIcode = CONNECT_B3_CONF_NCCI( pMsg );
      break;

    case _CONNECT_B3_ACTIVE_IND:
      {
	TRACE(("_CONNECT_B3_ACTIVE_IND %lx\n", pFax ));
	if( pFax )
	  {
	    pFax->dwPlciInternal = CONNECT_B3_ACTIVE_IND_NCCI(pMsg);
	    Fax_Put_Message_Internal( pFax, pMsg );
	  }
	else
	  TRACE(("_CONNECT_B3_ACTIVE_IND: no pFax %lx %d\n", pFax, appl_id ));
	
	//SF_CONNECT_B3_ACTIVE_RESP( appl_id, wNumber, 
	//	     CONNECT_B3_ACTIVE_IND_NCCI(pMsg));
      }
      break;
	    
    case _CONNECT_IND:
      {
	TRACE(("_CONNECT_IND %d\n", appl_id ));
	if( pFax )
	  {
	    DumpBuffer( pFax->BProt, pFax->BProt[0] + 1);
	    SF_CONNECT_RESP( appl_id, wNumber, 
			     CONNECT_IND_PLCI( pMsg ),
			     0, 
			     pFax->BProt,
			     (unsigned char *)"",(unsigned char *)"",(unsigned char *)"",
			     (unsigned char *)"");
	  }
	else
	  TRACE(("_CONNECT_IND pFax = NULL\n" ));
      }
      break;

    case _CONNECT_B3_IND:
      TRACE(("_CONNECT_B3_IND %d\n", appl_id ));
      if( pFax )
	{
	  pFax->dwPlciInternal = CONNECT_B3_IND_NCCI( pMsg );
	}	    
      dwNCCIcode = CONNECT_B3_IND_NCCI( pMsg );
      SF_CONNECT_B3_RESP( appl_id, wNumber, 
		      dwNCCIcode, 0, (unsigned char *)"" );
      break;

    case _DATA_B3_IND:
      {
	TRACE(("_DATA_B3_IND %d %d\n", appl_id, DATA_B3_IND_DATA_LENGTH(pMsg) ));
	DumpBuffer( DATA_B3_IND_DATA(pMsg), 16 );
	if( pFax )
	  {
	    Fax_Put_Message_Internal( pFax, pMsg );
	  }

#if 0  
      SF_DATA_B3_RESP( appl_id, wNumber, DATA_B3_IND_NCCI(pMsg), 
		       DATA_B3_IND_DATA_HANDLE( pMsg ));

    SF_DATA_B3_REQ(  appl_id,
			 1,
			 DATA_B3_IND_NCCI( pMsg ),
			 DATA_B3_IND_DATA(pMsg),
			 DATA_B3_IND_DATA_LENGTH(pMsg),
			 1,
			 0 );
#endif
      }
      break;

    case _DATA_B3_CONF:
      {
	TRACE(("_DATA_B3_CONF %d\n", appl_id ));
	if( pFax )
	  {
	    Fax_Put_Message_Internal( pFax, pMsg );
	  }
      }
      break;

    case _DISCONNECT_IND:
      TRACE(("_DISCONNECT_IND %d %X\n",  
	     appl_id, DISCONNECT_IND_REASON( pMsg ) ));
      SF_DISCONNECT_RESP(appl_id, wNumber, 
		      DISCONNECT_IND_PLCI( pMsg ));
      if( pFax )
	{
	  pFax->fDisconnect = 9;
	  //Fax_Put_Message_Internal( pFax, pMsg );
	}
      break;

    case _DISCONNECT_B3_IND:
      {
	TRACE(("_DISCONNECT_B3_IND %d %X\n",  
	       appl_id, DISCONNECT_B3_IND_REASON_B3( pMsg ) ));
	if( pFax )
	  {
	    Fax_Put_Message_Internal( pFax, pMsg );
	  }
	
	SF_DISCONNECT_B3_RESP( appl_id, wNumber++, 
			       DISCONNECT_B3_IND_NCCI( pMsg ));
#if 0
	SF_DISCONNECT_REQ( appl_id, wNumber, 
			   DISCONNECT_B3_IND_NCCI( pMsg ), 
			   (unsigned char *)"");
#endif
      }
      break;

    case _DISCONNECT_B3_CONF:
      {
	TRACE(("_DISCONNECT_B3_CONF %d\n", appl_id ));
	if( pFax )
	  {
	    Fax_Put_Message_Internal( pFax, pMsg );
	  }
      }
      break;

    case _DISCONNECT_CONF:
      break;

    default:
      TRACE(("unexpected message: %x\n", wCommand ));
      break;
    } 
}
