#ifndef __C20REQ_H__
#define __C20REQ_H__


#ifndef WIN32
 #define CAPIRET	WORD
#else
 #define CAPIRET DWORD
#endif
/*------------------------------------------------------------/
/ CAPI_LISTEN_REQUEST info Mask
/------------------------------------------------------------*/
#define CAPI20_INFOMASK_CAUSE                   0x00000001
#define CAPI20_INFOMASK_DATETIME                0x00000002
#define CAPI20_INFOMASK_DISPLAY                 0x00000004
#define CAPI20_INFOMASK_USERTOUSER              0x00000008
#define CAPI20_INFOMASK_CALLPROGRESSION         0x00000010
#define CAPI20_INFOMASK_FACILITYINFO            0x00000020
#define CAPI20_INFOMASK_CHARGINGINFO            0x00000040

/*------------------------------------------------------------/
/ CAPI_LISTEN_REQUEST           CIP Mask
/------------------------------------------------------------*/
#define CAPI20_CIPMASK_ALL                     0x00000001
#define CAPI20_CIPMASK_TELPHONY_APP            0x00010012
#define CAPI20_CIPMASK_FAX_GRP_2_3_APP         0x00020010
#define CAPI20_CIPMASK_FAX_GRP_4_APP           0x00040004
#define CAPI20_CIPMASK_RAW_64KBIT_APP          0x00000004
#define CAPI20_CIPMASK_RAW_56KBIT_APP          0x00000100




#ifndef _BIG_ENDIAN_

/*------------------------------------------------------------/
/ CAPI Messages
/------------------------------------------------------------*/
#define _ALERT_REQ                    0x8001
#define _CONNECT_REQ                  0x8002
#define _CONNECT_RESP                 0x8302
#define _CONNECT_ACTIVE_RESP          0x8303
#define _CONNECT_B3_ACTIVE_RESP       0x8383
#define _CONNECT_B3_REQ               0x8082
#define _CONNECT_B3_RESP              0x8382
#define _CONNECT_B3_T90_ACTIVE_RESP   0x8388
#define _DATA_B3_REQ                  0x8086
#define _DATA_B3_RESP                 0x8386
#define _DISCONNECT_B3_REQ            0x8084
#define _DISCONNECT_B3_RESP           0x8384
#define _DISCONNECT_REQ               0x8004
#define _DISCONNECT_RESP              0x8304
#define _FACILITY_REQ                 0x8080
#define _FACILITY_RESP                0x8380
#define _INFO_REQ                     0x8008
#define _INFO_RESP                    0x8308
#define _LISTEN_REQ                   0x8005
#define _MANUFACTURER_REQ             0x80FF
#define _MANUFACTURER_RESP            0x83FF
#define _RESET_B3_REQ                 0x8087
#define _RESET_B3_RESP                0x8387
#define _SELECT_B_PROTOCOL_REQ        0x8041


#else

/*------------------------------------------------------------/
/ CAPI Messages
/------------------------------------------------------------*/
#define _ALERT_REQ                    0x0180
#define _CONNECT_REQ                  0x0280
#define _CONNECT_RESP                 0x0283
#define _CONNECT_ACTIVE_RESP          0x0383
#define _CONNECT_B3_ACTIVE_RESP       0x8383
#define _CONNECT_B3_REQ               0x8280
#define _CONNECT_B3_RESP              0x8283
#define _CONNECT_B3_T90_ACTIVE_RESP   0x8883
#define _DATA_B3_REQ                  0x8680
#define _DATA_B3_RESP                 0x8683
#define _DISCONNECT_B3_REQ            0x8480
#define _DISCONNECT_B3_RESP           0x8483
#define _DISCONNECT_REQ               0x0480
#define _DISCONNECT_RESP              0x0483
#define _FACILITY_REQ                 0x8080
#define _FACILITY_RESP                0x8083
#define _INFO_REQ                     0x0880
#define _INFO_RESP                    0x0883
#define _LISTEN_REQ                   0x0580
#define _MANUFACTURER_REQ             0xFF80
#define _MANUFACTURER_RESP            0xFF83
#define _RESET_B3_REQ                 0x8780
#define _RESET_B3_RESP                0x8783
#define _SELECT_B_PROTOCOL_REQ        0x4180

#endif


/*------------------------------------------------------------/
/
/------------------------------------------------------------*/
CAPIRET  SF_ALERT_REQ( WORD   wApplID,
                 WORD   wMsgNoAppl,
                 DWORD  dwPLCI,
                 STRUCT lpAdditionalInfo );

CAPIRET SF_CONNECT_REQ(   WORD   wApplID,
                    WORD   wMsgNoAppl,
                    DWORD  dwController,
                    WORD   wCIP,
                    STRUCT lpCalledPartyNumber,
                    STRUCT lpCallingPartyNumber,
                    STRUCT lpCalledPartySubaddress,
                    STRUCT lpCallingPartySubaddress,
                    STRUCT lpB,
                    STRUCT lpBC,
                    STRUCT lpLLC,
                    STRUCT lpHLC,
                    STRUCT lpAdditionalInfo );

CAPIRET SF_CONNECT_RESP(  WORD   wApplID,
                    WORD   wMsgNr,
                    DWORD  dwPLCI,
                    WORD   wReject,
                    STRUCT lpB,
                    STRUCT lpConnectedNumber,
                    STRUCT lpConnectedSubaddress,
                    STRUCT lpLLC,
                    STRUCT lpAdditionalInfo );

CAPIRET SF_CONNECT_ACTIVE_RESP(  WORD  wApplID,
                           WORD  wMsgNr,
                           DWORD dwPLCI );

CAPIRET SF_CONNECT_B3_ACTIVE_RESP(  WORD wApplID,
                              WORD wMsgNr,
                              DWORD dwNCCI );

CAPIRET SF_CONNECT_B3_REQ(  WORD   wApplID,
                      WORD   wMsgNoAppl,
                      DWORD  dwPLCI,
                      STRUCT lpNCPI );

CAPIRET SF_CONNECT_B3_RESP(  WORD   wApplID,
                       WORD   wMsgNr,
                       DWORD  dwPLCI,
                       WORD   wReject,
                       STRUCT lpNCPI );

CAPIRET SF_CONNECT_B3_T90_ACTIVE_RESP( WORD  wApplID,
                                 WORD  wMsgNr,
                                 DWORD dwNCCI );

CAPIRET SF_DATA_B3_REQ(  WORD   wApplID,
                   WORD   wMsgNoAppl,
                   DWORD  dwNCCI,
                   LPBYTE lpData,
                   WORD   wDataLength,
                   WORD   wDataHandle,
                   WORD   wFlags );

CAPIRET SF_DATA_B3_RESP(  WORD  wApplID,
                    WORD  wMsgNr,
                    DWORD dwNCCI,
                    WORD  wDataHandle );

CAPIRET SF_DISCONNECT_B3_REQ(  WORD   wApplID,
                         WORD   wMsgNoAppl,
                         DWORD  dwNCCI,
                         STRUCT lpNCPI );

CAPIRET SF_DISCONNECT_B3_RESP(  WORD  wApplID,
                          WORD  wMsgNr,
                          DWORD dwNCCI );

CAPIRET SF_DISCONNECT_REQ(  WORD   wApplID,
                      WORD   wMsgNoAppl,
                      DWORD  dwPLCI,
                      STRUCT lpAdditionalInfo );

CAPIRET SF_DISCONNECT_RESP(  WORD  wApplID,
                       WORD  wMsgNr,
                       DWORD dwPLCI );

CAPIRET SF_FACILITY_REQ(  WORD   wApplID,
                    WORD   wMsgNoAppl,
                    DWORD  dwController,
                    WORD   wFacilitySelector,
                    STRUCT lpFacilityRequestParameter );

CAPIRET SF_FACILITY_RESP(  WORD   wApplID,
                     WORD   wMsgNr,
                     DWORD  dwController,
                     WORD   wFacilitySelector,
                     STRUCT lpFacilityResponseParameter );

CAPIRET SF_INFO_REQ(  WORD   wApplID,
                WORD   wMsgNoAppl,
                DWORD  dwPLCI,
                STRUCT lpCalledPartyNumber,
                STRUCT lpAdditionalInfo );

CAPIRET SF_INFO_RESP(  WORD wApplID,
                 WORD wMsgNr,
                 DWORD dwPLCI );

CAPIRET SF_LISTEN_REQ(  WORD wApplID,
                  WORD wMsgNoAppl,
                  DWORD dwController,
                  DWORD dwInfoMask,
                  DWORD dwCIPMask,
                  DWORD dwCIPMask2,
                  STRUCT lpCallingPartyNumber,
                  STRUCT lpCallingPartySubaddress );

CAPIRET SF_MANUFACTURER_REQ(  WORD wApplID,
                        WORD wMsgNoAppl,
                        DWORD dwController,
                        DWORD dwManuID,
                        STRUCT lpAdditionalInfo );

CAPIRET SF_MANUFACTURER_RESP(  WORD wApplID,
                         WORD wMsgNr,
                         DWORD dwController,
                         DWORD dwManuID,
                         STRUCT lpAdditionalInfo );

CAPIRET SF_RESET_B3_REQ(  WORD wApplID,
                    WORD wMsgNoAppl,
                    DWORD dwNCCI,
                    STRUCT lpNCPI );

CAPIRET SF_RESET_B3_RESP(  WORD wApplID,
                     WORD wMsgNr,
                     DWORD dwNCCI );

CAPIRET SF_SELECT_B_PROTOCOL_REQ(  WORD wApplID,
                             WORD wMsgNoAppl,
                             DWORD dwPLCI,
                             STRUCT lpBProtocol );

#endif /* #ifndef __C20REQ_H__ */
