#include <linuxcapi.h>

#include <c20req.h>

#define _MAX_MSGSIZE 512

#ifdef LOADLIB
 extern FPPUTMSG    lpputmsg;
#endif



/*-------------------------------------------------------------------------
/  Funktion  : ALERT_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET  SF_ALERT_REQ( WORD   wApplID,
                 WORD   wMsgNoAppl,
                 DWORD  dwPLCI,
                 STRUCT lpAdditionalInfo )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwPLCI;
  i+= sizeof(DWORD);

  for( j = 0; j < lpAdditionalInfo[0] + 1; j++,i++ )
    pM[i] = lpAdditionalInfo[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _ALERT_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : CONNECT_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_CONNECT_REQ( WORD   wApplID,
                  WORD   wMsgNoAppl,
                  DWORD  dwController,
                  WORD   wCIP,
                  STRUCT lpCalledPartyNumber,
                  STRUCT lpCallingPartyNumber,
                  STRUCT lpCalledPartySubaddress,
                  STRUCT lpCallingPartySubaddress,
                  STRUCT lpB,           /* B protocol */
                  STRUCT lpBC,          /* bearer capability */
                  STRUCT lpLLC,         /* low layer compatibility */
                  STRUCT lpHLC,         /* high layer compatibility */
                  STRUCT lpAdditionalInfo )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwController;
  i+= sizeof(DWORD);
  *(WORD FAR *)(pM+i) = wCIP;
  i+= sizeof(WORD);

  for( j = 0; j < lpCalledPartyNumber[0] + 1; j++,i++ )
    pM[i] = lpCalledPartyNumber[j];
  for( j = 0; j < lpCallingPartyNumber[0] + 1; j++,i++ )
    pM[i] = lpCallingPartyNumber[j];
  for( j = 0; j < lpCalledPartySubaddress[0] + 1; j++,i++ )
    pM[i] = lpCalledPartySubaddress[j];
  for( j = 0; j < lpCallingPartySubaddress[0] + 1; j++,i++ )
    pM[i] = lpCallingPartySubaddress[j];
  for( j = 0; j < lpB[0] + 1; j++,i++ )
    pM[i] = lpB[j];
  for( j = 0; j < lpBC[0] + 1; j++,i++ )
    pM[i] = lpBC[j];
  for( j = 0; j < lpLLC[0] + 1; j++,i++ )
    pM[i] = lpLLC[j];
  for( j = 0; j < lpHLC[0] + 1; j++,i++ )
    pM[i] = lpHLC[j];
  for( j = 0; j < lpAdditionalInfo[0] + 1; j++,i++ )
    pM[i] = lpAdditionalInfo[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(WORD FAR *) pM     = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _CONNECT_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;
  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : CONNECT_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_CONNECT_RESP(  WORD wApplID,
                    WORD wMsgNr,
                    DWORD dwPLCI,
                    WORD wReject,
                    STRUCT lpB,         /* B protocol */
                    STRUCT lpConnectedNumber,
                    STRUCT lpConnectedSubaddress,
                    STRUCT lpLLC,               /* low layer compatibility */
                    STRUCT lpAdditionalInfo )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwPLCI;
  i+= sizeof(DWORD);
  *(WORD FAR *)(pM+i) = wReject;
  i+= sizeof(WORD);

  for( j = 0; j < lpB[0] + 1; j++,i++ )
    pM[i] = lpB[j];
  for( j = 0; j < lpConnectedNumber[0] + 1; j++,i++ )
    pM[i] = lpConnectedNumber[j];
  for( j = 0; j < lpConnectedSubaddress[0] + 1; j++,i++ )
    pM[i] = lpConnectedSubaddress[j];
  for( j = 0; j < lpLLC[0] + 1; j++,i++ )
    pM[i] = lpLLC[j];
  for( j = 0; j < lpAdditionalInfo[0] + 1; j++,i++ )
    pM[i] = lpAdditionalInfo[j];

  *(WORD FAR *) pM     = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _CONNECT_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : CONNECT_ACTIVE_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_CONNECT_ACTIVE_RESP(  WORD wApplID,
                           WORD  wMsgNr,
                           DWORD dwPLCI )
{

  int i = 8;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwPLCI;
  i+= sizeof(DWORD);

  *(WORD FAR *) pM     = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _CONNECT_ACTIVE_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : CONNECT_B3_ACTIVE_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_CONNECT_B3_ACTIVE_RESP(  WORD wApplID,
                              WORD wMsgNr,
                              DWORD dwNCCI )
{

  int i = 8;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwNCCI;
  i+= sizeof(DWORD);

  *(WORD FAR *) pM     = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _CONNECT_B3_ACTIVE_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : CONNECT_B3_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_CONNECT_B3_REQ(  WORD wApplID,
                      WORD wMsgNoAppl,
                      DWORD dwPLCI,
                      STRUCT lpNCPI )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwPLCI;
  i+= sizeof(DWORD);

  for( j = 0; j < lpNCPI[0] + 1; j++,i++ )
    pM[i] = lpNCPI[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(WORD FAR *) pM     = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _CONNECT_B3_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : CONNECT_B3_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_CONNECT_B3_RESP(  WORD wApplID,
                       WORD wMsgNr,
                       DWORD dwPLCI,
                       WORD wReject,
                       STRUCT lpNCPI )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwPLCI;
  i+= sizeof(DWORD);
  *(WORD FAR *)(pM+i) = wReject;
  i+= sizeof(WORD);

  for( j = 0; j < lpNCPI[0] + 1; j++,i++ )
    pM[i] = lpNCPI[j];

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _CONNECT_B3_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : CONNECT_B3_T90_ACTIVE_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_CONNECT_B3_T90_ACTIVE_RESP(  WORD wApplID,
                                  WORD wMsgNr,
                                  DWORD dwNCCI )
{

  int i = 8;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwNCCI;
  i+= sizeof(DWORD);

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _CONNECT_B3_T90_ACTIVE_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : DATA_B3_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_DATA_B3_REQ(  WORD wApplID,
                   WORD wMsgNoAppl,
                   DWORD  dwNCCI,
                   LPBYTE lpData,
                   WORD   wDataLength,
                   WORD   wDataHandle,
                   WORD   wFlags )
{

  int i = 8;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwNCCI;
  i+= sizeof(DWORD);
  *(DWORD FAR *)(pM+i) = (DWORD) lpData;
  i+= sizeof(DWORD);
  *(WORD FAR *)(pM+i)  = wDataLength;
  i+= sizeof(WORD);
  *(WORD FAR *)(pM+i)  = wDataHandle;
  i+= sizeof(WORD);
  *(WORD FAR *)(pM+i)  = wFlags;
  i+= sizeof(WORD);

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _DATA_B3_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : DATA_B3_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_DATA_B3_RESP(  WORD wApplID,
                    WORD wMsgNr,
                    DWORD dwNCCI,
                    WORD wDataHandle )
{

  int i = 8;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwNCCI;
  i+= sizeof(DWORD);
  *(WORD FAR *)(pM+i) = wDataHandle;
  i+= sizeof(WORD);

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _DATA_B3_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : DISCONNECT_B3_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_DISCONNECT_B3_REQ(  WORD wApplID,
                         WORD wMsgNoAppl,
                         DWORD dwNCCI,
                         STRUCT lpNCPI )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwNCCI;
  i+= sizeof(DWORD);

  for( j = 0; j < lpNCPI[0] + 1; j++,i++ )
    pM[i] = lpNCPI[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _DISCONNECT_B3_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : DISCONNECT_B3_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_DISCONNECT_B3_RESP(  WORD wApplID,
                          WORD wMsgNr,
                          DWORD dwNCCI )
{

  int i = 8;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwNCCI;
  i+= sizeof(DWORD);

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _DISCONNECT_B3_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : DISCONNECT_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_DISCONNECT_REQ(  WORD wApplID,
                      WORD wMsgNoAppl,
                      DWORD dwPLCI,
                      STRUCT lpAdditionalInfo )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwPLCI;
  i+= sizeof(DWORD);

  for( j = 0; j < lpAdditionalInfo[0] + 1; j++,i++ )
    pM[i] = lpAdditionalInfo[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _DISCONNECT_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : DISCONNECT_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_DISCONNECT_RESP(  WORD wApplID,
                       WORD wMsgNr,
                       DWORD dwPLCI )
{

  int i = 8;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwPLCI;
  i+= sizeof(DWORD);

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _DISCONNECT_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : FACILITY_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/

void _trace( const char * pszFmt, ...);


CAPIRET SF_FACILITY_REQ(  WORD wApplID,
                    WORD wMsgNoAppl,
                    DWORD dwController,
                    WORD wFacilitySelector,
                    STRUCT lpFacilityRequestParameter )
{

  int i = 8;
  int j;
  int len = lpFacilityRequestParameter[0];
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwController;
  i+= sizeof(DWORD);
  *(WORD FAR *)(pM+i) = wFacilitySelector;
  i+= sizeof(WORD);
  for( j = 0; j < len + 1; j++,i++ )
    pM[i] = lpFacilityRequestParameter[j];
  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;
  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _FACILITY_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : FACILITY_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_FACILITY_RESP(  WORD wApplID,
                     WORD wMsgNr,
                     DWORD dwController,
                     WORD wFacilitySelector,
                     STRUCT lpFacilityResponseParameter )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwController;
  i+= sizeof(DWORD);
  *(WORD FAR *)(pM+i) = wFacilitySelector;
  i+= sizeof(WORD);

  for( j = 0; j < lpFacilityResponseParameter[0] + 1; j++,i++ )
    pM[i] = lpFacilityResponseParameter[j];

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _FACILITY_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : INFO_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_INFO_REQ(  WORD wApplID,
                WORD wMsgNoAppl,
                DWORD dwPLCI,
                STRUCT lpCalledPartyNumber,
                STRUCT lpAdditionalInfo )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwPLCI;
  i+= sizeof(DWORD);

  for( j = 0; j < lpCalledPartyNumber[0] + 1; j++,i++ )
    pM[i] = lpCalledPartyNumber[j];
  for( j = 0; j < lpAdditionalInfo[0] + 1; j++,i++ )
    pM[i] = lpAdditionalInfo[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _INFO_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : INFO_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_INFO_RESP(  WORD wApplID,
                 WORD wMsgNr,
                 DWORD dwPLCI )
{

  int i = 8;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwPLCI;
  i+= sizeof(DWORD);

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _INFO_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : LISTEN_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_LISTEN_REQ(  WORD wApplID,
                  WORD wMsgNoAppl,
                  DWORD dwController,
                  DWORD dwInfoMask,
                  DWORD dwCIPMask,
                  DWORD dwCIPMask2,
                  STRUCT lpCallingPartyNumber,
                  STRUCT lpCallingPartySubaddress )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwController;
  i+= sizeof(DWORD);
  *(DWORD FAR *)(pM+i) = dwInfoMask;
  i+= sizeof(DWORD);
  *(DWORD FAR *)(pM+i) = dwCIPMask;
  i+= sizeof(DWORD);
  *(DWORD FAR *)(pM+i) = dwCIPMask2;
  i+= sizeof(DWORD);

  for( j = 0; j < lpCallingPartyNumber[0] + 1; j++,i++ )
    pM[i] = lpCallingPartyNumber[j];
  for( j = 0; j < lpCallingPartySubaddress[0] + 1; j++,i++ )
    pM[i] = lpCallingPartySubaddress[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _LISTEN_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : MANUFACTURER_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_MANUFACTURER_REQ(  WORD wApplID,
                        WORD wMsgNoAppl,
                        DWORD dwController,
                        DWORD dwManuID,
                        STRUCT lpAdditionalInfo )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];
  CAPIRET wRet;

  *(DWORD FAR *)(pM+i) = dwController;
  i+= sizeof(DWORD);
  *(DWORD FAR *)(pM+i) = dwManuID;
  i+= sizeof(DWORD);

  for( j = 0; j < lpAdditionalInfo[0] + 1; j++,i++ )
    pM[i] = lpAdditionalInfo[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _MANUFACTURER_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;

  wRet = CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );

  i = 16;
  for( j = 0; j < lpAdditionalInfo[0] + 1; j++,i++ )
    lpAdditionalInfo[j] = pM[i];
  
  return wRet;
}

/*-------------------------------------------------------------------------
/  Funktion  : MANUFACTURER_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_MANUFACTURER_RESP(  WORD wApplID,
                         WORD wMsgNr,
                         DWORD dwController,
                         DWORD dwManuID,
                         STRUCT lpAdditionalInfo )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwController;
  i+= sizeof(DWORD);
  *(DWORD FAR *)(pM+i) = dwManuID;
  i+= sizeof(DWORD);

  for( j = 0; j < lpAdditionalInfo[0] + 1; j++,i++ )
    pM[i] = lpAdditionalInfo[j];

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _MANUFACTURER_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : RESET_B3_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_RESET_B3_REQ(  WORD wApplID,
                    WORD wMsgNoAppl,
                    DWORD dwNCCI,
                    STRUCT lpNCPI )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwNCCI;
  i+= sizeof(DWORD);

  for( j = 0; j < lpNCPI[0] + 1; j++,i++ )
    pM[i] = lpNCPI[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _RESET_B3_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : RESET_B3_RESP
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_RESET_B3_RESP(  WORD wApplID,
                     WORD   wMsgNr,
                     DWORD  dwNCCI )
{

  int i = 8;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwNCCI;
  i+= sizeof(DWORD);

  *(WORD FAR *) pM  = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _RESET_B3_RESP;
  *(WORD FAR *) (pM+6) = wMsgNr;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

/*-------------------------------------------------------------------------
/  Funktion  : SELECT_B_PROTOCOL_REQ
/--------------------------------------------------------------------------
/  Inhalt    :
/  Parameter :
/  Rueckgabe :
/    0x0000            No error
/    All other values  Coded as described in parameter info class 0x11xx
/--------------------------------------------------------------------------
/  Geaendert :
/------------------------------------------------------------------------*/
CAPIRET SF_SELECT_B_PROTOCOL_REQ(  WORD wApplID,
                             WORD wMsgNoAppl,
                             DWORD dwPLCI,
                             STRUCT lpBProtocol )
{

  int i = 8;
  int j;
  BYTE pM[_MAX_MSGSIZE];

  *(DWORD FAR *)(pM+i) = dwPLCI;
  i+= sizeof(DWORD);
  for( j = 0; j < lpBProtocol[0] + 1; j++,i++ )
    pM[i] = lpBProtocol[j];

  if (wMsgNoAppl >= 0x7FFF) wMsgNoAppl = 0;

  *(WORD FAR *) pM = (WORD) i;
  *(WORD FAR *) (pM+2) = wApplID;
  *(WORD FAR *) (pM+4) = _SELECT_B_PROTOCOL_REQ;
  *(WORD FAR *) (pM+6) = wMsgNoAppl;

  return CAPI_PUT_MESSAGE( wApplID, (LPBYTE) pM );
}

