#include "c20type.h"

#ifndef __C20IND_H__
#define __C20IND_H__



#ifndef _BIG_ENDIAN_

/*------------------------------------------------------------/
/ Message Command/Subcommand from CAPI 2.0
/------------------------------------------------------------*/
#define _ALERT_CONF                   0x8101
#define _CONNECT_CONF                 0x8102
#define _CONNECT_IND                  0x8202
#define _CONNECT_ACTIVE_IND           0x8203
#define _CONNECT_B3_ACTIVE_IND        0x8283
#define _CONNECT_B3_CONF              0x8182
#define _CONNECT_B3_IND               0x8282
#define _CONNECT_B3_T90_ACTIVE_IND    0x8288
#define _DATA_B3_CONF                 0x8186
#define _DATA_B3_IND                  0x8286
#define _DISCONNECT_B3_CONF           0x8184
#define _DISCONNECT_B3_IND            0x8284
#define _DISCONNECT_CONF              0x8104
#define _DISCONNECT_IND               0x8204
#define _FACILITY_CONF                0x8180
#define _FACILITY_IND                 0x8280
#define _INFO_CONF                    0x8108
#define _INFO_IND                     0x8208
#define _LISTEN_CONF                  0x8105
#define _MANUFACTURER_CONF            0x81FF
#define _MANUFACTURER_IND             0x82FF
#define _RESET_B3_CONF                0x8187
#define _RESET_B3_IND                 0x8287
#define _SELECT_B_PROTOCOL_CONF       0x8141

#else

/*------------------------------------------------------------/
/ Message Command/Subcommand from CAPI 2.0
/------------------------------------------------------------*/
#define _ALERT_CONF                   0x0181
#define _CONNECT_CONF                 0x0281
#define _CONNECT_IND                  0x0282
#define _CONNECT_ACTIVE_IND           0x0382
#define _CONNECT_B3_ACTIVE_IND        0x8382
#define _CONNECT_B3_CONF              0x8281
#define _CONNECT_B3_IND               0x8282
#define _CONNECT_B3_T90_ACTIVE_IND    0x8882
#define _DATA_B3_CONF                 0x8681
#define _DATA_B3_IND                  0x8682
#define _DISCONNECT_B3_CONF           0x8481
#define _DISCONNECT_B3_IND            0x8482
#define _DISCONNECT_CONF              0x0481
#define _DISCONNECT_IND               0x0482
#define _FACILITY_CONF                0x8081
#define _FACILITY_IND                 0x8082
#define _INFO_CONF                    0x0881
#define _INFO_IND                     0x0882
#define _LISTEN_CONF                  0x0581
#define _MANUFACTURER_CONF            0xFF81
#define _MANUFACTURER_IND             0xFF82
#define _RESET_B3_CONF                0x8781
#define _RESET_B3_IND                 0x8782
#define _SELECT_B_PROTOCOL_CONF       0x4181

#endif



/*------------------------------------------------------------/
/ Zugriff auf die Komponenten des Messageheaders
/------------------------------------------------------------*/
#define CAPI_MESSAGE_LENGTH(Msg)               (*(WORD FAR *)((Msg)+(0)))
#define CAPI_APPL_ID(Msg)                      (*(WORD FAR *)((Msg)+(2)))
#define CAPI_COMMAND(Msg)                      (*(WORD FAR *)((Msg)+(4)))
#define CAPI_MESSAGE_NUMBER(Msg)               (*(WORD FAR *)((Msg)+(6)))


/*------------------------------------------------------------/
/ Zugriff auf die Komponenten der Daten einer Message
/------------------------------------------------------------*/
#define ALERT_CONF_PLCI(Msg)                   (*(DWORD FAR *)(Msg+8+(0)))
#define ALERT_CONF_INFO(Msg)                   (*(WORD FAR *)(Msg+8+(4)))

#define CONNECT_CONF_PLCI(Msg)                 (*(DWORD FAR *)(Msg+8+(0)))
#define CONNECT_CONF_INFO(Msg)                 (*(WORD FAR *)(Msg+8+(4)))

#define CONNECT_IND_PLCI(Msg)                  (*(DWORD FAR *)(Msg+8+(0)))
#define CONNECT_IND_CIP_VALUE(Msg)             (*(WORD FAR *)(Msg+8+(4)))
#define CONNECT_IND_CALLED_PARTY_NUMBER(Msg)   ( (STRUCT)    (Msg+8+(6)))

#if 0
  CONNECT_IND_CALLING_PARTY_NUMBER(Msg)
  CONNECT_IND_CALLED_PARTY_SUBADDRESS(Msg)
  CONNECT_IND_CALLING_PARTY_SUBADDRESS(Msg)
  CONNECT_IND_BC(Msg)
  CONNECT_IND_LLC(Msg)
  CONNECT_IND_HLC(Msg)
  CONNECT_IND_ADDITIONAL_INFO(Msg)
#endif

#define CONNECT_ACTIVE_IND_PLCI(Msg)             (*(DWORD FAR *)(Msg+8+(0)))
#define CONNECT_ACTIVE_IND_CONNECTED_NUMBER(Msg) ( (STRUCT)(Msg+8+(4)))

#if 0
  CONNECT_ACTIVE_IND_CONNECTED_SUBADDRESS(Msg)
  CONNECT_ACTIVE_IND_LLC(Msg)
#endif

#define CONNECT_B3_ACTIVE_IND_NCCI(Msg)        (*(DWORD FAR *)(Msg+8+(0)))
#define CONNECT_B3_ACTIVE_IND_NCPI(Msg)        ( (STRUCT)(Msg+8+(4)))

#define CONNECT_B3_CONF_NCCI(Msg)              (*(DWORD FAR *)(Msg+8+(0)))
#define CONNECT_B3_CONF_INFO(Msg)              (*(WORD FAR *)(Msg+8+(4)))

#define CONNECT_B3_IND_NCCI(Msg)               (*(DWORD FAR *)(Msg+8+(0)))
#define CONNECT_B3_IND_NCPI(Msg)               ( (STRUCT)(Msg+8+(4)))

#define CONNECT_B3_T90_ACTIVE_IND_NCCI(Msg)    (*(DWORD FAR *)(Msg+8+(0)))
#define CONNECT_B3_T90_ACTIVE_IND_NCPI(Msg)    ( (STRUCT)(Msg+8+(4)))

#define DATA_B3_CONF_NCCI(Msg)                 (*(DWORD FAR *)(Msg+8+(0)))
#define DATA_B3_CONF_DATA_HANDLE(Msg)          (*(WORD FAR *)(Msg+8+(4)))
#define DATA_B3_CONF_INFO(Msg)                 (*(WORD FAR *)(Msg+8+(6)))

#define DATA_B3_IND_NCCI(Msg)                  (*(DWORD FAR *)(Msg+8+(0)))
#define DATA_B3_IND_DATA(Msg)                  (*(DWORD FAR *)(Msg+8+(4)))
#define DATA_B3_IND_DATA_LENGTH(Msg)           (*(WORD FAR *)(Msg+8+(8)))
#define DATA_B3_IND_DATA_HANDLE(Msg)           (*(WORD FAR *)(Msg+8+(10)))
#define DATA_B3_IND_FLAGS(Msg)                 (*(WORD FAR *)(Msg+8+(12)))

#define DISCONNECT_B3_CONF_NCCI(Msg)           (*(DWORD FAR *)(Msg+8+(0)))
#define DISCONNECT_B3_CONF_INFO(Msg)           (*(WORD FAR *)(Msg+8+(4)))

#define DISCONNECT_B3_IND_NCCI(Msg)            (*(DWORD FAR *)(Msg+8+(0)))
#define DISCONNECT_B3_IND_REASON_B3(Msg)       (*(WORD FAR *)(Msg+8+(4)))
#define DISCONNECT_B3_IND_NCPI(Msg)            ( (STRUCT)(Msg+8+(6)))

#define DISCONNECT_CONF_PLCI(Msg)              (*(DWORD FAR *)(Msg+8+(0)))
#define DISCONNECT_CONF_INFO(Msg)              (*(WORD FAR *)(Msg+8+(4)))

#define DISCONNECT_IND_PLCI(Msg)               (*(DWORD FAR *)(Msg+8+(0)))
#define DISCONNECT_IND_REASON(Msg)             (*(WORD FAR *)(Msg+8+(4)))

#define FACILITY_CONF_PLCI(Msg)                (*(DWORD FAR *)(Msg+8+(0)))
#define FACILITY_CONF_NCCI(Msg)                (*(DWORD FAR *)(Msg+8+(0)))
#define FACILITY_CONF_CONTROLLER(Msg)          (*(DWORD FAR *)(Msg+8+(0)))
#define FACILITY_CONF_INFO(Msg)                (*(WORD FAR *)(Msg+8+(4)))
#define FACILITY_CONF_FACILITY_SELECTOR(Msg)   (*(WORD FAR *)(Msg+8+(6)))
#define FACILITY_CONF_FACILITY_PARAMETER(Msg)  ( (STRUCT)(Msg+8+(8)))

#define FACILITY_IND_PLCI(Msg)                 (*(DWORD FAR *)(Msg+8+(0)))
#define FACILITY_IND_CONTROLLER(Msg)           (*(DWORD FAR *)(Msg+8+(0)))
#define FACILITY_IND_NCCI(Msg)                 (*(DWORD FAR *)(Msg+8+(0)))
#define FACILITY_IND_FACILITY_SELECTOR(Msg)    (*(WORD FAR *)(Msg+8+(4)))
#define FACILITY_IND_FACILITY_PARAMETER(Msg)   ( (STRUCT)(Msg+8+(6)))

#define INFO_CONF_PLCI(Msg)                    (*(DWORD FAR *)(Msg+8+(0)))
#define INFO_CONF_INFO(Msg)                    (*(WORD FAR *)(Msg+8+(4)))

#define INFO_IND_PLCI(Msg)                     (*(DWORD FAR *)(Msg+8+(0)))
#define INFO_IND_CONTROLLER(Msg)               (*(DWORD FAR *)(Msg+8+(0)))
#define INFO_IND_INFO_NUMBER(Msg)              (*(WORD FAR *)(Msg+8+(4)))
#define INFO_IND_INFO_ELEMENT(Msg)             ( (STRUCT)(Msg+8+(6)))

#define LISTEN_CONF_CONTROLLER(Msg)            (*(DWORD FAR *)(Msg+8+(0)))
#define LISTEN_CONF_INFO(Msg)                  (*(WORD FAR *)(Msg+8+(4)))

#define MANUFACTURER_CONF_CONTROLLER(Msg)      (*(DWORD FAR *)(Msg+8+(0)))
#define MANUFACTURER_CONF_MANU_ID(Msg)         (*(DWORD FAR *)(Msg+8+(4)))
#define MANUFACTURER_CONF_MANU_DATA(Msg)       ( (STRUCT)(Msg+8+(8)))

#define MANUFACTURER_IND_CONTROLLER(Msg)       (*(DWORD FAR *)(Msg+8+(0)))
#define MANUFACTURER_IND_MANU_ID(Msg)          (*(DWORD FAR *)(Msg+8+(4)))
#define MANUFACTURER_IND_MANU_DATA(Msg)        ( (STRUCT)(Msg+8+(8)))

#define RESET_B3_CONF_NCCI(Msg)                (*(DWORD FAR *)(Msg+8+(0)))
#define RESET_B3_CONF_INFO(Msg)                (*(WORD FAR *)(Msg+8+(4)))

#define RESET_B3_IND_NCCI(Msg)                 (*(DWORD FAR *)(Msg+8+(0)))
#define RESET_B3_IND_NCPI(Msg)                 ( (STRUCT)(Msg+8+(4)))

#define SELECT_B_PROTOCOL_CONF_PLCI(Msg)       (*(DWORD FAR *)(Msg+8+(0)))
#define SELECT_B_PROTOCOL_CONF_INFO(Msg)       (*(WORD FAR *)(Msg+8+(4)))


/*------------------------------------------------------------/
/ Prfung, ob ein bestimmtes Datenfeld in einer Message existriert
/------------------------------------------------------------*/
int  EXIST_PLCI (LPBYTE MSG);
int  EXIST_ADDITIONAL_INFO (LPBYTE MSG);
int  EXIST_INFO (LPBYTE MSG);
int  EXIST_CIP_VALUE (LPBYTE MSG);
int  EXIST_CALLED_PARTY_NUMBER (LPBYTE MSG);
int  EXIST_CALLING_PARTY_NUMBER (LPBYTE MSG);
int  EXIST_CALLED_PARTY_SUBADDRESS (LPBYTE MSG);
int  EXIST_CALLING_PARTY_SUBADDRESS (LPBYTE MSG);
int  EXIST_BC (LPBYTE MSG);
int  EXIST_LLC (LPBYTE MSG);
int  EXIST_HLC (LPBYTE MSG);
int  EXIST_CONNECTED_NUMBER (LPBYTE MSG);
int  EXIST_CONNECTED_SUBADDRESS (LPBYTE MSG);
int  EXIST_NCCI (LPBYTE MSG);
int  EXIST_NCPI (LPBYTE MSG);
int  EXIST_DATA_HANDLE (LPBYTE MSG);
int  EXIST_DATA_LENGTH (LPBYTE MSG);
int  EXIST_DATA (LPBYTE MSG);
int  EXIST_FLAGS (LPBYTE MSG);
int  EXIST_REASON_B3 (LPBYTE MSG);
int  EXIST_REASON (LPBYTE MSG);
int  EXIST_FACILITY_SELECTOR (LPBYTE MSG);
int  EXIST_FACILITY_PARAMETER (LPBYTE MSG);
int  EXIST_INFO_NUMBER (LPBYTE MSG);
int  EXIST_INFO_ELEMENT (LPBYTE MSG);
int  EXIST_CONTROLLER (LPBYTE MSG);
int  EXIST_MANU_ID (LPBYTE MSG);
int  EXIST_MANU_DATA (LPBYTE MSG);

/*------------------------------------------------------------/
/ allgemeiner Zugriff auf die Komponenten der Daten einer Message
/------------------------------------------------------------*/
//DWORD   GET_PLCI(LPBYTE MSG);
STRUCT  GET_ADDITIONAL_INFO(LPBYTE MSG);
WORD    GET_INFO (LPBYTE MSG);
WORD    GET_CIP_VALUE (LPBYTE MSG);
STRUCT  GET_CALLED_PARTY_NUMBER (LPBYTE MSG);
STRUCT  GET_CALLING_PARTY_NUMBER (LPBYTE MSG);
STRUCT  GET_CALLED_PARTY_SUBADDRESS (LPBYTE MSG);
STRUCT  GET_CALLING_PARTY_SUBADDRESS (LPBYTE MSG);
STRUCT  GET_BC (LPBYTE MSG);
STRUCT  GET_LLC (LPBYTE MSG);
STRUCT  GET_HLC (LPBYTE MSG);
STRUCT  GET_CONNECTED_NUMBER (LPBYTE MSG);
STRUCT  GET_CONNECTED_SUBADDRESS (LPBYTE MSG);
//DWORD   GET_NCCI (LPBYTE MSG);
STRUCT  GET_NCPI (LPBYTE MSG);
WORD    GET_DATA_HANDLE (LPBYTE MSG);
WORD    GET_DATA_LENGTH (LPBYTE MSG);
DWORD   GET_DATA (LPBYTE MSG);
WORD    GET_FLAGS (LPBYTE MSG);
WORD    GET_REASON_B3 (LPBYTE MSG);
WORD    GET_REASON (LPBYTE MSG);
WORD    GET_FACILITY_SELECTOR (LPBYTE MSG);
STRUCT  GET_FACILITY_PARAMETER (LPBYTE MSG);
WORD    GET_INFO_NUMBER (LPBYTE MSG);
STRUCT  GET_INFO_ELEMENT (LPBYTE MSG);
DWORD   GET_CONTROLLER (LPBYTE MSG);
DWORD   GET_MANU_ID (LPBYTE MSG);
STRUCT  GET_MANU_DATA (LPBYTE MSG);

#endif /* #ifndef __C20IND_H__ */
