package de.bablokb.epm;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor extends ActionBarAdvisor {

    private IWorkbenchAction iExitAction;
	private IWorkbenchAction iAboutAction;
	private IWorkbenchAction iNewWindowAction;
	// private OpenArchiveAction iOpenArchiveAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
      super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
      iExitAction = ActionFactory.QUIT.create(window);
      register(iExitAction);
        
      iAboutAction = ActionFactory.ABOUT.create(window);
      register(iAboutAction);
        
      iNewWindowAction = ActionFactory.OPEN_NEW_WINDOW.create(window);
      register(iNewWindowAction);
        
      // iOpenArchiveAction = new OpenArchiveAction(window, "Open Another Archive View", ArchiveView.ID);
      // register(iOpenArchiveAction);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
      MenuManager archiveMenu = new MenuManager("&Archive", IWorkbenchActionConstants.M_FILE);
      MenuManager helpMenu = new MenuManager("&Help", IWorkbenchActionConstants.M_HELP);
        
      menuBar.add(archiveMenu);
      menuBar.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
      menuBar.add(helpMenu);
        
      // Archive
      archiveMenu.add(iNewWindowAction);
      archiveMenu.add(new Separator());
      // archiveMenu.add(iOpenArchiveAction);
      archiveMenu.add(new Separator());
      archiveMenu.add(iExitAction);
        
      // Help
      helpMenu.add(iAboutAction);
    }
    
    protected void fillCoolBar(ICoolBarManager coolBar) {
      IToolBarManager toolbar = new ToolBarManager(SWT.FLAT | SWT.RIGHT);
      coolBar.add(new ToolBarContributionItem(toolbar, "main"));   
      toolbar.add(iExitAction);
      // toolbar.add(iOpenArchiveAction);
    }    
}
