int fileg_is_absolute_path(const char *path)
{
	if (path == 0 || *path == 0)
	{
		return 0;
	}

	return (*path == '/');
}

int fileg_is_relative_path(const char *path)
{
	const char *s;

	if (path == 0 || *path == 0 || *path == '/')
	{
		return 0;
	}
	if (path[0] == '.' && path[1] == 0)
	{
		return 1;
	}
	if (path[0] == '.' && path[1] == '.' && path[2] == 0)
	{
		return 1;
	}
	for (s = path; *s != 0; s++)
	{
		if (*s == '/')
		{
			return 1;
		}
	}

	return 0;
}

int fileg_is_local_relative_path(const char *path)
{
	const char *s;

	if (path == 0 || *path == 0 || *path == '/')
	{
		return 0;
	}
	if (path[0] == '.' && path[1] == '.')
	{
		if (path[2] == 0 || path[2] == '/')
		{
			return 0;
		}
	}
	for (s = path; *s != 0; s++)
	{
		if (s[0] == '/' && s[1] == '.' && s[2] == '.')
		{
			if (s[3] == 0 || s[3] == '/')
			{
				return 0;
			}
		}
	}

	return 1;
}

int fileg_is_path(const char *path)
{
	int rc;

	if (path == 0 || *path == 0)
	{
		return 0;
	}
	rc = fileg_is_relative_path(path);
	if (rc == 1)
	{
		return 1;
	}
	rc = fileg_is_absolute_path(path);
	if (rc == 1)
	{
		return 1;
	}
	if (path[0] == '.' && path[1] == 0)
	{
		return 1;
	}
	if (path[0] == '.' && path[1] == '.' && path[2] == 0)
	{
		return 1;
	}

	return 0;
}

int fileg_is_filename(const char *path)
{
	int rc;

	if (path == 0 || *path == 0)
	{
		return 0;
	}
	rc = fileg_is_path(path);

	return !rc;
}

int main(void)
{
	return 0;
}
