/* -*-c-*- */
/* gateguardian-0.9.4_devel
 *
 *
 *
 * WARNING: This file was generated from the .in file.
 *          Gate Guardian's ./configure overwrites any changes!
 *
 *
 */
/* Please report bugs and security issues with this file to
 * gateguardian-devel@lists.sourceforge.net */

#ifndef FILEGUARDIAN_C
#define FILEGUARDIAN_C
/* To be implemented (?)
  !!!make tempdir
  !!!check file access
  !!!open()
  !!!fopen()
  !!!path concatenation with size check
*/

/* Functions that are not going to be implemented because it is too difficult
 * to write the code safely:
 *
 * - check whether a given path is safe
 * - safely open a temporary file in a given path
 */

/* ---------------------------- included header files ---------------------- */

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>

/* ---------------------------- interface definitions ---------------------- */

/* ---------------------------- feature tests ------------------------------ */

#undef HAVE_DIRFD
#define HAVE_DIRFD 1
#if HAVE_DIRFD
#	define GATEG_DIRFD(x) dirfd(x)
#else
#	define GATEG_DIRFD(x) 0
#endif
#ifdef _PC_PATH_MAX
#	define GATEG__PC_PATH_MAX _PC_PATH_MAX
#else
#	define GATEG__PC_PATH_MAX 0
#endif
#ifdef _PC_PATH_MAX
#	define GATEG_PATHCONF(x, y) pathconf(".", _PC_PATH_MAX)
#else
#	define GATEG_PATHCONF(x, y) 0
#endif
#define GATEG_PATH_MAX_FALLBACK 4096
#ifdef PATH_MAX
#	define GATEG_PATH_MAX PATH_MAX
#else
#	define GATEG_PATH_MAX 0
#endif
#ifndef S_IRWXO
#	define GATEG_S_IRWXO 0007
#else
#	define GATEG_S_IRWXO S_IRWXO
#endif
#ifndef S_ISUID
#	define GATEG_S_ISUID 0004000
#else
#	define GATEG_S_ISUID S_ISUID
#endif
#ifndef S_ISGID
#	define GATEG_S_ISGID 0002000
#else
#	define GATEG_S_ISGID S_ISGID
#endif
#ifndef S_ISVTX
#	define GATEG_S_ISVTX 0001000
#else
#	define GATEG_S_ISVTX S_ISVTX
#endif
#ifndef S_IRWXU
#	define GATEG_S_IRWXU 00700
#else
#	define GATEG_S_IRWXU S_IRWXU
#endif
#ifndef S_IRUSR
#	define GATEG_S_IRUSR 00400
#else
#	define GATEG_S_IRUSR S_IRUSR
#endif
#ifndef S_IWUSR
#	define GATEG_S_IWUSR 00200
#else
#	define GATEG_S_IWUSR S_IWUSR
#endif
#ifndef S_IXUSR
#	define GATEG_S_IXUSR 00100
#else
#	define GATEG_S_IXUSR S_IXUSR
#endif
#ifndef S_IRWXG
#	define GATEG_S_IRWXG 00070
#else
#	define GATEG_S_IRWXG S_IRWXG
#endif
#ifndef S_IRGRP
#	define GATEG_S_IRGRP 00040
#else
#	define GATEG_S_IRGRP S_IRGRP
#endif
#ifndef S_IWGRP
#	define GATEG_S_IWGRP 00020
#else
#	define GATEG_S_IWGRP S_IWGRP
#endif
#ifndef S_IXGRP
#	define GATEG_S_IXGRP 00010
#else
#	define GATEG_S_IXGRP S_IXGRP
#endif
#ifndef S_IRWXO
#	define GATEG_S_IRWXO 00007
#else
#	define GATEG_S_IRWXO S_IRWXO
#endif
#ifndef S_IROTH
#	define GATEG_S_IROTH 00004
#else
#	define GATEG_S_IROTH S_IROTH
#endif
#ifndef S_IWOTH
#	define GATEG_S_IWOTH 00002
#else
#	define GATEG_S_IWOTH S_IWOTH
#endif
#ifndef S_IXOTH
#	define GATEG_S_IXOTH 00001
#else
#	define GATEG_S_IXOTH S_IXOTH
#endif

#ifdef O_NOFOLLOW
#	define GATEG_O_NOFOLLOW O_NOFOLLOW
#else
#	define GATEG_O_NOFOLLOW 0
#endif

/* ---------------------------- local definitions -------------------------- */

#undef GATEG_ABORT
#undef GATEG_DPRINTF
#ifdef GATEG_DEBUG
#	include <setjmp.h>
jmp_buf __gateg_debug_jmp_buf;
#	undef GATEG_ABORT_RET
#	define GATEG_ABORT_RET 64
#	define GATEG_ABORT() \
	do \
	{ \
		fprintf( \
			stderr, "abort in file %s line %d\n", __FILE__, \
			__LINE__); \
		longjmp(__gateg_debug_jmp_buf, GATEG_ABORT_RET); \
		abort(); \
	} while (0)
#	define GATEG_DPRINTF(X) do { fprintf X; } while (0)
#else
#	define GATEG_ABORT() abort()
#	define GATEG_DPRINTF(X) do { } while (0)
#endif
#define FILEG_DEFAULT_FORBIDDEN_DIR_MODE (GATEG_S_IWOTH | GATEG_S_IWGRP)

/* ---------------------------- local macros ------------------------------- */

/* ---------------------------- imports ------------------------------------ */

/* ---------------------------- included code files ------------------------ */

/* fileguardian_if.h */

/* ---------------------------- forward declarations ----------------------- */

DIR *fileg_safe_opendir_with_mode(const char *name, mode_t mode_forbidden);
DIR *fileg_safe_opendir(const char *name);
int fileg_check_dir_safety_with_mode(const char *name, mode_t mode_forbidden);
int fileg_check_cwd_safety(void);
FILE *fileg_safe_tmpfile_with_name(char *ret_filename, char *dest_path);
FILE *fileg_safe_tmpfile(void);
int fileg_remove_fuzz_from_path(char *path);
int fileg_is_absolute_path(const char *path);
int fileg_is_relative_path(const char *path);
int fileg_is_local_relative_path(const char *path);
int fileg_is_path(const char *path);
int fileg_is_filename(const char *path);

/* ---------------------------- local variables ---------------------------- */

/* ---------------------------- exported variables (globals) --------------- */

/* ---------------------------- local functions ---------------------------- */

static char *__fileg_strncpy(char *dest, const char *src, long maxlen)
{
	long i;
	char *s;

	s = dest;
	for (i = 0; *src != 0 && i < maxlen; i++)
	{
		*dest++ = *src++;
	}
	if (i >= maxlen)
	{
		return 0;
	}
	*dest = 0;

	return s;
}

static size_t __fileg_strlen(const char *s)
{
	size_t i;

	for (i = 0; s[i] != 0; i++)
	{
		/* nothing */
	}

	return i;
}

/*
 * directory handling
 */

static long __fileg_path_max(void)
{
	long path_max;

	path_max = 0;
	if (path_max <= 0)
	{
		path_max = GATEG_PATH_MAX;
	}
	if (path_max <= 0)
	{
		path_max = GATEG_PATHCONF(".", GATEG__PC_PATH_MAX);
	}
	if (path_max <= 0)
	{
		path_max = GATEG_PATH_MAX_FALLBACK;
	}

	return path_max;
}

static mode_t __fileg_get_umask(void)
{
	mode_t mode;

	mode = umask(0000);
	umask(mode);

	return mode;
}

static int __fileg_check_forbidden_mode(
	mode_t mode, mode_t mode_forbidden, int do_ignore_sticky_bit)
{
	if (do_ignore_sticky_bit != 0 && (mode & GATEG_S_ISVTX) != 0)
	{
		return 0;
	}
	if ((mode & mode_forbidden) != 0)
	{
		return 1;
	}
	if ((mode & FILEG_DEFAULT_FORBIDDEN_DIR_MODE) != 0)
	{
		return 1;
	}

	return 0;
}

static int __fileg_check_path_safety(
	const char *name, mode_t mode_forbidden, int do_ignore_sticky_bit)
{
	uid_t euid;
	long plen;
	long len;
	char *pname;
	char *s;
	int is_safe;
	int rc;
	struct stat ubuf;
	struct stat cbuf;

	plen = __fileg_path_max();
	if (plen <= 1)
	{
		GATEG_ABORT();
	}
	pname = (char *)malloc(plen + 1);
	if (pname == 0)
	{
		return -1;
	}
	s = __fileg_strncpy(pname, name, plen + 1);
	if (s == 0)
	{
		free(pname);

		return -1;
	}
	rc = stat(pname, &cbuf);
	if (rc != 0)
	{
		free(pname);

		return -1;
	}
	euid = geteuid();
	/* check safety */
	if (cbuf.st_uid != euid && cbuf.st_uid != 0)
	{
		free(pname);

		return -1;
	}
	rc = __fileg_check_forbidden_mode(
		cbuf.st_mode, mode_forbidden, do_ignore_sticky_bit);
	if (rc != 0)
	{
		free(pname);

		return -1;
	}
	for (len = 0, s = pname; *s != 0; len++, s++)
	{
		/* nothing */
	}
	for (is_safe = 0, s = pname + len; len < plen - 3; )
	{
		pname[len++] = '/';
		pname[len++] = '.';
		pname[len++] = '.';
		pname[len] = 0;
		/* open next upper directory */
		rc = stat(pname, &ubuf);
		if (rc != 0)
		{
			break;
		}
		if (
			cbuf.st_dev == ubuf.st_dev &&
			cbuf.st_ino == ubuf.st_ino &&
			cbuf.st_mode == ubuf.st_mode)
		{
			/* found the root directory */
			is_safe = 1;
			break;
		}
		cbuf = ubuf;
		/* check safety */
		if (ubuf.st_uid != euid && ubuf.st_uid != 0)
		{
			/* unsafe */
			break;
		}
		rc = __fileg_check_forbidden_mode(
			ubuf.st_mode, mode_forbidden, do_ignore_sticky_bit);
		if (rc != 0)
		{
			/* unsafe */
			break;
		}
	}
	free(pname);

	return (is_safe == 1) ? 0 : -1;
}

static DIR *__fileg_safe_opendir_with_mode(
	const char *name, mode_t mode_forbidden, int do_ignore_sticky_bit)
{
	DIR *sd;
	int rc;
	int is_safe;
	struct stat buf;
	struct stat buf2;

	is_safe = 0;
	sd = 0;
	rc = stat(name, &buf);
	if (rc != 0)
	{
		return 0;
	}
	if (name == 0 || *name == 0)
	{
		return 0;
	}
	do
	{
		/* check whether cwd is safe */
		rc = __fileg_check_path_safety(
			name, mode_forbidden, do_ignore_sticky_bit);
		if (rc != 0)
		{
			break;
		}
		sd = opendir(name);
		if (sd == 0)
		{
			break;
		}
		if (HAVE_DIRFD)
		{
			int dfd;

			dfd = GATEG_DIRFD(sd);
			if (dfd < 0)
			{
				break;
			}
			rc = fstat(dfd, &buf2);
		}
		else
		{
			rc = stat(name, &buf2);
		}
		/* compare with current stats */
		if (
			buf.st_dev != buf2.st_dev ||
			buf.st_ino != buf2.st_ino ||
			buf.st_mode != buf2.st_mode)
		{
			break;
		}
		is_safe = 1;
	} while (0);
	if (is_safe == 0 && sd != 0)
	{
		closedir(sd);
		sd = 0;
	}

	return sd;
}

static int __fileg_check_dir_safety_with_mode(
	const char *name, mode_t mode_forbidden, int do_ignore_sticky_bit)
{
	DIR *d;
	int rc;

	d = __fileg_safe_opendir_with_mode(
		name, FILEG_DEFAULT_FORBIDDEN_DIR_MODE, do_ignore_sticky_bit);
	if (d == 0)
	{
		return -1;
	}
	rc = closedir(d);
	d = 0;

	return rc;
}

static char *__fileg_tmpnam(char *s, char **fn, int *is_modified)
{
	char *dn;
	char *r;
	char *t;
	char *u;

	*is_modified = 0;
	r = tmpnam(s);
	/* get directory name */
	for (t = r, u = 0; *t != 0; t++)
	{
		if (*t == '/')
		{
			u = t;
		}
	}
	if (u == 0)
	{
		dn = ".";
		*fn = r;
	}
	else if (u == r)
	{
		dn = "/";
		*fn = u + 1;
	}
	else
	{
		dn = r;
		*fn = u + 1;
		*is_modified = 1;
		*u = 0;
	}

	return r;
}

static char *__fileg_tmpnam_with_path(
	char *path, char *s, char **fn, int *is_modified)
{
	char name[L_tmpnam];
	char *t;
	size_t lp;
	size_t ln;


	*fn = 0;
	__fileg_tmpnam(name, fn, is_modified);
	*is_modified = 1;
	__fileg_strncpy(s, path, L_tmpnam);
	s[L_tmpnam - 1] = 0;
	lp = __fileg_strlen(s);
	ln = __fileg_strlen(*fn);
	if (lp + ln < lp)
	{
		*s = 0;

		return 0;
	}
	if (lp + ln + 2 > L_tmpnam)
	{
		*s = 0;

		return 0;
	}
	t = s + lp;
	*t = 0;
	t++;
	__fileg_strncpy(t, *fn, L_tmpnam - lp - 1);
	*fn = t;

	return s;
}

static FILE *__fileg_safe_tmpfile_with_name(char *ret_filename, char *path)
{
	char *dn;
	char *fn;
	int is_modified;
	int fd;
	int rc;
	FILE *f;
	mode_t mode;

	if (path == 0)
	{
		dn = __fileg_tmpnam(ret_filename, &fn, &is_modified);
	}
	else
	{
		dn = __fileg_tmpnam_with_path(
			path, ret_filename, &fn, &is_modified);
	}
	if (*ret_filename == 0)
	{
		return 0;
	}
	rc = __fileg_check_dir_safety_with_mode(
		dn, FILEG_DEFAULT_FORBIDDEN_DIR_MODE, 1);
	if (rc != 0)
	{
		/* directory is unsafe */
		*ret_filename = 0;

		return 0;
	}
	if (is_modified)
	{
		*(fn - 1) = '/';
		fn = dn;
	}
	mode = (__fileg_get_umask() & ~(FILEG_DEFAULT_FORBIDDEN_DIR_MODE));
	fd = open(dn, O_RDWR | O_CREAT | O_EXCL | GATEG_O_NOFOLLOW, mode);
	if (fd < 0)
	{
		*ret_filename = 0;

		return 0;
	}
	f = fdopen(fd, "r+");
	if (f == 0)
	{
		close(fd);
		*ret_filename = 0;

		return 0;
	}

	return f;
}

/* ---------------------------- interface functions ------------------------ */

/* Note 1: This function has a possible race condition on platforms that do not
 * support the dirfd() function.  It may be possible to redirect the directory
 * path to a different location (for example by mounting or unmounting a file
 * system) after the safety of the path has been checked but before the
 * directory is opened.
 *
 * Note 2: Testing the safety of the path works internally by appending "/.."
 * to the name for each directory in the path.  Thus, it is impossible to
 * test a path if the resulting path is longer than the maximim allowed path
 * length (system dependent).
 */
DIR *fileg_safe_opendir_with_mode(const char *name, mode_t mode_forbidden)
{
	DIR *d;

	d = __fileg_safe_opendir_with_mode(name, mode_forbidden, 0);

	return d;
}

/* Note 1: This function has a possible race condition on platforms that do not
 * support the dirfd() function.  It may be possible to redirect the directory
 * path to a different location (for example by mounting or unmounting a file
 * system) after the safety of the path has been checked but before the
 * directory is opened.
 *
 * Note 2: Testing the safety of the path works internally by appending "/.."
 * to the name for each directory in the path.  Thus, it is impossible to
 * test a path if the resulting path is longer than the maximim allowed path
 * length (system dependent).
 */
DIR *fileg_safe_opendir(const char *name)
{
	DIR *d;
	mode_t mode;

	mode = (__fileg_get_umask() & ~(FILEG_DEFAULT_FORBIDDEN_DIR_MODE));
	d = __fileg_safe_opendir_with_mode(name, mode, 0);

	return d;
}

/* Note: The directory may no longer be safe once the function returns if an
 * attacker is able to mount or remount a file system in the path. */
int fileg_check_dir_safety_with_mode(const char *name, mode_t mode_forbidden)
{
	int rc;

	rc = __fileg_check_dir_safety_with_mode(name, mode_forbidden, 0);

	return rc;
}

/* Note: The directory may no longer be safe once the function returns if an
 * attacker is able to mount or remount a file system in the path. */
int fileg_check_cwd_safety(void)
{
	int rc;
	mode_t mode;

	mode = (__fileg_get_umask() & ~(FILEG_DEFAULT_FORBIDDEN_DIR_MODE));
	rc = fileg_check_dir_safety_with_mode(".", mode);

	return rc;
}

/** Tries to create a temporary file in the directory dest_path or P_tmpdir,
 * if dest_path is 0, opens it read/write and returns the corresponding FILE
 * pointer.  The name is copied to the character array (of length at least
 * L_tmpnam) pointed at by ret_filename (which must not be a 0 pointer).  If
 * the directory is unsafe, an error is returned.
 *
 * Internally, it relies on the tmpnam() POSIX function to generate the
 * filename and uses it in a safe fashion.  Please refer to "man tmpnam" for
 * details about the tmpnam() function on your system.
 *
 * The function return a FILE pointer or 0 if no safe filename could be
 * generated for whatever reason.  The name and path to the file is stored
 * in the memory pointed to by ret_filename.
 */
FILE *fileg_safe_tmpfile_with_name(char *ret_filename, char *dest_path)
{
	FILE *f;

	f = __fileg_safe_tmpfile_with_name(ret_filename, dest_path);

	return f;
}

/** Tries to create an anonymous temporary file in a safe directory, opens
 * it read/write and returns the corresponding FILE pointer.  The file is
 * removed at the moment it is closed.
 *
 * Internally, it relies on the tmpnam() POSIX function to generate the
 * filename and uses it in a safe fashion.  Please refer to "man tmpnam" for
 * details about the tmpnam() function on your system.
 *
 * The function return a FILE pointer or 0 if no safe filename could be
 * generated for whatever reason.
 */
FILE *fileg_safe_tmpfile(void)
{
	char name[L_tmpnam];
	FILE *f;
	int rc;

	f = fileg_safe_tmpfile_with_name(name, 0);
	rc = unlink(name);
	if (rc != 0)
	{
		GATEG_ABORT();
	}

	return f;
}

/** This function removes unnecessary parts of a given path:
 *
 * - Multiple slashes are reduced to a single slash.
 * - Occurences of "/./" are replaced with "/".
 * - The paths "/.." and /. are reduced to just "/".
 * - If the path begins with "/../" it is reduced to "/".
 * - If the path begins with "./" it is removed.
 * - Trailing slashes (/) are removed except if the path is just "/".
 * - Trailing "/." are removed.
 *
 * If the path has been modified, 1 is returned, otherwise 0 is returned.
 */
int fileg_remove_fuzz_from_path(char *path)
{
	int is_modified;
	char *s;
	char *src;
	char *dest;

	if (path == 0 || path[0] == 0 || path[1] == 0)
	{
		return 0;
	}
	/* handle /. */
	if (path[0] == '/' && path[1] == '.' && path[2] == 0)
	{
		path[1] = 0;
		return 1;
	}
	is_modified = 0;
	/* Strip /../ from beginning */
	for (
		s = path;
		s[0] == '/' && s[1] == '.' && s[2] == '.' && s[3] == '/';
		s += 3)
	{
		is_modified = 1;
	}
	for (s = path; *s != 0; )
	{
		if (s[0] == '/' && s[1] == '.' && s[2] == '.' && s[3] == '/')
		{
			is_modified = 1;
			s += 3;
		}
		else if (s[0] == '.' && s[1] == '/' && s[2] != 0)
		{
			is_modified = 1;
			s += 2;
		}
		else
		{
			break;
		}
	}
	/* handle /.. */
	if (s[0] == '/' && s[1] == '.' && s[2] == '.' && s[3] == 0)
	{
		path[0] = '/';
		path[1] = 0;

		return 1;
	}
	/* remove multiple slashes */
	for (src = s, dest = path; *src != 0; src++)
	{
		if (src[0] == '/')
		{
			if (src[1] == '/')
			{
				is_modified = 1;
				continue;
			}
			else if (src[1] == '.' && src[2] == '/')
			{
				src++;
				is_modified = 1;
				continue;
			}
		}
		*(dest++) = *src;
	}
	*dest = 0;
	/* remove trailing slashes and "/." */
	for (s = dest - 1; s > path; s--)
	{
		if (*s == '/')
		{
			*s = 0;
			is_modified = 1;
			continue;
		}
		if (*s == '.')
		{
			char *t;

			t = s - 1;
			if (*t == '/')
			{
				*s = 0;
				is_modified = 1;
				continue;
			}
		}
		break;
	}

	return is_modified;
}

/** Functions that detect whether a given path is an absolute path, a relative
 * path, a relative path below the current directory, any path or a filename.
 *
 * fileg_is_absolute_path
 *   Returns 1 if path is an absolute path (begins with a slash '/').
 *   Otherwise 0 is returned.
 *
 * fileg_is_relative_path
 *   Returns 1 if path is a relative path (contains a slash but does not begin
 *   with a slash, or is just "." or "..").  Otherwise 0 is returned.
 *
 * fileg_is_local_relative_path
 *   Returns 1 if path is a relative path below the current directory (does
 *   not contain a ".." component) or just a filename.  Otherwise 0 is
 *   returned.
 *
 * fileg_is_path
 *   Returns 1 if path is any path (contains a slash '/' or is just "." or
 *   ".."). Otherwise 0 is returned.
 *
 * fileg_is_filename
 *   Returns 1 if path is a filename (does not contain a slash and is neither
 *   "." nor "..").  Otherwise 0 is returned.
 */
int fileg_is_absolute_path(const char *path)
{
	if (path == 0 || *path == 0)
	{
		return 0;
	}

	return (*path == '/');
}

int fileg_is_relative_path(const char *path)
{
	const char *s;

	if (path == 0 || *path == 0 || *path == '/')
	{
		return 0;
	}
	if (path[0] == '.' && path[1] == 0)
	{
		return 1;
	}
	if (path[0] == '.' && path[1] == '.' && path[2] == 0)
	{
		return 1;
	}
	for (s = path; *s != 0; s++)
	{
		if (*s == '/')
		{
			return 1;
		}
	}

	return 0;
}

int fileg_is_local_relative_path(const char *path)
{
	const char *s;

	if (path == 0 || *path == 0 || *path == '/')
	{
		return 0;
	}
	if (path[0] == '.' && path[1] == '.')
	{
		if (path[2] == 0 || path[2] == '/')
		{
			return 0;
		}
	}
	for (s = path; *s != 0; s++)
	{
		if (s[0] == '/' && s[1] == '.' && s[2] == '.')
		{
			if (s[3] == 0 || s[3] == '/')
			{
				return 0;
			}
		}
	}

	return 1;
}

int fileg_is_path(const char *path)
{
	int rc;

	if (path == 0 || *path == 0)
	{
		return 0;
	}
	rc = fileg_is_relative_path(path);
	if (rc == 1)
	{
		return 1;
	}
	rc = fileg_is_absolute_path(path);
	if (rc == 1)
	{
		return 1;
	}
	if (path[0] == '.' && path[1] == 0)
	{
		return 1;
	}
	if (path[0] == '.' && path[1] == '.' && path[2] == 0)
	{
		return 1;
	}

	return 0;
}

int fileg_is_filename(const char *path)
{
	int rc;

	if (path == 0 || *path == 0)
	{
		return 0;
	}
	rc = fileg_is_path(path);

	return !rc;
}
#endif
