#include <stdlib.h>
#include <string.h>

int safe_putenv(char *string) {
  int rc;
  int offset;
  char *name;
  char *pos;
  char *var;

  name = strdup(string);
  if (name == 0)
    return -1;
  rc = putenv(string);
  if (rc != 0)
    return rc;
  pos = strchr(name, '=');
  if (pos == 0) {
    free(name);
    return -1;
  }
  offset = pos - name + 1;
  *pos = 0;
  var = getenv(name) - offset;
  rc = (var == string) ? 0 : -1;
  free(name);

  return rc;
}

void safe_unsetenv(const char *name) {
  unsetenv(name);
  if (getenv(name) != 0)
    abort();

  return;
}

int main(void) {
  int rc;

  rc = safe_putenv("BLA=blub");
  if (rc != 0)
    abort();
  safe_unsetenv("BLA");

  return 0;
}
