#!/bin/sh
# 
# Listing 4, Fenster in Uhrenform
# \
exec tclsh $0 $@

lappend auto_path wmx

package require Tk
package require wmx
package require Img


# Fenster mit einem Canvas
wm iconify .
canvas .c 
pack .c -fill both -expand true

set uhr [image create photo \
	     -file [file join icons uhr.png]]	     
.c create image 0 0 -image $uhr -anchor nw

# 
wm deiconify .
wm geometry . 273x250
update idletask
setXwinshape . $uhr

# Fenster mit der Maus verschiebenb
bind . <1> {
    set x [expr [winfo rootx .]-%X]
    set y [expr [winfo rooty .]-%Y]
}
bind . <B1-Motion> {
    wm geometry . +[expr %X+$x]+[expr %Y+$y]
}

# Anwendung mit ^q beenden
bind . <Control-q> {
    exit 0
}


# Prozedur um einen Zeiger zu zeichnen
proc malZeiger { winkel radius dicke xoff yoff } {

    set id [ .c create line 0 0  \
		 [expr cos($winkel) *   $radius   ] [expr sin($winkel) * $radius ] \
		 -fill black -width $dicke -tag zeiger]
    .c move $id $xoff $yoff

}

# Prozedur um drei Zeiger zu zeichnen,
# ruft sich selber immer wieder auf
proc malZeit { } {
    set t [ clock seconds]
    scan [clock format $t -format %I] %d stunden
    scan [clock format $t -format %M] %d minuten
    scan [clock format $t -format %s] %d sekunden
    set PI [expr 2*acos(0)]

    .c delete zeiger
    
    set winkel [ expr ( $sekunden -15 ) / 30.0 * $PI]
    malZeiger $winkel 27 2 127 171

    set winkel [ expr ( $minuten -15 ) / 30.0 * $PI]
    malZeiger $winkel 100 2 127 125

    set winkel [expr ( $stunden -2  )/6.0 * $PI  ]
    malZeiger $winkel 80 3 127 125

    after 100 malZeit
}

# starten der Uhr
malZeit