#!/bin/sh
#
# 3. Beispiele fr Icons mit Tk
# \
exec tclsh $0 $@

package require Tk
package require Img

# Icons laden
set basis [ image create photo \
		   -file [file join icons emblem-people.png]]

set dreieck [ image create photo \
		  -file [file join icons dreieck.png ]]

# Rotes Icon 15x15 erzeugen
set alarm [ image create photo ]
$alarm put red -to 0 0 15 15 

# Zusammenfgen durch Addieren
set zusammen [ image create photo ]
$zusammen copy $basis -to 0 0
$zusammen copy $dreieck -to 15 15

# Zusammenfgen durch berschreiben
set zusammen2 [ image create photo ]
$zusammen2 copy $basis -to 0 0
$zusammen2 copy $dreieck -to 15 15 \
    -compositingrule set

# Statusanzeige 
set status [ image create photo ]
$status copy $alarm -to 0 0
$status copy $basis -to 4 4


# Darstellung 
label .dreieck -image $dreieck \
    -text Dreieck -compound top
label .basis -image $basis \
    -text Basis -compound top
label .zusammen -image $zusammen \
    -text Zusammen -compound top
label .zusammen2 -image $zusammen2 \
    -text "Zusammen mit set" -compound top
label .status -image $status \
    -text "Statusanzeige" -compound top

grid .dreieck .basis \
    .zusammen .zusammen2 .status \
    -padx 10 -sticky s



