package require msgcat 
#foreach {cloud_code cloud_desc cloud_amt} { \
#    "SKC" "Clear Skies" 0 "CLR" "Clear Skies" 0 "FEW" "Few Clouds" 20 \
#    "SCT" "Scattered Clouds" 40 "BKN" "Broken Clouds" 75 \
#    "OVC" "Overcast" 100} {
#    set cloud_table($cloud_code) [list $cloud_desc $cloud_amt]
#}



;# use this more human-readable format
foreach {cloud_code cloud_desc cloud_amt} { \
    "SKC" "Clear skies" 0 "CLR" "Clear skies" 0 "FEW" "Mostly clear skies" 20 \
    "SCT" "Partly cloudy" 40 "BKN" "Mostly cloudy" 75 \
    "OVC" "Overcast" 100} {
    set cloud_table($cloud_code) [list $cloud_desc $cloud_amt]
}
        
foreach {condition_code condition_desc} { \
    "-" "Light" "+" "Heavy" "VC" "Nearby" \
    "MI" "Shallow" "BC" "Patches" "BL" "Blowing" "TS" "Thunderstorms" \
    "PR" "Partial" "DR" "Low Drifting" "SH" "Showers" "FZ" "Freezing" \
    "RA" "Rain" "SN" "Snow" "IC" "Ice Crystals" "GR" "Hail" \
    "DZ" "Drizzle" "SG" "Snow Grains" "PE" "Ice Pellets" "GS" "Small Hail" \
    "UP" "Unknown Precipitation" \
    "FG" "Fog" "BR" "Mist" "DU" "Widespread Dust" "SA" "Sand" \
    "VA" "Volcanic Ash" "HZ" "Haze" "FU" "Smoke" "PY" "Spray" \
    "SQ" "Squall" "DS" "Duststorm" "FC" "Funnel Cloud" \
    "PO" "Dust/Sand Whirls" "SS" "Sandstorm"} {
        set condition_table($condition_code) $condition_desc
}

      

;######
;# autogenerated utility functions used by fickle; override as needed
;######

proc yywrap {} {
    return 1
}

proc ECHO {{s ""}} {
    if {[string equal $s ""]} {
        upvar yytext local_yytext
        set s $local_yytext
    }
    global yyout
    puts -nonewline $yyout $s
}

proc YY_FLUSH_BUFFER {} {
    global yy_buffer yy_index yy_done
    set yy_buffer ""
    set yy_index 0
    set yy_done 0
}

set YY_NULL 0
proc YY_INPUT {buf result max_size} {
    global yyin
    upvar $result ret_val
    upvar $buf new_data
    set new_data [read $yyin $max_size]
    set ret_val [string length $new_data]
}

proc unput {c} {
    global yy_buffer yy_index
    set yy_buffer [string replace $yy_buffer $yy_index $yy_index \
                                  "$c[string index $yy_buffer $yy_index]"]
}

proc input {} {
    global yy_buffer yy_index YY_NULL yy_done
    if {[expr [string length $yy_buffer] - $yy_index] < 1024} {
       set yy_buffer_size $YY_NULL
       if {$yy_done == 0} {
           YY_INPUT new_buffer yy_buffer_size 1024
           append yy_buffer $new_buffer
           if {$yy_buffer_size == $YY_NULL} {
               set yy_done 1
           }
       }
       if {$yy_done == 1} {
           if {[yywrap] == 0} {
               return [input]
           } elseif {[expr [string length $yy_buffer] - $yy_index] == 0} {
               return ""
           }
        }
    }
    set c [string index $yy_buffer $yy_index]
    incr yy_index
    return $c
}

proc yy_push_state {new_state} {
    global yy_state_stack
    lappend yy_state_stack $new_state
}

proc yy_pop_state {} {
    global yy_state_stack
    set yy_state_stack [lrange $yy_state_stack 0 end-1]
    if {[string equal $yy_state_stack ""]} {
        yy_push_state INITIAL
    }
}

proc yy_top_state {} {
    global yy_state_stack
    return [lindex $yy_state_stack end]
}

proc BEGIN {new_state {prefix "yy"}} {
    eval global ${prefix}_state_stack
    eval set ${prefix}_state_stack [lrange $${prefix}_state_stack 0 end-1]
    eval lappend ${prefix}_state_stack $new_state
}

;######
;# end autogenerated utility functions
;######


;######
;# autogenerated yylex function by fickle -- modify at your own peril
;######
proc yylex {} {
    global yy_first_time yy_buffer yy_index yy_state_stack
    global yy_state_table yyin yyout YY_NULL yy_done
    global  yylval
    if {[info exists yy_first_time] == 0} {
        set yy_first_time ""
        set yy_buffer ""
        set yy_buffer_size $YY_NULL
        set yy_index 0
        set yy_state_stack ""
        set yy_done 0
        BEGIN INITIAL yy
        array set yy_state_table [list PRES 1 VIS 1 WIND 1 INITIAL 0 CONDS 1 TIME 1]
        if {[info exists yyin] == 0} {
            set yyin "stdin"
        }
        if {[info exists yyout] == 0} {
            set yyout "stdout"
        }
    }
    while {1} {
        set yy_current_state [yy_top_state]
        if {[expr [string length $yy_buffer] - $yy_index] < 1024} {
            if {$yy_done == 0} {
                set new_buffer ""
                YY_INPUT new_buffer yy_buffer_size 1024
                append yy_buffer $new_buffer
                if {$yy_buffer_size == $YY_NULL && \
                        [expr [string length $yy_buffer] - $yy_index] == 0} {
                    set yy_done 1
                }
            }
            if {$yy_done == 1} {
                if {[yywrap] == 0} {
                    set yy_done 0
                    continue
                } elseif {[expr [string length $yy_buffer] - $yy_index] == 0} {
                    break
                }
            }
            
        }
        set yytext ""
        set yy_matched_rule -1
        ;# rule 0: <INITIAL>\S+ 
        if {[expr \
                {[string equal $yy_current_state INITIAL]} && \
                {[regexp -start $yy_index -indices -line  -- {\S+} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 0
            }
        }
        ;# rule 1: <TIME>\S+Z 
        if {[expr \
                {[string equal $yy_current_state TIME]} && \
                {[regexp -start $yy_index -indices -line  -- {\S+Z} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 1
            }
        }
        ;# rule 2: <TIME>\S 
        if {[expr \
                {[string equal $yy_current_state TIME]} && \
                {[regexp -start $yy_index -indices -line  -- {\S} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 2
            }
        }
        ;# rule 3: <WIND>AUTO 
        if {[expr \
                {[string equal $yy_current_state WIND]} && \
                {[regexp -start $yy_index -indices -line  -- {AUTO} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 3
            }
        }
        ;# rule 4: <WIND>COR 
        if {[expr \
                {[string equal $yy_current_state WIND]} && \
                {[regexp -start $yy_index -indices -line  -- {COR} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 4
            }
        }
        ;# rule 5: <WIND>\S+ 
        if {[expr \
                {[string equal $yy_current_state WIND]} && \
                {[regexp -start $yy_index -indices -line  -- {\S+} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 5
            }
        }
        ;# rule 6: <VIS>\S+V\S+ 
        if {[expr \
                {[string equal $yy_current_state VIS]} && \
                {[regexp -start $yy_index -indices -line  -- {\S+V\S+} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 6
            }
        }
        ;# rule 7: <VIS>(\d+( [MP]?\d+\/\S+)?)|(\S+) 
        if {[expr \
                {[string equal $yy_current_state VIS]} && \
                {[regexp -start $yy_index -indices -line  -- {(\d+( [MP]?\d+\/\S+)?)|(\S+)} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 7
            }
        }
        ;# rule 8: <CONDS>R\S+ 
        if {[expr \
                {[string equal $yy_current_state CONDS]} && \
                {[regexp -start $yy_index -indices -line  -- {R\S+} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 8
            }
        }
        ;# rule 9: <CONDS>{clouds}(\d{3}(\S+)?)? 
        if {[expr \
                {[string equal $yy_current_state CONDS]} && \
                {[regexp -start $yy_index -indices -line  -- {(SKC|CLR|BKN|SCT|FEW|OVC)(\d{3}(\S+)?)?} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 9
            }
        }
        ;# rule 10: <CONDS>\S+\/\S+ 
        if {[expr \
                {[string equal $yy_current_state CONDS]} && \
                {[regexp -start $yy_index -indices -line  -- {\S+\/\S+} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 10
            }
        }
        ;# rule 11: <CONDS>\S+ 
        if {[expr \
                {[string equal $yy_current_state CONDS]} && \
                {[regexp -start $yy_index -indices -line  -- {\S+} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 11
            }
        }
        ;# rule 12: <PRES>\S+ 
        if {[expr \
                {[string equal $yy_current_state PRES]} && \
                {[regexp -start $yy_index -indices -line  -- {\S+} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 12
            }
        }
        ;# rule 13: <*>\s+ 
        if {[expr \
                {[regexp -start $yy_index -indices -line  -- {\s+} $yy_buffer yy_match] > 0} && \
                {[lindex $yy_match 0] == $yy_index}]} {
            if {[expr [lindex $yy_match 1] - $yy_index + 1] > [string length $yytext]} {
                set yytext [string range $yy_buffer $yy_index [lindex $yy_match 1]]
                set yy_matched_rule 13
            }
        }
        if {$yy_matched_rule == -1} {
            set yytext [string index $yy_buffer $yy_index]
        }
        set yyleng [string length $yytext]
        incr yy_index $yyleng
        ;# workaround for stupid circumflex behavior
        if {[string equal [string index $yytext end] "\n"]} {
            set yy_buffer [string range $yy_buffer $yy_index end]
            set yy_index 0
        }
        switch -- $yy_matched_rule {
            0
                {
                BEGIN TIME;   ;# ignore the location
            }
            1
                {
                decode_time $yytext; BEGIN WIND
            }
            2
                {
                unput $yytext; BEGIN WIND
            }
            3
                {
                ;# ignore AUTO readings
            }
            4
                {
                ;# also ignore
            }
            5
                {
                decode_wind $yytext; BEGIN VIS
            }
            6
                {
                ;# ignore the extra wind information
            }
            7
                {
                decode_visibility $yytext; BEGIN CONDS
            }
            8
                {
                ;# ignore runway visibility
            }
            9
                {
                decode_cloud $yytext
            }
            10
                {
                decode_temperature $yytext; BEGIN PRES
            }
            11
                {
                decode_conditions $yytext
            }
            12
                {
                decode_pressure $yytext; BEGIN INITIAL; return 0
            }
            13
                {
                ;# ignore
            }
            default
                { ECHO }
        }
    }
    return 0
}
;######
;# end autogenerated data
;######


proc YY_INPUT {buf result max_size} {
    global yyin
    upvar $result ret_val
    upvar $buf new_data
    set ret_val $max_size
    if {$ret_val > [string length $yyin]} {
        set ret_val [string length $yyin]
    }
    set new_data [string range $yyin 0 [expr $ret_val - 1]]
    set yyin [string range $yyin $ret_val end]
}

proc parse_weather {observation_string target_loc} {
    global yyin yylval tw

    YY_FLUSH_BUFFER
    set yyin $observation_string
    upvar $target_loc target_varname
    if {$tw(print_obsdata)} {
        puts $observation_string
    }
    while {[set token [yylex]] != 0} {}
}

proc decode_time {time_string} {
    upvar 2 target_varname target
    regexp {^(\d{2})(\d{2})(\d{2})} $time_string foo \
            month_day hour min
    if {[info exists hour] && [info exists min]} {
        set target(time,hour) $hour
        set target(time,min) $min
    }
}


proc decode_wind {wind_string} {
    upvar 2 target_varname target
    if {[regexp {^(\d{3}|VRB)(\d{2,3})(G\d+)?} $wind_string foo \
            direction speed gust] == 0}  {
        set target(wind,dir) ""
    }
    if {[string equal $direction "VRB"]} {
        set target(wind,dir) -1
    } else {
        set target(wind,dir) [strip_zeros $direction]
    }
    set target(wind,speed) [knots_to_kph [strip_zeros $speed]]
    if {[string equal $gust ""]} {
        set target(wind,gust) "0"
    } else {
        set target(wind,gust) \
                [knots_to_kph [strip_zeros [string range $gust 1 end]]]
    }
}


proc decode_visibility {visibility_string} {
    upvar 2 target_varname target
    ;# special case of a mixed fraction
    if {[regexp {(\d)+ (M?)(\d)+\/(\d+)} $visibility_string foo \
            int_vis minus_vis divisor_vis dividend_vis] == 0} {
        regexp {(\d+)|(M?)(\d)+\/(\d+)} $visibility_string foo \
                int_vis minus_vis divisor_vis dividend_vis
    }
    if {![info exists int_vis]} {
        set visibility 9999
    } elseif {[string equal $int_vis ""]} {
        set visibility 0
    } else {
        set visibility [strip_zeros $int_vis]
    }
    if {[info exists minus_vis] && [string equal $minus_vis "M"]} {
        set visibility 0.001
    } elseif {[info exists divisor_vis] && ![string equal $divisor_vis ""]} {
        set visibility [expr $visibility + \
            [strip_zeros $divisor_vis] / [strip_zeros $dividend_vis]]
    }
    if {[string equal [string range $visibility_string end-1 end] "SM"]} {
        set visibility [sm_to_km $visibility]
    } else {
        ;# assume that units are in meters
        set visibility [m_to_km $visibility]
    }
    set target(vis) $visibility
}

proc decode_cloud {cloud_string} {
    global cloud_table
    upvar 2 target_varname target
    regexp {(SKC|CLR|BKN|SCT|FEW|OVC)(\d{3})?} $cloud_string foo \
        cloud_code cloud_altitude
    if {![info exists cloud_altitude] || [string equal $cloud_altitude ""]} {
        set cloud_altitude 0
    } else {
        set cloud_altitude \
                [feet_to_m [expr [strip_zeros $cloud_altitude] * 100]]
    }
    if {[string equal $cloud_code "SKC"]} {
        set cloud_code "CLR"
    }
    set cloud_type [lindex $cloud_table($cloud_code) 0]
    set cloud_amount [lindex $cloud_table($cloud_code) 1]
    ;# overwrite the old cloud setting if this entry has more clouds
    if {![info exists target(cloud,amt)] || \
            $target(cloud,amt) < $cloud_amount} {
        set target(cloud,type) [msgcat::mc $cloud_type]  
        set target(cloud,alt) $cloud_altitude
        set target(cloud,amt) $cloud_amount
    }
}

proc decode_temperature {temperature_string} {
    upvar 2 target_varname target
    regexp {(M?)(\d{2})\/(M?)(\d{2})} $temperature_string foo \
            sign_air_temp air_temp sign_dew_point dew_point
    if {[info exists sign_air_temp] && [string equal $sign_air_temp "M"]} {
        set air_temp [expr -1 * [strip_zeros $air_temp]]
    } else {
        set air_temp [strip_zeros $air_temp]
    }
    set target(temp,air) $air_temp
    if {[info exists sign_air_temp] && [string equal $sign_dew_point "M"]} {
        set dew_point [expr -1 * [strip_zeros $dew_point]]
    } else {
        set dew_point [strip_zeros $dew_point]
    }
    set target(temp,dew) $dew_point
    ;# calculate the relative humidity
    set sat [expr 6.11 * pow(10, 7.5 * $air_temp / (237.7 + $air_temp))]
    set surf [expr 6.11 * pow(10, 7.5 * $dew_point / (237.7 + $dew_point))]
    set rel_humidity [expr $surf / $sat * 100.0]
    set target(temp,relhum) $rel_humidity
}

proc decode_pressure {pressure_string} {
    upvar 2 target_varname target
    regexp {(A|Q)(\d{4})} $pressure_string foo \
            measurement_type measurement_value
    if {[string equal $measurement_type "A"]} {
        set pressure [inch_to_cm \
            [expr [strip_zeros $measurement_value] / 100.0]]
    } else {
        set pressure [mbar_to_cm [expr [strip_zeros $measurement_value]]]
    }
    set pressure [expr $pressure * 10]
    set target(pres) $pressure
}

proc decode_conditions {conditions_string} {
    upvar 2 target_varname target
    global condition_table
    set condition ""
    while {[string length $conditions_string] > 0} {
      regexp -lineanchor -- {^(-|\+|VC|MI|BC|PR|TS|BL|SH|DR|FZ|DZ|RA|SN|SG|IC|PE|GR|GS|UP|BR|FG|FU|VA|SA|HZ|PY|DU|SQ|SS|DS|PO|FC|.)(.*)} \
              $conditions_string foo cond_type conditions_string
        if {[info exists cond_type] && \
                [info exists condition_table($cond_type)]} {
            append condition "[msgcat::mc $condition_table($cond_type)] "
        }
    }
    lappend target(cond) [string trim $condition]
}

proc strip_zeros {s} {
    while {[string equal [string index $s 0] "0"] && \
            [string is digit -strict [string index $s 1]]} {
        set s [string range $s 1 end]
    }
    return $s
}
