
;######
;# autogenerated utility functions used by fickle; override as needed
;######

proc zzwrap {} {
    return 1
}

proc ECHO {{s ""}} {
    if {[string equal $s ""]} {
        upvar zztext local_zztext
        set s $local_zztext
    }
    global zzout
    puts -nonewline $zzout $s
}

proc ZZ_FLUSH_BUFFER {} {
    global zz_buffer zz_index zz_done
    set zz_buffer ""
    set zz_index 0
    set zz_done 0
}

set ZZ_NULL 0
proc ZZ_INPUT {buf result max_size} {
    global zzin
    upvar $result ret_val
    upvar $buf new_data
    set new_data [read $zzin $max_size]
    set ret_val [string length $new_data]
}

proc unput {c} {
    global zz_buffer zz_index
    set zz_buffer [string replace $zz_buffer $zz_index $zz_index \
                                  "$c[string index $zz_buffer $zz_index]"]
}

proc input {} {
    global zz_buffer zz_index ZZ_NULL zz_done
    if {[expr [string length $zz_buffer] - $zz_index] < 1024} {
       set zz_buffer_size $ZZ_NULL
       if {$zz_done == 0} {
           ZZ_INPUT new_buffer zz_buffer_size 1024
           append zz_buffer $new_buffer
           if {$zz_buffer_size == $ZZ_NULL} {
               set zz_done 1
           }
       }
       if {$zz_done == 1} {
           if {[zzwrap] == 0} {
               return [input]
           } elseif {[expr [string length $zz_buffer] - $zz_index] == 0} {
               return ""
           }
        }
    }
    set c [string index $zz_buffer $zz_index]
    incr zz_index
    return $c
}

proc zz_push_state {new_state} {
    global zz_state_stack
    lappend zz_state_stack $new_state
}

proc zz_pop_state {} {
    global zz_state_stack
    set zz_state_stack [lrange $zz_state_stack 0 end-1]
    if {[string equal $zz_state_stack ""]} {
        zz_push_state INITIAL
    }
}

proc zz_top_state {} {
    global zz_state_stack
    return [lindex $zz_state_stack end]
}

proc BEGIN {new_state {prefix "yy"}} {
    eval global ${prefix}_state_stack
    eval set ${prefix}_state_stack [lrange $${prefix}_state_stack 0 end-1]
    eval lappend ${prefix}_state_stack $new_state
}

;######
;# end autogenerated utility functions
;######


;######
;# autogenerated zzlex function by fickle -- modify at your own peril
;######
proc zzlex {} {
    global zz_first_time zz_buffer zz_index zz_state_stack
    global zz_state_table zzin zzout ZZ_NULL zz_done
    global  rec_name
    if {[info exists zz_first_time] == 0} {
        set zz_first_time ""
        set zz_buffer ""
        set zz_buffer_size $ZZ_NULL
        set zz_index 0
        set zz_state_stack ""
        set zz_done 0
        BEGIN INITIAL zz
        array set zz_state_table [list IN_RECORD 1 INITIAL 0]
        if {[info exists zzin] == 0} {
            set zzin "stdin"
        }
        if {[info exists zzout] == 0} {
            set zzout "stdout"
        }
    }
    while {1} {
        set zz_current_state [zz_top_state]
        if {[expr [string length $zz_buffer] - $zz_index] < 1024} {
            if {$zz_done == 0} {
                set new_buffer ""
                ZZ_INPUT new_buffer zz_buffer_size 1024
                append zz_buffer $new_buffer
                if {$zz_buffer_size == $ZZ_NULL && \
                        [expr [string length $zz_buffer] - $zz_index] == 0} {
                    set zz_done 1
                }
            }
            if {$zz_done == 1} {
                if {[zzwrap] == 0} {
                    set zz_done 0
                    continue
                } elseif {[expr [string length $zz_buffer] - $zz_index] == 0} {
                    break
                }
            }
            
        }
        set zztext ""
        set zz_matched_rule -1
        ;# rule 0: \[.+\] 
        if {[expr \
                {$zz_state_table($zz_current_state) != 1} && \
                {[regexp -start $zz_index -indices -line  -- {\[.+\]} $zz_buffer zz_match] > 0} && \
                {[lindex $zz_match 0] == $zz_index}]} {
            if {[expr [lindex $zz_match 1] - $zz_index + 1] > [string length $zztext]} {
                set zztext [string range $zz_buffer $zz_index [lindex $zz_match 1]]
                set zz_matched_rule 0
            }
        }
        ;# rule 1: <IN_RECORD>name.* 
        if {[expr \
                {[string equal $zz_current_state IN_RECORD]} && \
                {[regexp -start $zz_index -indices -line  -- {name.*} $zz_buffer zz_match] > 0} && \
                {[lindex $zz_match 0] == $zz_index}]} {
            if {[expr [lindex $zz_match 1] - $zz_index + 1] > [string length $zztext]} {
                set zztext [string range $zz_buffer $zz_index [lindex $zz_match 1]]
                set zz_matched_rule 1
            }
        }
        ;# rule 2: <IN_RECORD>loc.* 
        if {[expr \
                {[string equal $zz_current_state IN_RECORD]} && \
                {[regexp -start $zz_index -indices -line  -- {loc.*} $zz_buffer zz_match] > 0} && \
                {[lindex $zz_match 0] == $zz_index}]} {
            if {[expr [lindex $zz_match 1] - $zz_index + 1] > [string length $zztext]} {
                set zztext [string range $zz_buffer $zz_index [lindex $zz_match 1]]
                set zz_matched_rule 2
            }
        }
        ;# rule 3: <IN_RECORD>regions.* 
        if {[expr \
                {[string equal $zz_current_state IN_RECORD]} && \
                {[regexp -start $zz_index -indices -line  -- {regions.*} $zz_buffer zz_match] > 0} && \
                {[lindex $zz_match 0] == $zz_index}]} {
            if {[expr [lindex $zz_match 1] - $zz_index + 1] > [string length $zztext]} {
                set zztext [string range $zz_buffer $zz_index [lindex $zz_match 1]]
                set zz_matched_rule 3
            }
        }
        ;# rule 4: <IN_RECORD>states.* 
        if {[expr \
                {[string equal $zz_current_state IN_RECORD]} && \
                {[regexp -start $zz_index -indices -line  -- {states.*} $zz_buffer zz_match] > 0} && \
                {[lindex $zz_match 0] == $zz_index}]} {
            if {[expr [lindex $zz_match 1] - $zz_index + 1] > [string length $zztext]} {
                set zztext [string range $zz_buffer $zz_index [lindex $zz_match 1]]
                set zz_matched_rule 4
            }
        }
        ;# rule 5: <IN_RECORD>\n\n 
        if {[expr \
                {[string equal $zz_current_state IN_RECORD]} && \
                {[regexp -start $zz_index -indices -line  -- {\n\n} $zz_buffer zz_match] > 0} && \
                {[lindex $zz_match 0] == $zz_index}]} {
            if {[expr [lindex $zz_match 1] - $zz_index + 1] > [string length $zztext]} {
                set zztext [string range $zz_buffer $zz_index [lindex $zz_match 1]]
                set zz_matched_rule 5
            }
        }
        ;# rule 6: <*>\n 
        if {[expr \
                {[regexp -start $zz_index -indices -line  -- {\n} $zz_buffer zz_match] > 0} && \
                {[lindex $zz_match 0] == $zz_index}]} {
            if {[expr [lindex $zz_match 1] - $zz_index + 1] > [string length $zztext]} {
                set zztext [string range $zz_buffer $zz_index [lindex $zz_match 1]]
                set zz_matched_rule 6
            }
        }
        ;# rule 7: . 
        if {[expr \
                {$zz_state_table($zz_current_state) != 1} && \
                {[regexp -start $zz_index -indices -line  -- {.} $zz_buffer zz_match] > 0} && \
                {[lindex $zz_match 0] == $zz_index}]} {
            if {[expr [lindex $zz_match 1] - $zz_index + 1] > [string length $zztext]} {
                set zztext [string range $zz_buffer $zz_index [lindex $zz_match 1]]
                set zz_matched_rule 7
            }
        }
        if {$zz_matched_rule == -1} {
            set zztext [string index $zz_buffer $zz_index]
        }
        set zzleng [string length $zztext]
        incr zz_index $zzleng
        ;# workaround for stupid circumflex behavior
        if {[string equal [string index $zztext end] "\n"]} {
            set zz_buffer [string range $zz_buffer $zz_index end]
            set zz_index 0
        }
        switch -- $zz_matched_rule {
            0
                {
                 set rec_name [string range $zztext 1 end-1]
                                       BEGIN IN_RECORD zz
            }
            1
                {
                add_name $rec_name $zztext
            }
            2
                {
                add_loc $rec_name $zztext
            }
            3
                {
                ;# ignore these
            }
            4
                {
                ;# and these
            }
            5
                {
                BEGIN INITIAL zz
            }
            6
                {
                ;# ignore newlines
            }
            7
                {
                ECHO
            }
            default
                { ECHO }
        }
    }
    return 0
}
;######
;# end autogenerated data
;######


proc add_loc {rec_name loc} {
    global loc_table locations
    if {[regexp {^.+=(((\\\\ )|[^ ])+)\s+(.{4})} $loc foo city bar woz code] \
            == 0} {
        ;# should never get here, but just in case...
        puts stderr "Death on $loc (in $rec_name)."
        exit -1
    }
    regsub -all {\\\\} $city "" city
    regsub -all {\/} $city "-" city
    set locations([file join $loc_table($rec_name) $city]) $code
}

proc add_name {rec_name name} {
    global loc_table locations
    ;# check if this is a subregion
    if {[string length $rec_name] > 4} {
        regexp {^(..)} $rec_name foo parent
        set parent $loc_table($parent)
    } else {
        set parent "/"
    }
    regexp {^name=(.*)} $name foo real_name
    set loc_table($rec_name) [file join $parent $real_name]
    set locations([file join $parent $real_name]) ""
}

global zzin loc_table locations rec_name

puts "Building the locations.cache file..."

if {[catch {open "Locations" r} loc]} {
    puts stderr "Could not open the 'Locations' file."
    exit -1
}
if {[catch {open "locations.cache" w} cache]} {
    puts stderr "Could not open the 'location.cache' file."
    exit -1
}
set zzin $loc
zzlex
close $loc

foreach key [lsort -dictionary [array names locations]] {
    set value $locations($key)
    if {[string equal $value ""]} {
        puts $cache "     $key"
    } else {
        puts $cache "$value $key"
    }
}

close $cache
