;# handles conversions between measuring systems

proc feet_to_m {feet} {
    return [expr $feet * 0.3048]
}

proc inch_to_cm {inch} {
    return [expr $inch * 2.54]
}

proc knots_to_kph {knots} {
    return [expr $knots * 1.851965]
}

proc sm_to_km {sm} {
    return [expr $sm * 1.609344]
}

proc mbar_to_cm {mbar} {
    return [expr $mbar * 0.0752790648]
}

proc m_to_km {m} {
    return [expr $m / 1000.0]
}

proc mm_to_inch {cm} {
    return [expr $cm * 0.039370079]
}

proc km_to_mi {km} {
    return [expr $km * 0.62137119]
}

proc kph_to_mph {kph} {
    return [expr $kph * 0.62137119]
}

proc m_to_ft {m} {
    return [expr $m * 3.2808399]
}

proc tempc_to_tempf {cel} {
    return [expr $cel * 9 / 5 + 32]
}

proc wind_dir {angle} {
    if {[string equal $angle ""]} {
        return "Wind"
    } elseif {$angle < 0} {
        return "Variable winds"
    } elseif {$angle <= 11 || $angle >= 349} {
        return "Winds from the north"
    } elseif {$angle <= 33} {
        return "Winds from the north-northeast"
    } elseif {$angle <= 78} {
        return "Winds from the east-northeast"
    } elseif {$angle <= 101} {
        return "Winds from the east"
    } elseif {$angle <= 123} {
        return "Winds from the east-southeast"
    } elseif {$angle <= 146} {
        return "Winds from the southeast"
    } elseif {$angle <= 168} {
        return "Winds from the south-southeast"
    } elseif {$angle <= 191} {
        return "Winds from the south"
    } elseif {$angle <= 213} {
        return "Winds from the south-southwest"
    } elseif {$angle <= 236} {
        return "Winds from the southwest"
    } elseif {$angle <= 258} {
        return "Winds from the west-southwest"
    } elseif {$angle <= 281} {
        return "Winds from the west"
    } elseif {$angle <= 303} {
        return "Winds from the west-northwest"
    } elseif {$angle <= 326} {
        return "Winds from the northwest"
    } elseif {$angle <= 348} {
        return "Winds from the north-northwest"
    }
    return "Wind"
}