proc to_ascii {c} {
    set retval 0
    scan $c %c retval
    return $retval
}

proc to_chr {n} {
    return [format %c $n]
}

proc trans_lookup {c} {
    if {[string equal $c "="]} {
        return 0
    } else {
        return [lsearch {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z \
                a b c d e f g h i j k l m n o p q r s t u v w x y z \
                0 1 2 3 4 5 6 7 8 9 + - } $c]
    }
}

proc base64_encode {s} {
    set i 0
    foreach c {A B C D E F G H I J K L M N O P Q R S T U V W X Y Z \
            a b c d e f g h i j k l m n o p q r s t u v w x y z \
            0 1 2 3 4 5 6 7 8 9 + - } {
        set trans_table($i) $c
        incr i
    }
    set result ""
    for {set i 0} {$i < [string length $s]} {incr i 3} {
        set in(0) [to_ascii [string index $s [expr $i + 0]]]
        set in(1) [to_ascii [string index $s [expr $i + 1]]]
        set in(2) [to_ascii [string index $s [expr $i + 2]]]
        
        set o(0) $trans_table([expr $in(0) / 4])
        set o(1) $trans_table([expr [expr $in(0) & 0x3] * 16 + $in(1) / 16])
        set o(2) $trans_table([expr [expr $in(1) & 0xf] * 4 + $in(2) / 64])
        set o(3) $trans_table([expr $in(2) & 0x3f])

        if {$i + 2 >= [string length $s]} {
            set o(3) =
            if {$i + 1 >= [string length $s]} {
                set o(2) =
            }
        }
        append result $o(0)$o(1)$o(2)$o(3)
    }
    return $result
}

proc base64_decode {s} {
    set result ""
    for {set i 0} {$i < [string length $s]} {incr i 4} {
        if {[set in(0) [trans_lookup [string index $s [expr $i + 0]]]] < 0} {
            error "Illegal character '[string index $s [expr $i + 0]]'"
        }
        if {[set in(1) [trans_lookup [string index $s [expr $i + 1]]]] < 0} {
            error "Illegal character '[string index $s [expr $i + 1]]'"
        }
        if {[set in(2) [trans_lookup [string index $s [expr $i + 2]]]] < 0} {
            error "Illegal character '[string index $s [expr $i + 2]]'"
        }
        if {[set in(3) [trans_lookup [string index $s [expr $i + 3]]]] < 0} {
            error "Illegal character '[string index $s [expr $i + 3]]'"
        }
        set o(0) [to_chr [expr [expr $in(0) << 2] + \
                [expr [expr $in(1) & 0xf0] >> 4]]]
        set o(1) [to_chr [expr [expr [expr $in(1) & 0x0f] << 4] + \
                [expr [expr $in(2) & 0x3c] >> 2]]]
        set o(2) [to_chr [expr [expr [expr $in(2) & 0x03] << 6] + \
                $in(3)]]
        append result $o(0)$o(1)$o(2)
    }
    return $result
}
