%define name    k6mult
%define version 0.1
%define release 1
%define serial  1
%define prefix  /usr/local/

Summary:        AMD K6-III+/K6-2+(TM) Clock Multiplier Utility
Name:           %{name}
Version:        %{version}
Release:        %{release}
Serial:         %{serial}
Group:		Applications/System
Copyright:      GPL
Url:            http://www.graflex.org/linux/k6mult
Vendor:         Leigh L. Klotz, Jr. <klotz@graflex.org>
Source:         %{name}-%{version}.tar.gz
ExclusiveOS:	Linux
Buildroot:      /var/tmp/%{name}-%{version}-root/
BuildArch:	i586

%description
The k6mult utility sets the CPU multiplier factor on AMD K6-III+ or K6-2+
processors featuring AMD PowerNow(tm).  The CPU clock speed is
determined by multiplying this factor by the Front Side Bus (FSB)
speed.  You should use the k6mult utility if you want to increase the
multiplier factor after boot to overcome boot-time CPU speed
limitations in some BIOSs that do not recognize the K6-III+ or K6-2+,
or to lower the CPU speed after boot to save power.

k6mult comes with a command-line program of the same name to set the CPU multiplier factor immediately, and a boot-time service to set the parameter from a config file (/etc/k6mult.conf).

There are many other "tweaks" available for other processors,
motherboard, and chipsets.  If you have a need to tweak these other
settings, or if you have a CPU other than the K6-III+ or K6-2+, you should use
PowerTweak instead of k6mult.

%pre
# Check the CPU
# This program works only with K6-III+ and K6-2+
# (processors with AMD PowerNow(TM) CPU Family 5, Model 13)
if [ x"`cat /proc/cpuinfo | grep 'cpu family\W*:\W*5\W*$'`" == "x" -o x"`cat /proc/cpuinfo | grep 'model\W*:\W*13\W*$'`" == "x" ];
then
    echo "CPU is not AMD K6-III+ or K6-2+ -- PowerNow(tm) operations not supported"
    exit 1
fi

%prep

%setup -q

%build
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && [ -d $RPM_BUILD_ROOT ] && rm -r $RPM_BUILD_ROOT;
make DESTDIR=$RPM_BUILD_ROOT PREFIX=%{prefix} install device clean

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && [ -d $RPM_BUILD_ROOT ] && rm -r $RPM_BUILD_ROOT;

%files
%defattr(-,root,root)
%{prefix}/sbin/k6mult
%config(noreplace) /etc/k6mult.conf
/etc/rc.d/init.d/*
/dev/cpu/0/msr

%post
if [ -x /sbin/chkconfig ];
then
	chkconfig --add k6mult
elif [ -f /etc/SuSE-release ];
then
	# XXX is there a better way to do this under SuSE?
	ln -s ../k6mult /sbin/init.d/rc2.d/S80k6mult
	ln -s ../k6mult /sbin/init.d/rc2.d/K20k6mult
else
	echo "RPM: Unknown system, leaving system startup alone"
fi

%preun
if [ -x /sbin/chkconfig ];
then
	chkconfig --del k6mult
elif [ -f /etc/SuSE-release ];
then
	rm -f /sbin/init.d/rc2.d/S80k6mult
	rm -f /sbin/init.d/rc2.d/K20k6mult
fi
