/*name and version number:@(#)ltmodem.c	1.7*/
/*date of get: 		  05/10/00 11:23:50*/
/*date of delta:	  04/20/00 18:55:28*/
/****************************************************************
File :  ltmodem.c
Description :
	Contains the interface functions for Linux

Procedures Contained :

****************************************************************/
#include <linux/autoconf.h>
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#   define MODVERSIONS
#endif

#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif

#include <linux/sched.h>   // in order to get jiffies
#include <linux/param.h>   // in order to get HZ
#include <linux/pci.h>     // pci functions
#include <linux/interrupt.h> // in_interrupt macro
#include <linux/time.h>
#include <asm/io.h>
#include "linuxif.h"
 
static struct pci_dev *dev = NULL;
struct timer_list timerList;

void lt_pcibios_read_config_word ( byte bus, byte id1, byte id2, word *result )
{
	pcibios_read_config_word ( bus, id1, id2, result );
}

void lt_pcibios_read_config_byte ( byte bus, byte id1, byte id2, byte *result )	
{
	pcibios_read_config_byte ( bus, id1, id2, result );
}

void lt_pcibios_read_config_dword ( byte bus, byte id1, byte id2, unsigned int *result )
{
	pcibios_read_config_dword ( bus, id1, id2, result );
}

byte Get_PCI_INTERRUPT_LINE ( void )
{
	return PCI_INTERRUPT_LINE;
}

byte Get_PCI_BASE_ADDRESS_1 ( void )
{
	return PCI_BASE_ADDRESS_1;
}

byte Get_PCI_BASE_ADDRESS_2 ( void )
{
	return PCI_BASE_ADDRESS_2;
}

dword Get_PCI_BASE_ADDRESS_IO_MASK ( void )
{
	return PCI_BASE_ADDRESS_IO_MASK;
}

byte Get_PCI_BASE_ADDRESS_SPACE_IO ( void )
{
	return PCI_BASE_ADDRESS_SPACE_IO;
}

BOOL lt_pci_present ( void )
{
	return pci_present ();
}

struct PCI_IDs {
	int vendor_id;
	int device_id_start;
	int device_id_last;
};

static struct PCI_IDs pci_ids[] = {
{0x115d, 0x0010, 0x03ff},
};

#ifdef MODULE
int lt_get_vendor_id(void);
int lt_get_device_id(void);
#endif

BOOL lt_pci_find_device ( unsigned int id, unsigned int num )
{
 	dev = pci_find_device ( id, num, dev );
	if ((dev) && (dev->irq))
	{
		return TRUE;
	}
	if (id == PCI_VENDOR_ID_ATT && num == PCI_DEVICE_ID_ATT_L56XMF)
	{
		int len = sizeof(pci_ids)/sizeof(pci_ids[0]);
		int i;
		for(i=0;i<len;i++)
		{
			int devid;
			for(devid=pci_ids[i].device_id_start; 
			    devid<=pci_ids[i].device_id_last;
			    devid++)
			{
				if (pci_ids[i].vendor_id && devid)
				{
					dev = pci_find_device( pci_ids[i].vendor_id, devid, dev);
					if ((dev) && (dev->irq))
					{
						return TRUE;
					}
				}
			}
		}
#ifdef MODULE
		if (lt_get_vendor_id() && lt_get_device_id())
		{
			dev = pci_find_device ( lt_get_vendor_id(), lt_get_device_id(), dev );
			if ((dev) && (dev->irq))
			{
				return TRUE;
			}
		}
#endif
	}
	return FALSE;
}

byte GetIrqFromDev ( void )
{
	return (byte)dev->irq;
}

byte GetBusNumberFromDev ( void )
{
	return (byte)dev->bus->number ;
}

byte GetDevfnFromDev ( void )
{
	return (byte)dev->devfn;
}

word GetDeviceFromDev ( void )
{
	return dev->device;
}

word GetVendorFromDev ( void )
{
	return dev->vendor;
}

dword GetBase_addressFromDev ( int num )
{
	return dev->base_address[num];
}

void lt_add_timer( void (*timerfunction)(unsigned long) )
{
	timerList.expires = jiffies+1;
	timerList.function = timerfunction;
	timerList.data = 0;
	add_timer(&timerList);
}

dword VMODEM_Get_System_Time (void)
{
	struct timeval time;
	do_gettimeofday( &time);
	return((time.tv_usec/1000)+(time.tv_sec*1000));
}

void lt_init_timer ( void  )
{
	init_timer(&timerList);
}

byte inp (word addr )
{
  return inb(addr);
}

void outp (word addr, byte value )
{
    outb(value, addr);
}

word inpw(word addr)
{
	return inw(addr);
}

void outpw(word addr, word value)
{
	return outw(value, addr);
}

dword inpd(word addr)
{
	return inl(addr);
}

void outpd(word addr, dword value)
{
	return outl(value, addr);
}
