/* [sharpgen.h]																*/
/*																			*/
/* Copyright(C) 2002-2003, SHARP CORPORATION, All rights reserved.			*/
/*																			*/
/* This file is used for SL-series Zaurus PIM application. 		            */
/* This file is provided AS-IS for those who needs to know the details,		*/
/* and no technical support is assumed.			                            */

#ifndef _SHARP_GENERAL_H_DEFINED

/*======================================================================
======================================================================*/
#ifndef _UCHAR_DEFINED
typedef unsigned char 	UCHAR;
#define	_UCHAR_DEFINED
#endif

#ifndef	_USHORT_DEFINED 
typedef unsigned short 	USHORT;
#define	_USHORT_DEFINED
#endif

#ifndef	_UINT_DEFINED 
typedef unsigned int 	UINT;
#define	_UINT_DEFINED
#endif

#ifndef	_ULONG_DEFINED
typedef unsigned long	ULONG;
#define	_ULONG_DEFINED
#endif

/*======================================================================
======================================================================*/
#if defined(__cplusplus)
typedef int BOOLEAN;
#else
typedef enum BOOLEAN {
	false,
	true
} BOOLEAN;
#endif

#ifndef TRUE
#define TRUE	1
#endif

#ifndef FALSE
#define FALSE	0
#endif

/*======================================================================

======================================================================*/
#ifndef	_POINT_DEFINED
typedef struct POINT {
	short	x;
	short	y;
} POINT;
#define	_POINT_DEFINED
#endif

#ifndef _UPOINT_DEFINED
typedef struct UPOINT {
	USHORT	x;
	USHORT	y;
} UPOINT;
#define	_UPOINT_DEFINED
#endif

#ifndef	_RECTANGLE_DEFINED
typedef struct RECTANGLE {
	short	left;
	short	top;
	USHORT	width;
	USHORT	height;
} RECTANGLE;
#define	_RECTANGLE_DEFINED
#endif

/*======================================================================
======================================================================*/
typedef USHORT	RESTYPE;		
typedef USHORT	RESFNO;			
typedef USHORT	RESID;			
typedef	UCHAR	RESFNAME[9];	


typedef struct RESOURCE {
	UCHAR	ResFile[9];
	USHORT	ResID;
} RESOURCE;


typedef struct APLRES {
	RESID	ResID;
	RESFNO	ResFNo;
} APLRES;

/*======================================================================
======================================================================*/
#ifndef __STDC__
typedef UCHAR	**HANDLE;
typedef UCHAR	*PTR;
#define	INTEGER	register UCHAR	/*MACRO*/
#else
#if !defined(_WS_QWS_)
typedef void	**HANDLE;
#endif
typedef void	*PTR;
#define	INTEGER	UINT			/*MACRO*/
#endif

/*======================================================================
======================================================================*/
typedef void	(*PROC)();		
typedef int		(*iPROC)();	
typedef UCHAR	(*ucPROC)();	
#if !defined(_WS_QWS_)
typedef	HANDLE	(*hPROC)();	
#endif
typedef	PTR 	(*pPROC)();	

/*======================================================================
======================================================================*/

#ifndef DONE
#define	DONE	0	
#endif

#ifndef ERROR
#define	ERROR	1	
#endif

#ifndef DUMMY_AREA_PTR
#define DUMMY_AREA_PTR	((void*)0)
#endif

typedef ULONG	APLID;			
typedef	ULONG	TOOLID;
typedef USHORT	KEYCODE;		
typedef UCHAR	KEYATTR;		


typedef UCHAR	WINDOWHD;


typedef USHORT	MESSAGEID;


typedef	UCHAR	*STRING;

#if !defined(_WS_QWS_)
typedef struct CBPROC {
	PROC Proc;
	USHORT Lang;
} CBPROC;

typedef struct ucCBPROC {
	ucPROC Proc;
	USHORT Lang;
} ucCBPROC;

typedef struct hCBPROC {
	hPROC Proc;
	USHORT Lang;
} hCBPROC;

typedef struct CB {
	CBPROC		Func;
	void		*Work;
} CB;

typedef union DISPDATA {
	RESOURCE	ResData;
	CB			CallBack;
	PTR			DataPtr;
} DISPDATA;


typedef UCHAR	DISPDATA_TYPE;
#define	DISPDATA_RES	1
#define	DISPDATA_CB		2
#define	DISPDATA_PTR	3


typedef union PROPERTY_V {
	UCHAR	ucValue;
	USHORT	usValue;
	UINT	uiValue;
	ULONG	ulValue;
	char	cValue;
	short	sValue;
	int		iValue;
	long	lValue;
	PTR		pValue;
	HANDLE	hValue;
	BOOLEAN	blValue;
	PROC	procValue;
} PROPERTY_V;
#endif

/*======================================================================
======================================================================*/
#ifdef ZDC_BIGENDIAN

#define SetWToBArray(Barray,Word)       \
                (*(((UCHAR*)(Barray))+0)        = (Word)>>8, \
                 *(((UCHAR*)(Barray))+1)        = (Word))

#define GetWFromBArray(Barray)          \
                ((*(((UCHAR*)(Barray))+0)<<8)+(*(((UCHAR*)(Barray))+1)))


#define SetLToBArray(Barray,LWord)      \
        (*(((UCHAR*)(Barray))+0)        = (LWord)>>24,  \
         *(((UCHAR*)(Barray))+1)        = (LWord)>>16,  \
         *(((UCHAR*)(Barray))+2)        = (LWord)>>8,   \
         *(((UCHAR*)(Barray))+3)        = (LWord))

#define GetLFromBArray(Barray)                  \
                ((*(((UCHAR*)(Barray))+0)<<24)+(*(((UCHAR*)(Barray))+1)<<16) \
                 +(*(((UCHAR*)(Barray))+2)<<8)+(*(((UCHAR*)(Barray))+3)))
#else /* ZDC_BIGENDIAN */

#define	SetWToBArray(Barray,Word)	(*((UCHAR*)(Barray))	= (Word),	\
									 *((UCHAR*)(Barray)+1)	= (Word)>>8)

#define	GetWFromBArray(Barray)			\
		(*((UCHAR*)(Barray))+(*((UCHAR*)(Barray)+1)<<8))


#define	SetLToBArray(Barray,LWord)	(*((UCHAR*)(Barray))	= (LWord),		\
									 *((UCHAR*)(Barray)+1)	= (LWord)>>8,	\
									 *((UCHAR*)(Barray)+2)	= (LWord)>>16,	\
									 *((UCHAR*)(Barray)+3)	= (LWord)>>24)

#define	GetLFromBArray(Barray)			\
		(*((UCHAR*)(Barray))+(*((UCHAR*)(Barray)+1)<<8)	\
		 +(*((UCHAR*)(Barray)+2)<<16)+(*((UCHAR*)(Barray)+3)<<24))
#endif /* ZDC_BIGENDIAN */


char *itoa(int val, char *str, int rad);
#ifndef ZDCX_EMULATOR

#include <string.h>

#define NewHeapPtr	malloc
#define DisposeHeapPtr free
#define sys_malloc malloc
#define sys_free free
#if !defined(_WS_QWS_)
HANDLE NewHeapHandle(int);
void DisposeHeapHandle(HANDLE);
#endif

#else /* ZDC_EMULATOR */
int strncasecmp(char *src, char *trg, int len);
#define	strcasecmp(s,t)		strncasecmp(s,t,0)
#endif /* ZDC_EMULATOR */

/*======================================================================
======================================================================*/
void
ZSysDbgMessage(STRING str);
BOOLEAN
ZSysDbgWindow(STRING str,STRING str2,int num);
#define	ZSysAssert(value)	\
((void)((value) ||	\
	(ZSysDbgWindow((UCHAR*)#value,(UCHAR*)__FILE__,__LINE__))))

#ifdef FINAL_RELEASE
#define	ZDbgMessage(str)			ZSysDbgMessage(str)
#define	ZDbgWindow(str,str2,num)	ZSysDbgWindow(str,str2,num)
#define	ZAssert(value)				ZSysAssert(value)
#else
#define	ZDbgMessage(str)
#define	ZDbgWindow(str,str2,num)
#define	ZAssert(value)
#endif


#define	ZDebugMessage(str)			ZDbgMessage(str)
#define	ZDebugWindow(str,str2,num)	ZDbgWindow(str,str2,num)



#define	_SHARP_GENERAL_H_DEFINED
#endif

