/* [abort.h]																*/
/*																			*/
/* Copyright(C) 2002-2003, SHARP CORPORATION, All rights reserved.			*/
/*																			*/
/* This file is used for SL-series Zaurus PIM application. 		            */
/* This file is provided AS-IS for those who needs to know the details,		*/
/* and no technical support is assumed.			                            */

#ifndef _ABORT_H_INCLUDED

#ifdef ZDCX_LINUX
#include <privenv.h>
#endif

/*======================================================================
		
======================================================================*/

#define	PRIVENV_NAME_ABORT	0x41424F54	


/*======================================================================
		
======================================================================*/

typedef unsigned long ABORTFLAG;
typedef unsigned long ABORTMASK;	
typedef	unsigned long ABORTCOND;	



#define	ABORT_PCCARD_BATT_SHORT	0x00000001	

#define	ABORT_OFF		0x00000004	
#define	ABORT_AUTO_POWER_OFF	0x00000008	

#define	ABORT_BATT_COVER_OPEN	0x00000020	
#define	ABORT_FATAL_LOW_BATT	0x00000040	
#define	ABORT_BREAK            	0x00000080	

#define	ABORT_PCCARD0_EJECTBTN	0x00010000	
#define	ABORT_PCCARD0_REMOVED	0x00020000	
#define	ABORT_PCCARD0_SHUTDOWN	0x00040000	
#define	ABORT_PCCARD0_WPCHANGED	0x00080000	


#define	ABORT_ALL      		0xFFFFFFFF	
#define	ABORT_MAINUNIT_ALL     	0x000000FF	
#define	ABORT_PCCARD0_ALL      	0x000F0000	


/*----------------------------------

----------------------------------*/

#define	ABORT_NONE	0	


#ifndef ZDCX_LINUX
#define SetAbort(Flag)
#define	ClearAbort(Flag)
#define LookAbort()			(0)
#define	GetAbortFlagAdr()

#else
/*======================================================================
		
======================================================================*/

#define SetAbort(Flag)		SetBitPrivEnv(PRIVENV_NAME_ABORT,Flag)
#define	ClearAbort(Flag)	ClearBitPrivEnv(PRIVENV_NAME_ABORT,Flag)
#define LookAbort()    		((ABORTFLAG)ReadValuePrivEnv(PRIVENV_NAME_ABORT))
#define	GetAbortFlagAdr()	((ABORTFLAG*)GetAdrPrivEnv(PRIVENV_NAME_ABORT))

#endif


#define _ABORT_H_INCLUDED
#endif /* _ABORT_H_INCLUDED */
