/* John Goerzen

   This module contains wrappers around a number of system calls so that
   a default error behavior can be defined.

Originally for: CS697L assignment 3 (shell)
Modified for: Wichita State University CS Dept. handin project
*/

/* 	$Id: safesyscall.c,v 1.4 1997/09/29 22:26:25 jgoerzen Exp $	 */

#ifndef lint
static char vcid[] = "$Id: safesyscall.c,v 1.4 1997/09/29 22:26:25 jgoerzen Exp $";
#endif /* lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <malloc.h>
#include <signal.h>

#include "handin.h"

char *safestrdup(const char *s)
{
  char *retval;

  retval = strdup(s);
  if (!retval)
    err_quit("strdup on %s failed", s);
  return retval;
}

char *safestrncpy(char *dest, const char *src, size_t n)
{
  if (strlen(src) >= n)
    err_quit("safestrncpy: Attempt to copy string %s\nto buffer %d bytes long", src, (int) n);
  return strncpy(dest, src, n);
}

char *safestrcat(char *dest, const char *src, size_t n)
{
  if ((strlen(src) + strlen(dest)) >= n)
    err_quit("Attempt to strcat too big a string");
  return strncat(dest, src, n);	/* Yes, I know that n has a different
				 meaning to strncat, but I use it anyway. */
}


int safekill(pid_t pid, int sig)
{
  int retval;

  retval = kill(pid, sig);
  if (retval == -1)
    err_sys("kill (pid %d, sig %d) failed", (int) pid, sig);
  return retval;
}


char *safegetenv(const char *name)
{
  char *retval;

  retval = getenv(name);
  if (!retval)
    err_sys("getenv on %s failed", name);
  return retval;
}

int safechdir(const char *path)
{
  int retval;

  retval = chdir(path);
  if (retval == -1)
    err_sys("chdir to %s failed", path);
  return retval;
}

int safemkdir(const char *path, mode_t mode)
{
  int retval;

  retval = mkdir(path, mode);
  if (retval == -1)
    err_sys("mkdir %s failed", path);
  return retval;
}

int safestat(const char *file_name, struct stat *buf)
{
int retval;
  retval = stat(file_name, buf);
  if (retval == -1)
    err_sys("Couldn't stat %s", file_name);
  return retval;
}  

int safeopen(const char *pathname, int flags)
{
int retval;
  if ((retval = open(pathname, flags)) == -1) {
    err_sys("open %s failed", pathname);
  }
  return retval;
}

int safeopen2(const char *pathname, int flags, mode_t mode)
{
  int retval;

  retval = open(pathname, flags, mode);
  if (retval == -1)
    err_sys("Open %s failed", pathname);
  return retval;
}

int safepipe(int filedes[2])
{
  int retval;

  retval = pipe(filedes);
  if (retval == -1)
    err_sys("pipe failed");
  return retval;
}

int safedup2(int oldfd, int newfd)
{
  int retval;

  retval = dup2(oldfd, newfd);
  if (retval == -1)
    err_sys("dup2 failed"); 
  return retval;
}

int safeexecvp(const char *file, char *const argv[])
{
  int retval;

  retval = execvp(file, argv);
  if (retval == -1)
    err_sys("execvp %s failed", file);
  return retval;
}

int saferead(int fd, void *buf, size_t count)
{
  int retval;

  retval = read(fd, buf, count);
  if (retval == -1)
    err_sys("read %d bytes from fd %d failed", (int) count, fd);
  return retval;
}

int safewrite(int fd, const char *buf, size_t count)
{
  int retval;

  retval = write(fd, buf, count);
  if (retval == -1)
    err_sys("write %d bytes to fd %d failed", (int) count, fd);
  return retval;
}

int safeclose(int fd)
{
  int retval;

  retval = close(fd);

  if (fd == -1) {
    err_sys("Possible serious problem: close failed");
  }
  return retval;
}

FILE *safefopen(char *path, char *mode)
{
  FILE *retval;

  retval = fopen(path, mode);
  if (!retval)
    err_sys("fopen %s failed", path);
  return retval;
}

size_t safefread(void *ptr, size_t size, size_t nmemb, FILE *stream)
{
  size_t retval;

  retval = fread(ptr, size, nmemb, stream);
  if (ferror(stream))
    err_sys("fread failed");
  return retval;
}

size_t safefwrite(void *ptr, size_t size, size_t nmemb, FILE *stream)
{
  size_t retval;

  retval = fread(ptr, size, nmemb, stream);
  if (ferror(stream))
    err_sys("fwrite failed");
  return retval;
}

int safefclose(FILE *stream)
{
  int retval;

  retval = fclose(stream);
  if (retval != 0)
    err_sys("Possibly serious error: fclose failed");
  return retval;
}

int safefflush(FILE *stream)
{
  int retval;

  retval = fflush(stream);
  if (retval != 0)
    err_sys("fflush failed");
  return retval;
}

void *safemalloc(size_t size)
{
  void *retval;

  retval = malloc(size);
  if (!retval)
    err_sys("malloc failed");
  return retval;
}

