/*			HANDIN PROGRAM
			John Goerzen
			jgoerzen@complete.org

			CS697L
			   Assignment 2
			   
$Id: log.c,v 1.13 2002/04/24 19:19:05 jgoerzen Exp $

*/

#define __JG_LOG_C__

#include <unistd.h>
#include <sys/types.h>
#include <string.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdarg.h>
#include "handin.h"

/* A general note: from within this file, errexit() is used exclusively instead
   of logerrexit().  This is because, if loghandin() or logerror() fails, then
   a later call to the same function likely will fail as well, thus getting
   into an infinite loop.  So failed log attempts are NOT recorded in any
   log. */

static int ISINLOG = 0;

/* The above variable will be 1 whenever in a LOG function or 0 otherwise.
   This way, if a call to some other thing like a mkdir function fails and
   it tries to log it, there won't be a recursive loop. */

void loghandin(char *file)
{
int logfile;
char logfilename[MAXFILENAME];
char logmsg[MAXFILENAME + 80];
char date[50];

  if (ISINLOG) {
    fprintf(stderr, "loghandin %s: Already in LOG function (internal error)\n", file);
    return;
  } else
    ISINLOG = 1;
  snprintf(logfilename, sizeof(logfilename), "%s/handin", homedir);
  classperms();
  modckmkdirname(logfilename, 0700);
  userperms();
  safestrcat(logfilename, "/log", sizeof(logfilename));
  classperms();
  modckmkdirname(logfilename, 0700);
  userperms();
  safestrcat(logfilename, "/handin.log", sizeof(logfilename));
  classperms();
  logfile = safeopen2(logfilename, O_WRONLY | O_CREAT | O_APPEND, 0600);
  userperms();

  /* ctime() has the annoying behavior of sticking a newline at the end
     of the string it returns.  So we have to strip it off. */
  
  safestrncpy(date, ctime(timeptr(time(NULL))), sizeof(date));
  stripcrlf(date);

  snprintf(logmsg, sizeof(logmsg), "%s:%s:%s:%s\n",
  		  date,
  		  username,
  		  assign,
  		  file);
  classperms();
  write_buffer(logfile, logmsg, strlen(logmsg));
  safeclose(logfile);
  userperms();
  ISINLOG = 0;
}

void logerror(const char *fmt, ...)
{
  va_list ap;

  va_start(ap, fmt);
  logerrorap(0, fmt, ap);
  va_end(ap);
}

void logerrorap(int errnoflag, const char *fmt, va_list ap)
{
int logfile;
char logfilename[MAXFILENAME + sizeof(homedir)];
char logmsg[MAXFILENAME + 15000];
char date[50];

  if (ISINLOG) {
    fprintf(stderr, "logerror: Already in LOG function (internal error)\n");
    return;
  } else
    ISINLOG = 1;

  snprintf(logfilename, sizeof(logfilename), "%s/handin", homedir);
  classperms();
  modckmkdirname(logfilename, 0700);
  userperms();
  safestrcat(logfilename, "/log", sizeof(logfilename));
  classperms();
  modckmkdirname(logfilename, 0700);
  userperms();
  safestrcat(logfilename, "/errors.log", sizeof(logfilename));
  classperms();
  logfile = safeopen2(logfilename, O_WRONLY | O_CREAT | O_APPEND, 0600);
  userperms();
  
  /* ctime() has the annoying behavior of sticking a newline at the end
     of the string it returns.  So we have to strip it off. */
  
  safestrncpy(date, ctime(timeptr(time(NULL))), sizeof(date));
  stripcrlf(date);

  snprintf(logmsg, sizeof(logmsg), "%s:%s:",
  		  date,
  		  username);
  classperms();
  write_buffer(logfile, logmsg, strlen(logmsg));
  userperms();
  vsnprintf(logmsg, sizeof(logmsg), fmt, ap);/* Write out message and format */
#ifdef linux
    if (errnoflag) {
      safestrcat(logmsg, ": ", sizeof(logmsg));
      safestrcat(logmsg, strerror(errnoflag), sizeof(logmsg));
    }
#endif      
  safestrcat(logmsg, "\n", sizeof(logmsg));
  classperms();
  write_buffer(logfile, logmsg, strlen(logmsg));
  safeclose(logfile);
  userperms();
  ISINLOG = 0;
  va_end(ap);
}
