/*			HANDIN PROGRAM
			John Goerzen
			jgoerzen@complete.org

Originally for:		CS697L
			   Assignment 2

Modified for:           CS Dept., Wichita State University

		MASTER INCLUDE FILE
			   
$Id: handin.h,v 1.16 2002/04/24 19:19:05 jgoerzen Exp $

*/

#ifndef __HANDIN_H__
#define __HANDIN_H__

#ifndef __HANDIN_C__
#define H_EXTERN extern
#else
#define H_EXTERN
#endif



/* Define common values if not defined already. */

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL 0
#endif

#ifndef MAXDIRNAME
#define MAXDIRNAME 5000
#endif

#ifndef MAXFILENAME
#define MAXFILENAME (MAXDIRNAME + 5000)
#endif

/* Include system header files required for declaring global variables
   */
   
#include <time.h>

/* Global variables */

#ifndef __HANDIN_C__
H_EXTERN time_t duedate, latedate;
H_EXTERN int noreplaceprompt;
#else
time_t duedate = 0, latedate = 0;	/* Cannot declare extern and
					   initialize at the same time. 
					   (well, not a good idea anyway) */
#endif

H_EXTERN char homedir[MAXDIRNAME];
H_EXTERN char username[20];	/* username of person handing in files */
H_EXTERN char assign[MAXFILENAME];	/* Assignment number/code */

/* Public functions defined in handin.h */

H_EXTERN int errexit(char *msg);
H_EXTERN int logerrexit(char *msg);

 /* Include other .h files as necessary: */

#include "setid.h"	/* Initialization of set[ug]id stuff */
#include "perms.h"	/* Processing of set[ug]id stuff */
#include "copy.h"	/* Initialization of copying for each item */
#include "copyfile.h"	/* Copies files */
#include "log.h"	/* Writes to the logfile */
#include "dirmanip.h"	/* Creates directories, checks if dirs exist, etc */
#include "date.h"	/* date/time manipulation routines */
#include "safesyscall.h" /*Routines to make system calls safer */
#include "error.h"      /* Routines to handle error conditions gracefully */
#include "exit.h"       /* Routines to exit gracefully */

#endif					/* __HANDIN_H__ */
