/* Handling of error conditions
   CS697L
   John Goerzen

   This is a modified version of the code in the textbook.
   Originally for: CS697L assignment 3
   Modifid for: Wichita State University CS Dept.

   */
/* 	$Id: error.c,v 1.3 1997/09/29 22:26:23 jgoerzen Exp $	 */

#ifndef lint
static char vcid[] = "$Id: error.c,v 1.3 1997/09/29 22:26:23 jgoerzen Exp $";
#endif /* lint */

#define __JG_ERROR_C__

#include <errno.h>		/* definition of errno */
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <setjmp.h>
#include "handin.h"

int shouldlogerror = 0;		/* Global variable -- 1 to log errors. */

/* Sun doesn't have strerror()... (surprise, surprise).  Have to make do
   without it. */

#ifdef sun
extern char *sys_errlist[];
#endif


static void err_doit(int errnoflag, const char *fmt, va_list ap);

/* Fatal error related to a system call.  Print message and terminate. */

void err_sys(const char *fmt, ...)
{
  va_list ap;

  errors++;
  va_start(ap, fmt);
  err_doit(1, fmt, ap);
  va_end(ap);
  exit(1);
}

/* Fatal error related to system call.  Print a message and dump core. */

void err_dump(const char *fmt, ...)
{
  va_list ap;

  errors++;
  va_start(ap, fmt);
  err_doit(1, fmt, ap);
  va_end(ap);
  abort();			/* Dump core and terminate */
  exit(1);			/* Shouldn't get here */
}

/* Fatal error unrelated to a system call.  Print a message and terminate. */

void err_quit(const char *fmt, ...)
{
  va_list ap;

  errors++;
  va_start(ap, fmt);
  err_doit(0, fmt, ap);
  va_end(ap);
  exit(1);
}

/* Print message and return. 

The book's code for this had a potential for a buffer overrun.  This has been
corrected. */

static void err_doit(int errnoflag, const char *fmt, va_list ap)
{
  int errno_save;

  userperms();

  errno_save = errno;		/* Value to possibly print */
  fflush(stdout);		/* In case same as stderr */
  fflush(stderr);
  fprintf(stderr, "\n------------------ ERROR -----------------------------------------------\a\n");
  vfprintf(stderr, fmt, ap);
  if (errnoflag)
#ifdef linux
    fprintf(stderr, ": %s", strerror(errno_save));
#else
    fprintf(stderr, ": %s", sys_errlist[errno_save]);
#endif
  fprintf(stderr, "\n");	/* Add trailing newline */
  fprintf(stderr, "------------------ ERROR -----------------------------------------------\a\n");
  if (shouldlogerror) logerrorap((errnoflag) ? errno_save : 0, fmt, ap);
#ifdef linux
  fflush(NULL);			/* Flush all output streams */
#else
  fflush(stderr);		/* fflush(NULL) coredumps on Sun! */
#endif
}
