/*			HANDIN PROGRAM
			John Goerzen
			jgoerzen@complete.org
			jgoerzen@complete.org

			CS697L
			   Assignment 2

Modified for WSU CS Dept. Handin program
			   
$Id: date.c,v 1.8 2002/04/24 19:19:05 jgoerzen Exp $

*/

#define __JG_DATE_C__

#include <time.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "handin.h"

time_t parsedate(char *date)
{
char *smonth, *sday, *syear;	/* Parsed from string */ 
int month, day, year;		/* Converted to integers */
struct tm tmstruct;

  smonth = strtok(date, "/-");
  sday = strtok(NULL, "/-");
  syear = strtok(NULL, "/-");
  
  month = atoi(smonth);
  day = atoi(sday);
  year = atoi(syear);
  
  if (!(smonth && sday && syear && month && day && year))
    err_quit("Couldn't parse duedate or latedate");
  
  /* Now set our values. */
  
  tmstruct.tm_sec = 
    tmstruct.tm_min =
    tmstruct.tm_hour = 0;
  tmstruct.tm_mday = day;
  tmstruct.tm_mon = month - 1;
  tmstruct.tm_year = (year > 1900) ? (year - 1900) : year;
  tmstruct.tm_isdst = -1;			/* Not available */
  return mktime(&tmstruct) + (60 * 60 * 24) - 1;
  			     /* Make it one second before midnight */
}

/* For some strange reason, functions like ctime ask for a pointer to
   a time_t (integer).  This is inconvenient because functions like
   time() return an integer, not a pointer to one.  This function allows
   the use of time() without having to resort to temporary variables, etc.
   */

time_t *timeptr(time_t tval)
{
static time_t timet;
  timet = tval;
  return &timet;
}
