# gopher.py
# Gopher protocol definitions.
# Written by David Allen <s2mdalle@titan.vcu.edu>
########################################################################
RESPONSE_FILE    = '0' # Item is a file
RESPONSE_DIR     = '1' # Item is a directory
RESPONSE_CSO     = '2' # Item is a CSO phone-book server
RESPONSE_ERR     = '3' # Error
RESPONSE_BINHEX  = '4' # Item is a BinHexed Macintosh file.
RESPONSE_DOSBIN  = '5' # Item is DOS binary archive of some sort.
RESPONSE_UUE     = '6' # Item is a UNIX uuencoded file.
RESPONSE_INDEXS  = '7' # Item is an Index-Search server.
RESPONSE_TELNET  = '8' # Item points to a text-based telnet session.
RESPONSE_BINFILE = '9' # Item is a binary file!
RESPONSE_REDSERV = '+' # Item is a redundant server
RESPONSE_TN3270  = 'T' # Item points to a text-based tn3270 session.
RESPONSE_GIF     = 'g' # Item is a GIF format graphics file.
RESPONSE_IMAGE   = 'I' # Item is some kind of image file.
RESPONSE_UNKNOWN = '?' # Unknown.  WTF?
RESPONSE_BITMAP  = ':' # Gopher+ Bitmap response
RESPONSE_MOVIE   = ";" # Gopher+ Movie response
RESPONSE_SOUND   = "<" # Gopher+ Sound response

# The following are types not found in the RFC definition of gopher but that
# I've encountered on the net, so I added
RESPONSE_BLURB   = 'i'
RESPONSE_HTML    = 'h'

# Gopher+ errors
ERROR_NA         = '1' # Item is not available.
ERROR_TA         = '2' # Try again later (eg. My load is too high right now.)
ERROR_MOVED      = '3' # Item has moved.

responses = { "%s" % RESPONSE_FILE    : "File:",
              "%s" % RESPONSE_DIR     : "Directory:",
              "%s" % RESPONSE_CSO     : "CSO phone-book server:",
              "%s" % RESPONSE_ERR     : "Error:",
              "%s" % RESPONSE_BINHEX  : "BinHexed Macintosh file:",
              "%s" % RESPONSE_DOSBIN  : "DOS binary archive:",
              "%s" % RESPONSE_UUE     : "UNIX UUEncoded file:",
              "%s" % RESPONSE_INDEXS  : "Index-Search server:",
              "%s" % RESPONSE_TELNET  : "Telnet session:",
              "%s" % RESPONSE_BINFILE : "Binary file:",
              "%s" % RESPONSE_REDSERV : "Redundant server:",
              "%s" % RESPONSE_TN3270  : "tn3270 session:",
              "%s" % RESPONSE_GIF     : "GIF file:",
              "%s" % RESPONSE_IMAGE   : "Image file:",
              "%s" % RESPONSE_BLURB   : " ",
              "%s" % RESPONSE_HTML    : "HTML file:",
              "%s" % RESPONSE_BITMAP  : "Bitmap Image:",
              "%s" % RESPONSE_MOVIE   : "Movie:",
              "%s" % RESPONSE_SOUND   : "Sound:",
              "%s" % RESPONSE_UNKNOWN : "Unknown:" }
errors    = { "%s" % ERROR_NA         : "Error: Item is not available.",
              "%s" % ERROR_TA         : "Error: Try again (server busy)",
              "%s" % ERROR_MOVED      : "Error: This resource has moved." }

