# Options.py
# Written by David Allen <s2mdalle@titan.vcu.edu>
#
# Eventually this will hold all program options, and maybe be incorporated
# into some sort of options editor.
#
# For now, it holds information about what the program should and shouldn't
# do.  Variable names should be pretty self explanatory.
#############################################################################
import os
from string import *

class Options:
    def __init__(self, *args):
        # Default values for some important options...
        self.setDefaultOpts()
        return None
    def exists(self, filename):
        try:
            stuff = os.stat(filename)
            return 1
        except OSError:
            return None
        return None
            
    def setDefaultOpts(self):
        self.opts = {}
        self.opts['prefs_directory'] = "%s%s%s" % (os.path.expanduser("~"),
                                                   os.sep, ".forg")

        if not self.exists(self.opts['prefs_directory']):
            os.mkdir(self.opts['prefs_directory'])
            
        self.opts['grab_resource_info']     = None
        self.opts['save_options_on_exit']   = 1
        self.opts['strip_carraige_returns'] = 1
        self.opts['show_cached']            = 1
        self.opts['display_info_in_directories'] = None

        basedir = self.getOption('prefs_directory')

        pkey = 'prefs_directory'

        self.opts['cache_directory'] = "%s%s%s" % (self.opts[pkey],
                                                   os.sep,
                                                   "cache")

        if not self.exists(self.opts['cache_directory']):
            os.mkdir(self.opts['cache_directory'])
        
        self.opts['cache_prefix'] = "%s%s%s" % (self.opts['cache_directory'],
                                                os.sep,
                                                "cache-")
        return None
    def getOption(self, optionname):
        """Get an option named optionname."""
        try:
            optionname = lower(optionname)
            return self.opts[optionname]
        except KeyError:
            return None
    def toString(self):
        return self.__str__()
    
    def __str__(self):
        # God I love the map() function.
        lines = map(lambda x, self=self: "%s = %s" % (x, self.opts[x]),
                    self.opts.keys())
        comments = "%s%s%s" % ("# Options for the FORG\n",
                               "# Please don't edit me unless you know what\n",
                               "# you're doing.\n")
        return comments + join(lines, "\n") + "\n"
    def parseFile(self, filename):
        """Parse filename into a set of options.  Caller is responsible
        for catching IOError related to reading files."""
        print "Previously had %d keys" % len(self.opts.keys())
        self.setDefaultOpts()
        fp = open(filename, "r")

        line = fp.readline()
        line_num = 0
        while line != '':
            line_num = line_num + 1
            commentIndex = find(line, "#")
            if commentIndex != -1:
                line = line[0:commentIndex]

            line = strip(line)
            if line == '':
                continue
            
            items = split(line, "=")
            if len(items) < 2:
                print "Options: no '=' on line number %d" % line_num
                continue
            if len(items) > 2:
                print "Options: too many '=' on line number %d" % line_num
                continue
            
            key = lower(strip(items[0]))
            val = lower(strip(items[1]))

            # Figure out what the hell val should be
            if val == 'no' or val == 'none' or val == 0 or val == '0':
                val = None
            print "Setting \"%s\" to \"%s\"" % (key, val)
            self.opts[key] = val
            line = fp.readline()

        return self
            
program_options = Options()

