# List.py
# Written by David Allen
# s2mdalle@titan.vcu.edu
#
# This is a data structure similar to a doubly linked list, but with a few
# exceptions - it has to keep track of all nodes that have EVER been in the
# list, to cache old nodes for jumping around.  It also has to know that when
# you insert a completely new item, it removes everything after the current
# slot in the list.  This is because when you jump to a new document like in
# a web browser, you can't then hit the 'forward' button.
#
# The forward and back buttons in the program will correspond to methods in
# this object.
#
# Only put ListNode objects into this.

from ListNode import *

ListException = "List error:"

class List:
    def __init__(self):
        self.front   = ListNode()
        self.back    = ListNode()
        self.front.setNext(self.back)
        self.front.setPrev(None)
        self.back.setPrev(self.front)
        self.back.setNext(None)
        self.current = self.front
        return None
    def atEnd(self):
        return self.current == self.back
    def atFront(self):
        return self.current == self.front
    def itemsRemaining(self):
        return not self.atEnd()
    def isEmpty(self):
        if self.front.getNext() == self.back:
            return 1
        else:
            return None
    def traverse(self, function):
        n = self.front.getNext()
        listresults = [] 
        while n != self.back:
            listresults.append(function(n))
            n = n.getNext()
        return listresults
    def countNodes(self, f=None):
        if f is None:
            f = self.front
        nodes = 0
        n = f.getNext()
        while n != self.back:
            nodes = nodes + 1
            n = n.getNext()
        return nodes    
    def insert(self, node, truncate=1):
        #print "LIST: truncating %d items" % int(self.countNodes(self.current))

        if truncate:
            node.setPrev(self.current)
            node.setNext(self.back)
            self.current.setNext(node)
            self.current = node
            return self.current
        else:
            oldnext = self.current.getNext()
            node.setPrev(self.current)
            node.setNext(oldnext)
            self.current.setNext(node)
            oldnext.setPrev(node)
            self.current = node
            return self.current

    def getCurrent(self):
        return self.current
        
    def getNext(self):
        next = self.current.getNext()
        
        if next == self.back or (next == None and next == self.back):
            raise ListException, "Already at the end of the list"
        elif next == None:
            raise ListException, "getNext(): Null next field"
        
        self.current = self.current.getNext()
        return self.current
    def getPrev(self):
        prev = self.current.getPrev()
        
        if prev == self.front or (prev == None and prev == self.front):
            raise ListException, "Already at the beginning of the list"
        elif prev == None:
            raise ListException, "getPrev(): Null prev field."

        self.current = self.current.getPrev()
        return self.current
