# GopherObject.py
# Written by David Allen <s2mdalle@titan.vcu.edu>
# Released under the terms of the GNU General Public License
#
# Base class for GopherResource, GopherResponse

import regsub

from gopher import *
from GopherThingy import *

class GopherObject(GopherThingy):
    def __init__(self,
                 typecode = None,
                 host     = None,
                 port     = None,
                 locator  = None,
                 name     = None,
                 len      = -2):
        GopherThingy.__init__(self)
        self.__class   = "GopherObject"
        self.type    = typecode
        self.host    = host
        self.port    = port
        self.locator = locator
        self.name    = name
        self.len     = len
        return None
    # Accessors, mutators
    def getLen(self):
        return self.len
    def setLen(self, newlen):
        self.len = newlen
        return self.len
    def getTypeCode(self):
        return self.type
    def setType(self, newtype):
        return self.setTypeCode(newtype)
    def setTypeCode(self, newtype):
        self.type = newtype
        return self.type
    def getType(self):
        """Return a string representing the type code of the response.  See
        the gopher module for more information."""
        try:
            return responses[self.type]
        except KeyError:
            return "-Unknown-"
    def getHost(self):
        return self.host
    def setHost(self, newhost):
        self.host = newhost
        return self.host
    def getPort(self):
        return self.port
    def setPort(self, newport):
        self.port = newport
        return self.port
    def getLocator(self):
        return self.locator
    def setLocator(self, newlocator):
        self.locator = newlocator
        return self.locator
    def getName(self):
        if self.name == '' or self.name is None:
            # print "Inserting default name inside of GopherObject"
            self.setName(self.getLocator())
        return self.name
    def setName(self, newname):
        self.name = newname
        return self.name
    # Methods
    def toURL(self):
        """Return the URL form of this GopherResource"""
        return "gopher://%s:%s/%s%s" % (self.getHost(),
                                        self.getPort(),
                                        self.getTypeCode(),
                                        self.getLocator())
    def toProtocolString(self):
        """Returns the protocol string, i.e. how it would have been served
        by the server, in a string."""
        return "%s%s\t%s\t%s\t%s\r\n" % (self.getTypeCode(),
                                         self.getName(),
                                         self.getLocator(),
                                         self.getHost(),
                                         self.getPort())
    def toXML(self):
        """Returns a small XML tree corresponding to this object.  The root
        element is the name of the object.  Override me in subclasses."""
        tags = [["type",    self.type],
                ["locator", self.locator],
                ["host",    self.host],
                ["port",    self.port],
                ["name",    self.name]]

        str = "<GopherObject>"
        for tag in tags:
            str = str + "<%s>%s</%s>" % (tag[0], tag[1], tag[0])
        str = str + "</GopherObject>"

        return str
    def __str__(self):
        return self.__class
        # return self.toString()
    def toString(self):
        """Returns a string form of this object.  Mostly only good for
        debugging."""
        return ("Type: %s\nLocator: %s\nHost: %s\nPort: %s\nName: %s\n" %
                (self.getTypeCode(), self.getLocator(),
                 self.getHost(), self.getPort(), self.getName()))

    def filenameToURL(self, filename):
        """Unencodes filenames returned by toFilename() into URLs"""        
        return regsub.gsub("%20;", " ", regsub.gsub("%47;", "/", filename))

    def toFilename(self):
        """Returns the name of a unique file containing the elements of this
        object.  This file is not guaranteed to not exist, but it probably
        doesn't. :)  Get rid of all of the slashes, since they are
        Frowned Upon (TM) by most filesystems."""

        replaceables = [' ', '\t', '\n', '/']
        data = self.toURL()
        
        for r in replaceables:
            data = regsub.gsub(r, "%" + "%s;" % ord(r), data)

        return data
