# GopherConnection.py
# Written by David Allen <s2mdalle@titan.vcu.edu>
# Released under the terms of the GNU General Public License
#
# This object handles connections and sending requests to gopher servers.
#######################################################################
import socket
import regsub
from string import *
import GopherResponse
import Connection
import GopherThingy
import GopherObject
import GopherResource
import ResourceInformation
from gopher import *

GopherConnectionException = "Error: "

class GopherConnection(Connection.Connection):
    SNARFSIZE                 = 1024
    verbose                   = None
    def __init__(self, server="gopher://gopher.ptloma.edu", port=70):
        Connection.Connection.__init__(self)
        self.server = regsub.sub("gopher://", "", server)
        self.port   = port
        self.forgetResponse()
        return None

    def forgetResponse(self):
        """Remove the response field of this object.  This is periodically
        necessary, since it can get quite large."""
        self.response = None
        return self.response
    def stripTail(self, data):
        ind = rfind(data, "\r\n.\r\n")
        
        if ind != -1:
            if self.verbose:
                print "Stripping protocol footer at index %d" % int(ind)
            return data[0:ind]

        if self.verbose:
            print "No protocol footer found."
        return data

    # Get extended information about a resource.
    def getInfo(self, resource, msgBar=None):
        try:
            data = self.requestToData(resource,
                                      resource.getLocator() + "\t!\r\n",
                                      msgBar)
        except Connection.ConnectionException, errstr:
            print "Raising exception on getInfo: %s" % errstr
            raise GopherConnectionException, errstr
        
        if self.verbose:
            print "Got %d bytes from INFO conn:\n%s" % (len(data),
                                                        data)

        # The server sends back a length of -2 when it doesn't know how long
        # the document is, and when the document may contain the \r\n.\r\n
        # pattern.  So if it might, do not strip it out.  Otherwise do.  This
        # will probably keep out a very subtle bug of having files downloaded
        # be truncated in really weird places.  (Where the \r\n.\r\n would have
        # been)
        if resource.getLen() != -2:
            print "Stripping protocol footer."
            data = self.stripTail(data)
            
        if self.verbose:
            print "Returning new resourceInformation object"
        try:
            info = ResourceInformation.ResourceInformation(data)
        except Exception, estr:
            print "***GopherConnection: ResourceInformation Error: %s" % estr
            raise GopherConnectionException, estr
        
        return info
            
    def getResource(self, resource, msgBar=None):
        self.forgetResponse()
        self.host     = regsub.sub("gopher://", "", resource.getHost())
        self.port     = resource.getPort()
        self.lastType = resource.getType()

        # print "GetResource: %s:%s" % (self.host, self.port)

        try:
            if resource.isGopherPlusResource():
                print "Fetching GOPHER+ resource"
                request = resource.getLocator() + "\t+\r\n"
                self.response = self.requestToData(resource,
                                                   request,
                                                   msgBar, 1)
            else:
                request = resource.getLocator() + "\r\n"
                self.response = self.requestToData(resource,
                                                   request,
                                                   msgBar, None)
        except Connection.ConnectionException, estr:
            error_resp = GopherResponse.GopherResponse()
            h = resource.getHost()
            p = resource.getPort()

            error_resp.setError(estr)
            return error_resp
        
        if msgBar != None:
            msgBar.message('state', "Examining response...")

        print "Setting type to %s" % resource.getType()
        resp = GopherResponse.GopherResponse()
        resp.setType(resource.getTypeCode())

        self.response = self.stripTail(self.response)

        # print "PROTOCOL DUMP:"
        # print self.response[0:1000] # Only the first 100 bytes
        # print "\n"
        
        try:
            # The parser picks up directory entries and sets the internal
            # data of the object as needed.
            resp.parseResponse(self.response)
            # if we get this far, then it's a directory entry, so set the
            # data to nothing.
            resp.setData(None)
        except:
            if self.verbose:
                print "OK, it's data."
            resp.setData(self.response)
                
        return resp

