# GUISearch.py
# Written by David Allen <s2mdalle@titan.vcu.edu>
#
# Released under the terms of the GNU General Public License
#
# This is the graphical component used for getting information from the user
# about search terms.  (And then sending them on their merry way)
##############################################################################

from Tkinter import *
from gopher import *
import Pmw
import ContentFrame
import GopherResource
import GopherResponse
import GopherConnection

class GUISearch(ContentFrame.ContentFrame, Frame):
    verbose = None
    
    def __init__(self, parent_widget, parent_object, resp,
                 resource, filename=None, menuAssocs={}):
        Frame.__init__(self, parent_widget)  # Superclass constructor
        self.resource = resource
        self.response = resp
        self.parent   = parent_object
        self.filename = filename

        labels = ["Please enter a space-separated list of search terms."]

        last = 0
        
        for x in range(0, len(labels)):
            last = x
            label = labels[x]
            Label(self, text=label, foreground='#000000').grid(row=x, col=0,
                                                               columnspan=2)

        self.entryBox = Entry(self, text='')
        self.entryBox.grid(row=(x+1), col=0, columnspan=2, sticky=W)
        self.GO = Button(self, text='Submit', command=self.submit)
        self.GO.grid(row=(x+1), col=2, sticky=W)
        self.bottom_label = None
        return None
    
    def submit(self, *args):
        terms = self.entryBox.get()

        print "Terms are \"%s\"" % terms

        if self.bottom_label:
            self.bottom_label.destroy()
            self.bottom_label = Label(self, "Searching for \"%s\"" % terms)
            self.bottom_label.grid(row=10, col=0, columnspan=2,
                                   sticky=W)

        # Copy the data from the current resource.
        res = GopherResource.GopherResource()
        res.setHost(self.resource.getHost())
        res.setPort(self.resource.getPort())
        res.setName(self.resource.getName())

        # This is a nasty way of faking the appropriate protocol message,
        # but oh well...
        res.setLocator("%s\t%s" % (self.resource.getLocator(),
                                   terms))
        res.setInfo(None)
        res.setLen(-2)
        res.setTypeCode(RESPONSE_DIR)   # Response *will* be a directory.

        self.parent.goElsewhere(res)
        return None
    

