# GUISaveFile.py
# Written by David Allen <s2mdalle@titan.vcu.edu>
#
# This class asks users graphically which filename they'd like to save certain
# files into.  This is generally used for downloaded files that don't have
# associations bound to them, and that also can't be displayed, because
# they're binary data or otherwise ugly to look at as text.  :)  (e.g.
# *.zip, *.tar.gz, *.tgz, binhex, etc.
##############################################################################

from Tkinter import *
from gopher import *
from string import *
import Pmw
import regsub
import Options

import ContentFrame
import GopherResource
import GopherResponse

class GUISaveFile(ContentFrame.ContentFrame, Frame):
    verbose = None
    
    def __init__(self, parent_widget, parent_object, resp,
                 resource, filename):
        Frame.__init__(self, parent_widget)  # Superclass constructor
        self.r1 = None
        self.r2 = None
        
        self.parent   = parent_object
        self.response = resp
        self.resource = resource
        
        labeltext = "%s:%d" % (resource.getHost(), int(resource.getPort()))
        
        if resource.getName() != '' and resource.getLocator() != '':
            label2 = "\"%s\" ID %s" % (resource.getName(),
                                       resource.getLocator())
        else:
            label2 = "    "

        if len(label2) > 50:
            label2 = label2[0:47] + "..."

        Label(self, text=labeltext).pack(expand=0, fill='x')
        Label(self, text=label2).pack(expand=0, fill='x')

        Label(self, text=" ").pack()  # Empty line.

        Label(self,
              text="Please enter a filename to save this file as:").pack()
        cframe = Frame(self)
        cframe.pack()
        Label(cframe, text="Filename:").grid(row=0, col=0, sticky=W)

        self.filenameEntry = Entry(cframe)
        self.filenameEntry.grid(row=0, col=1, columnspan=3, sticky=W)
        self.saveButton = Button(cframe, text="Save", command=self.save)
        self.saveButton.grid(row=0, col=4, sticky=W)
        return None
    def save(self, *args):
        filename = self.filenameEntry.get()

        try:
            fp = open(filename, "w")
            fp.write(self.response.getData())
            fp.flush()
            fp.close()
        except IOError, errstr:
            self.parent.genericError("Couldn't save file\n%s:\n%s" % (filename,
                                                                      errstr))
            return None

        if self.r1:
            self.r1.destroy()
        if self.r2:
            self.r2.destroy()
            
        self.r1 = Label(self, text="File successfully saved into").pack()
        self.r2 = Label(self, text=filename).pack()
        return None
