# GUIFile.py
# Written by David Allen <s2mdalle@titan.vcu.edu>
#
# This is the class that describes how files behave when loaded into
# the FORG.
##############################################################################

from Tkinter import *
from gopher import *
from string import *
import Pmw
import regsub
import Options

import ContentFrame
import GopherResource
import GopherResponse

class GUIFile(ContentFrame.ContentFrame, Frame):
    verbose = None
    
    def __init__(self, parent_widget, parent_object, resp,
                 resource, filename):
        Frame.__init__(self, parent_widget)  # Superclass constructor
        # print "DATA IS"
        # print resp.getData()
        labeltext = "%s:%d" % (resource.getHost(), int(resource.getPort()))

        if resource.getName() != '' and resource.getLocator() != '':
            label2 = "\"%s\" ID %s" % (resource.getName(),
                                       resource.getLocator())
        else:
            label2 = "    "

        if len(label2) > 50:
            label2 = label2[0:47] + "..."

        Label(self, text=labeltext).pack(expand=0, fill='x')
        Label(self, text=label2).pack(expand=0, fill='x')

        if resp.getTypeCode() != RESPONSE_FILE:
            Label(self, text="This file has been saved in:").pack()
            Label(self, text=filename).pack()
        else:
            self.textwid = Pmw.ScrolledText(self, hscrollmode='dynamic',
                                            vscrollmode='static')
            tw = self.textwid.component('text')
            tw.configure(background='#FFFFFF', foreground='#000000',
                         width=100)
            
            if Options.program_options.getOption('strip_carraige_returns'):
                self.textwid.settext(regsub.gsub("\r", "", resp.getData()))
            else:
                self.textwid.settext(resp.getData())
                
            self.textwid.component('text').bind('<Button-3>',
                                                parent_object.popupMenu)
            
            self.textwid.pack(expand=1, fill='both')
            print "Done packing."

        return None
    
    def find(self, term, caseSensitive=None, lastIdentifier=None):
        """Overrides the function of the same type from ContentFrame"""
        try:
            # This will raise an exception if it's a 'save' type layout
            # where the data isn't displayed to the user.
            tw = self.textwid.component('text')
            print "Component is ", tw
        except:
            # Don't mess with this.  The user can read the entire label, all
            # big bad few lines of it.
            raise Exception, "This window is not searchable."

        if lastIdentifier is None:
            lastIdentifier = '0.0'

        csflipped = (not caseSensitive)
        thingy = tw.index(tw.search(pattern=term, index=lastIdentifier,
                                    stopindex=END, forwards=1,
                                    nocase=csflipped))
        
        if thingy:
            tw.yview(thingy)
            [x, y] = split(thingy, ".")
            tw.mark_set('FOUND', thingy)
            tw.tag_config('FOUND', background="#0000FF")
            newindex = "%s + %d chars" % (thingy, len(term))
            # tw.set_selection(thingy, newindex)
            return thingy

        return None
