# FindDialog.py
# Written by David Allen <s2mdalle@titan.vcu.edu>
# Released under the terms of the GNU General Public License
#
# This class defines the dialog users use to find items in pages of the
# program.
#############################################################################

from Tkinter import *
from gopher import *
import Pmw

class FindDialog(Pmw.Dialog):
    def __init__(self, parent, searchwidget, parentobj=None, *args):
        self.parent = parent
        self.parentobj = parentobj
        self.searchwidget = searchwidget
        self.dialog = Pmw.Dialog(parent, title='Find Text...',
                                 buttons=('OK', 'Cancel'), defaultbutton='OK',
                                 command=self.dispatch)
        self.frame = Frame(self.dialog.interior())
        self.frame.pack(expand=1, fill='both')

        Label(self.frame, text="Find a term...").grid(row=0, col=0,
                                                      columnspan=5)
        Label(self.frame, text="Term: ").grid(row=1, col=0)

        self.searchEntry = Entry(self.frame, text="")
        self.searchEntry.grid(row=1, col=1, columnspan=4)

        self.css = IntVar()
        
        self.caseSensitiveCheckBox = Checkbutton(self.frame,
                                                 text="Case-sensitive search",
                                                 variable=self.css,
                                                 command=self.cb)
        self.caseSensitiveCheckBox.grid(row=2, col=0, columnspan=4)
        
        self.lastMatch = None
        self.dialog.activate()
        return None
    
    def cb(self, *args):
        print "Var is ", self.css.get()
    def getSearchTerm(self):
        return self.searchEntry.get()
    def getCaseSensitive(self):
        return self.css.get()
    def dispatch(self, button):
        if button != 'OK':
            # Smack...
            self.dialog.destroy()
            return None

        # Otherwise, go look for a term...
        # try:
        self.lastMatch = self.searchwidget.find(self.getSearchTerm(),
                                                self.getCaseSensitive(),
                                                self.lastMatch)

        #  except Exception, errstr:
#              print "***********"
#              print "******ERROR searching:  %s"  % errstr
#              print "***********"

#              if self.parentobj:
#                  self.parentobj.genericError(errstr)
            
        print "Last match is now ", self.lastMatch
        return self.lastMatch
            

