# ErrorDialog.py
# Written by David Allen <s2mdalle@titan.vcu.edu>
# Released under the terms of the GNU General Public License
#
# Generic error reporting dialog.  Nothing shocking.
###########################################################################

from Tkinter import *
from types import *
import Pmw
import string

class ErrorDialog:
    def __init__(self, parent, errstr, title=''):
        # We don't need an activate command since we want the dialog to just
        # get smacked when the user presses close.
        if title == '':
            title = errstr
        self.dialog = Pmw.Dialog(parent, title=title, buttons=["Close"])

        if type(errstr) != StringType:
            errstr = errstr.__str__

        labels = string.split(errstr, "\n")
        
        for label in labels:
            Label(self.dialog.interior(), text=label).pack(side='top')

        # self.dialog.activate() # Modalize  :)
        return None
        

