# Connection.py
# Written by David Allen <s2mdalle@titan.vcu.edu>
#
# Base class for socket connections.
#############################################################################
import socket
from string import *

ConnectionException = "foo"

class Connection:
    def __init__(self, *args):
        self._d = None
        return None

    def readloop(self, sock, bytesToRead, msgBar=None):
        timesRead = 0
        data      = ''
        CHUNKSIZE = 1024  # Default read block size.

        if bytesToRead < 0:
            numKBtoRead = ""   # Don't report total size since we don't know
        else:
            # Report the total size so the user has an idea of how long it's
            # going to take.
            val = float(bytesToRead) / float(1024)
            numKBtoRead = "of %0.2f kilobytes total size" % val

            if bytesToRead > (1024 * 100): # 100 Kb
                CHUNKSIZE = bytesToRead / 100

        chunk = 'foobar'
        while len(chunk) > 0:
            chunk = sock.recv(CHUNKSIZE)
            timesRead = timesRead + 1
            print "Read %s: %s" % (CHUNKSIZE, timesRead * CHUNKSIZE)
            data = data + chunk

            if bytesToRead > 0 and len(data) >= bytesToRead:
                print "BTR=%s, len(data)=%s, breaking" % (bytesToRead,
                                                          len(data))
                break
            
            if msgBar:
                # Report statistics on how far along we are...
                bytesRead = timesRead * CHUNKSIZE
                kbRead = (float(timesRead) * float(CHUNKSIZE)) / float(1024)

                if bytesToRead > 0:
                    pct = (float(bytesRead) / float(bytesToRead))*float(100)
                    pctDone = ("%0.2f" % pct) + "%"
                else:
                    pctDone = ""

                msgBar.message('state',
                               "Read %d bytes (%0.2f Kb) %s %s" %
                               (bytesRead,
                                kbRead,
                                numKBtoRead,
                                pctDone))

        if bytesToRead > 0:
            return data[0:bytesToRead]
        else:
            return data

    def requestToData(self, resource, request, msgBar=None, grokLine=None):
        """Sends request to the host/port stored in resource, and returns
        any data returned by the server.  This may throw
        ConnectionException.  msgBar is optional."""
        self.socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        if not self.socket:
            raise GopherConnectionException, "Cannot create socket."
        
        try:
            self.socket.connect([resource.getHost(),
                                 int(resource.getPort())])
        except socket.error, err:
            newestr = "Cannot connect to\n%s:%s:\n%s" % (resource.getHost(),
                                                         resource.getPort(),
                                                         err)
            raise ConnectionException, newestr
        
        data = ""
        self.socket.send(request)

        if grokLine:   # Read the first line...
            line = ""
            byte = ""
            
            while byte != "\n":
                byte = self.socket.recv(1)
                if len(byte) <= 0:
                    print "****************BROKE out of byte loop"
                    break
                line = line + byte
    
            bytesread = len(line)
            
            line = strip(line)

            if line[0] == '+':
                bytecount = int(line[1:])    # Skip first char: "+-1" => "-1"
            else:
                bytecount = int(line)

            print "******Server wants us to read %d bytes" % bytecount
            resource.setLen(bytecount)
            data = self.readloop(self.socket, bytecount, msgBar)
        else:
            data = self.readloop(self.socket, -1, msgBar)
            
        if msgBar != None:
            msgBar.message('state', "Closing socket")
        self.socket.close()
        return data

