# Bookmark.py
# Written by David Allen <s2mdalle@titan.vcu.edu>
# This is a subclass of GopherResource and is used in the Bookmark
# management system of the FORG.

import GopherResource
from string import *
import List

class Bookmark(GopherResource.GopherResource):
    def __init__(self, res=None):
        GopherResource.GopherResource.__init__(self)

        if res != None:
            # Copy data from the resource to this bookmark.
            self.setName(res.getName())
            self.setHost(res.getHost())
            self.setPort(res.getPort())
            self.setLocator(res.getLocator())
            self.setType(res.getTypeCode())

        return None    
    def toData(self):
        return "%s !! gopher://%s:%s/%s" % (self.getName(),
                                            self.getHost(),
                                            self.getPort(),
                                            self.getLocator())
    def toString(self):
        if self.getName() != '':
            return "%s: %s" % (self.getHost(), self.getName())
        elif self.getLocator() == '/' or self.getLocator() == '':
            return "%s Root" % self.getHost()
        else:
            return "%s:%s %s" % (self.getHost(), self.getPort(),
                                 self.getLocator())

# Not specific to the bookmark class methods...
def parseBookmark(data):
    data = strip(data)
    items = split(data, "!! ", 2)
    
    if len(items) < 2:
        print "***Bookmark parse error: Items is: %s" % join(items,"::")
        return None
    
    bmark = Bookmark()
    try:
        items[1] = strip(items[1])
        bmark.setURL(items[1])
    except Exception, estr:
        print "Returning NONE because I couldn't parse the URL: %s" % estr
        return None
    
    bmark.setName(items[0])
    return bmark

class BookmarkSubmenu(List.List):
    def __init__(self, menuName=' '):
        self.menuName = menuName
        return None
    def getMenuName(self):
        return self.menuName
    def setMenuName(self, newname):
        self.menuName = newname
        return self.menuName
