# Associations.py
#
# Handles associations between file types and programs.
########################################################################
import regsub
import os
from string import *

class Associations:
    AssociationsException = "foo"
    verbose = None
    def __init__(self):
        self.dict    = {}
        self.threads = 0
        return None
    def addAssociation(self, suffix, pgm):
        if suffix[0] == '.':
            suffix = suffix[1:]
        self.dict[suffix] = pgm
        return None
    
    def getFileTypes(self):
        return self.dict.keys()
    
    def getProgramString(self, key):
        try:
            ans = self.dict[key]
            return ans
        except KeyError:
            return None    
    def getTmpFilename(self, suffix, *args):
        return foo + "." + suffix
        return None
    def removeAssociation(self, suffix):
        try:
            del(self.dict[suffix])
        except KeyError:
            pass
    def getAssociation(self, filename):
        # Turn it into a real filename so some programs won't go stupid
        # on us and try to look up a partial URL in a filename, particularly
        # with cache filenames.
        print "Finding assoc for %s" % filename
        filename = "." + os.sep + filename
        matchFound = None
        ind = len(filename)-1;
        while not matchFound and ind != -1:
            str   = filename[ind+1:]
            assoc = None
            try:
                assoc = self.dict[str]
            except:
                pass
            if self.verbose:
                print "rfinding on %s betw %d + %d" % (filename, 0, int(ind))
            ind = rfind(filename, ".", 0, ind)
            if assoc:
                matchFound = 1

        if ind == -1 or not matchFound:
            print "Couldn't find association for this filetype."
            return None

        print "Found assoc %s for filename %s" % (assoc, filename)
        return assoc
    def applyAssociation(self, filename, assoc=None):
        if assoc == None:
            assoc = self.getAssociation(filename)

        if assoc == None or assoc == '':
            raise AssociationsException, "No association found."
        
        print "Got assoc %s on filename %s" % (assoc, filename)
        # Assoc holds the program name
        assoc = regsub.sub("$1", "\"" + filename + "\"", assoc)
        
        pid = os.fork()
        if pid > 0:
            return 1
        elif pid == 0:
            fp = os.popen(assoc)
            print "Process dump: %s" % assoc
            try:
                while 1:
                    line = fp.readline()
                    if line == '':
                        break;
                    print line
            except:
                print "Process %s exited with an exception." % assoc
                exit
            print "Process \"%s\" finished up and exited." % assoc

    
