// Uses:
//   chrome://global/content/dialogOverlay.js
//   chrome://protozilla/content/protoCommon.js

var gDialog;

function OnLoadProtoEdit() {
   DEBUG_LOG("OnLoadProtoEdit:\n");

   var pzilla = window.opener.pzilla;
   if (pzilla) {
    pzilla = pzilla.QueryInterface(Components.interfaces.nsIProtozilla);
   }

   DEBUG_LOG("OnLoadProtoEdit: pzilla="+pzilla+"\n");
   if (!pzilla) {
      WRITE_LOG("Protozilla object not found!!!\n");
      window.close();
      return false;
   }

   window.pzilla = pzilla;

   doSetOKCancel(onOK, onCancel);

   gDialog = new Object();
  
   gDialog.protoName = window.arguments[0];

   gDialog.clientName = document.getElementById("clientName");
   gDialog.clientExtn = document.getElementById("clientExtn");
   gDialog.clientContent = document.getElementById("clientContentText");

   gDialog.protoDir = window.pzilla.packageDir.clone();
   gDialog.protoDir.append("protocol");

   if (gDialog.protoName) {
       var handlerObj = window.pzilla.getHandlerByName(gDialog.protoName,
                                                       "protocol");

       var clientFile = gDialog.protoDir.clone();
       if (handlerObj.schemeDirName) {
           clientFile.append(handlerObj.schemeDirName);
           ProtoAlert("Please use an editor to edit files in the handler directory "+clientFile.path+"\n");
           window.close();
           return false;
       }

       clientFile.append(handlerObj.clientLeafName);

       if (!clientFile.exists()) {
           ProtoAlert("File "+clientFile.path+" not found\n");
           window.close();
           return false;
       }

       gDialog.clientName.value = window.pzilla.getFileName(clientFile);
       gDialog.clientExtn.value = window.pzilla.getFileExtn(clientFile);

       if (clientFile.fileSize > 20000) {
           ProtoAlert("File "+clientFile.path+" too large; please edit using editor\n");
           window.close();
           return false;
       }

       try {
           gDialog.clientContent.value = window.pzilla.readFileContents(clientFile, -1);
       } catch (ex) {
           ProtoError("Error in reading file "+clientFile.path);
       }
   }

   return true;

}

function OnUnloadProtoEdit() {
  //WRITE_LOG("OnUnloadProtoEdit:\n");
}

function ValidateAndSaveData() {

   var fileName = gDialog.clientName.value;

   if (fileName.length == 0) {
      ProtoError("Please specify file name");
      return false;  // do not close dialog
   }

   var fileExtn = gDialog.clientExtn.value;
   var clientLeafName = fileName;
   if (fileExtn)
       clientLeafName += "." + fileExtn;

   var content = gDialog.clientContent.value;

   if (content.length == 0) {
      ProtoError("Zero length content");
      return false;  // do not close dialog
   }

   var clientFile = gDialog.protoDir.clone();
   clientFile.append(clientLeafName);

   var handlerFile = null;
   if (!clientFile.exists() || clientFile.isDirectory()) {
       var handlerObj = window.pzilla.getHandlerByName(fileName, "protocol");
       if (handlerObj) {
           handlerFile = gDialog.protoDir.clone();

           if (handlerObj.schemeDirName) {
               handlerFile.append(handlerObj.schemeDirName);
           } else {
               handlerFile.append(handlerObj.clientLeafName);
           }
       }
   }

   if (clientFile.exists() || handlerFile) {
       var confirm = ProtoConfirm("Protocol handler "+clientLeafName+
                     " already exists; do you wish to overwrite it?");

       if (!confirm)
           return false;  // do not close dialog

       // Delete handler
       if (handlerFile)
           handlerFile["delete"](true);
   }

   var perms = (fileExtn.toLowerCase() == "url") ? 0600 : 0700;

   try {
       window.pzilla.writeFileContents(clientFile, content, perms);
   } catch (ex) {
       ProtoError("Error in writing file "+clientFile.path);
       return false;  // do not close dialog
   }

   window.opener.selectProtoName = fileName;

   return true;  // close dialog
}

function onOK() {
  if (!ValidateAndSaveData())
    return false; // don't close window

  SaveWindowLocation();

  return true; // close window
}

function onCancel() {
   SaveWindowLocation();
   window.close();
}

// A XUL element with id="location" for managing 
// dialog location relative to parent window
var gLocation;

function SetWindowLocation() {
  gLocation = document.getElementById("location");
  if (gLocation)  {
    window.screenX = Math.max(0, Math.min(window.opener.screenX +
                                  Number(gLocation.getAttribute("offsetX")), 
                                  screen.availWidth - window.outerWidth));
    window.screenY = Math.max(0, Math.min(window.opener.screenY +
                                  Number(gLocation.getAttribute("offsetY")), 
                                  screen.availHeight - window.outerHeight));
  }
}

function SaveWindowLocation()
{
  if (gLocation) {
    var newOffsetX = window.screenX - window.opener.screenX;
    var newOffsetY = window.screenY - window.opener.screenY;
    gLocation.setAttribute("offsetX", window.screenX - window.opener.screenX);
    gLocation.setAttribute("offsetY", window.screenY - window.opener.screenY);
  }
}
