// Uses: chrome://protozilla/content/protoCommon.js

var protoDir = window.pzilla.packageDir.clone();
protoDir.append("protocol");

window.selectProtoName = null;

var gActionBox;

function UninstallPackage() {
  var delFiles = [];

  var confirm;

  confirm = ProtoConfirm("Do you wish to delete all Protozilla-related files in the Mozilla component and chrome directories?");

  if (confirm) {
    var overlayRemoved =
        RemoveOverlay("chrome://protozilla/content/protozillaOverlay.xul");

    if (!overlayRemoved) {
      ProtoAlert("Failed to uninstall Protozilla overlay RDF; not deleting chrome jar file");

    } else {
      var chromeFile = window.pzilla.getFileOfProperty("AChrom");
      chromeFile.append("protozilla.jar");

      delFiles.push(chromeFile);
    }

    var compDir = window.pzilla.getFileOfProperty("ComsD");
    var compFiles = ["protozilla.js", "protozilla.xpt", "ipc.xpt"];
    if (window.pzilla.platform.search(/^win/i)==0) {
      compFiles.push("ipc.dll");
    } else {
      compFiles.push("libipc.so");
    }

    for (var k=0; k<compFiles.length; k++) {
      var compFile = compDir.clone();
      compFile.append(compFiles[k]);
      delFiles.push(compFile);
    }
  }

  confirm = ProtoConfirm("Do you wish to delete all Protozilla-related protocol handlers and CGI scripts in your user profile?");
  if (confirm) {
    var packageDir = window.pzilla.packageDir.clone();
    delFiles.push(packageDir);
  }

  // Unregister handlers
  window.pzilla.uninstall();

  // Need to unregister chrome: how???

  // Delete files
  for (var j=0; j<delFiles.length; j++) {
    var delFile = delFiles[j];
    if (delFile.exists()) {
      WRITE_LOG("protoConfig.js: UninstallPackage: Deleting "+delFile.path+"\n")
      try {
          delFile.remove(true);
      } catch (ex) {
          ProtoError("Error in deleting file "+delFile.path)
      }
    }
  }

  // Close window
  window.close();
}

function NewProtocolItem(protoName, handlerFile) {
  DEBUG_LOG("protoConfig.js: NewProtocolItem: "+protoName+"\n");
  var fileName;
  var handlerType;
  var handlerComment = "";

  if (!handlerFile) {
    fileName = "[predefined]";
    handlerType = "PREDEFINED";

    switch (protoName) {
      case "protozilla":
        handlerComment = "Loads Protozilla console";
      break;
      case "cgi+":
        handlerComment = "Executes CGI scripts (e.g. cgi+:/testcgi.pl)";
      break;
    }
    
  } else {
    fileName = handlerFile.leafName;
    if (handlerFile.isDirectory()) {
      handlerType = "DIRECTORY";
      handlerComment = "Directory";

    } else {
      handlerType = "FILE";
      handlerComment = GetFirstLine(handlerFile);
    }
  }

  var protoCell = document.createElement("treecell");
  protoCell.setAttribute("label", protoName);
  protoCell.setAttribute("type",  handlerType);

  var handlerCell = document.createElement("treecell");
  handlerCell.setAttribute("label", fileName);
  handlerCell.setAttribute("class", "treecell-filename treecell-indent");
  handlerCell.setAttribute("indent","true");
  handlerCell.setAttribute("type",  handlerType);

  var commentCell = document.createElement("treecell");
  commentCell.setAttribute("label", handlerComment);

  var newTreeRow = document.createElement("treerow");

  newTreeRow.appendChild(protoCell);
  newTreeRow.appendChild(handlerCell);
  newTreeRow.appendChild(commentCell);

  var newTreeItem = document.createElement("treeitem");
  newTreeItem.appendChild(newTreeRow);

  if (handlerFile) {
    newTreeItem.setAttribute("class",   "draggable-file");
    newTreeItem.setAttribute("dragURL", "file:"+handlerFile.path);
  }

  return newTreeItem;
}

function RefreshProtocols() {
  var j;

  DEBUG_LOG("protoConfig.js: RefreshProtocols: \n");

  pzilla.refresh();

  var protoDirElement = document.getElementById("protoDir");
  protoDirElement.setAttribute("value", "Directory: "+protoDir.path);

  var newTreeChildren = document.createElement("treechildren");
  newTreeChildren.setAttribute("id", "protoTreeChildren");
  newTreeChildren.setAttribute("flex", "1");

  var selectItem = null;
  var newTreeItem;

  var predefProto = ["protozilla", "cgi+"];
  for (j=0; j<predefProto.length; j++) {
    newTreeItem = NewProtocolItem(predefProto[j], null);

    newTreeChildren.appendChild(newTreeItem);

    if (window.selectProtoName &&
        (predefProto[j] == window.selectProtoName))
      selectItem = newTreeItem;
  }

  var protoNames = window.pzilla.getHandlerNamesByType("protocol");

  protoNames = protoNames ? protoNames.split(",") : [];

  for (j=0; j<protoNames.length; j++) {
    var handlerObj = window.pzilla.getHandlerByName(protoNames[j], "protocol");
    var handlerFile = protoDir.clone();

    if (handlerObj.schemeDirName) {
      handlerFile.append(handlerObj.schemeDirName);
    } else {
      handlerFile.append(handlerObj.clientLeafName);
    }

    newTreeItem = NewProtocolItem(protoNames[j], handlerFile);

    newTreeChildren.appendChild(newTreeItem);

    if (window.selectProtoName &&
        (protoNames[j] == window.selectProtoName))
      selectItem = newTreeItem;
  }

  var protoTree = document.getElementById("protoTree");

  var oldTreeChildren = document.getElementById("protoTreeChildren");

  if (oldTreeChildren) {
    protoTree.removeChild(oldTreeChildren);
    oldTreeChildren = null;
  }

  protoTree.appendChild(newTreeChildren);

  if (selectItem) {
    protoTree.selectItem(selectItem);
    //protoTree.ensureElementIsVisible(selectItem); // Doesn't work (bug)!
  }

  window.selectProtoName = null;

  DEBUG_LOG("protoConfig.js: RefreshProtocols: END\n");
}

function LoadProtocol() {
  var treeCell = GetSelectedTreeCell("protoTree");
  if (!treeCell)
    return;

  var protoName = treeCell.getAttribute("label");

  DEBUG_LOG("protoConfig.js: LoadProtocol: proto="+protoName+"\n");

  var chromeFlag = true;

  if (treeCell.getAttribute("type") != "PREDEFINED") {
    var handlerObj = window.pzilla.getHandlerByName(protoName, "protocol");
    chromeFlag = (handlerObj.indexLeafName.search(/.xul$/) != -1);
  }

  if (chromeFlag) {
    window.openDialog(protoName+":", 'Protocol '+protoName, 'chrome');
  } else {
    window.open(protoName+":");
  }
}

function CreateProtocol() {
  window.openDialog('chrome://protozilla/content/protoEdit.xul',
                    'Protozilla Create Window',
                    'chrome,modal,dialog,close=no', '');
  RefreshProtocols();
}

function EditProtocol() {
  var treeCell = GetSelectedTreeCell("protoTree");
  if (!treeCell)
    return;

  var protoName = treeCell.getAttribute("label");
    
  if (treeCell.getAttribute("type") == "PREDEFINED") {
    ProtoAlert("Cannot edit predefined protocol "+protoName);
    return;
  }

  var handlerObj = window.pzilla.getHandlerByName(protoName, "protocol");

  var handlerFile = protoDir.clone();
  if (handlerObj.schemeDirName) {
    // Directory
    handlerFile.append(handlerObj.schemeDirName);
    window.open('file:'+handlerFile.path);

  } else {
    window.openDialog('chrome://protozilla/content/protoEdit.xul',
                      'Protozilla Edit Window',
                      'chrome,modal,dialog,close=no', protoName);
  }

  RefreshProtocols();
}

function CopyProtocol() {
  var file = ProtoFilePicker("Protozilla: Copy protocol handler",
                             gActionBox.getAttribute("copyPath"),
                             false, null);
  if (!file) return;

  CopyHandler("file:"+file.path);

  gActionBox.setAttribute("copyPath", file.parent.path);
}

function DeleteProtocol() {
  var treeCell = GetSelectedTreeCell("protoTree");
  if (!treeCell)
    return;

  var protoName = treeCell.getAttribute("label");
    
  if (treeCell.getAttribute("type") == "PREDEFINED") {
    ProtoAlert("Cannot delete predefined protocol "+protoName);
    return;
  }

  var handlerObj = window.pzilla.getHandlerByName(protoName, "protocol");

  var mesg;
  if (handlerObj.override) {
    mesg = "You are about to delete the user protocol handler "+protoName+
           " which overrides a system protocol. "+
           "This will cause the application to exit for re-registering "+
           "all components. Do you wish to proceed?";
  } else {
    mesg = "Do you wish to delete the protocol handler "+protoName+"?";
  }

  var confirm = ProtoConfirm(mesg);

  if (confirm) {
    // Delete handler file/directory
    var handlerFile = protoDir.clone();

    if (handlerObj.schemeDirName) {
      handlerFile.append(handlerObj.schemeDirName);
    } else {
      handlerFile.append(handlerObj.clientLeafName);
    }

    DEBUG_LOG("protoConfig.js: DeleteProtocol: handlerFile = "+handlerFile.path+"\n");
    handlerFile.remove(true);

    if (!handlerObj.override) {
      RefreshProtocols();

    } else {
      // Delete component registry and quit application
      //compRegFile = window.pzilla.getFileOfProperty("ComRegF");
      //compRegFile.remove(false);

      goQuitApplication();  // in globalOverlay.js
    }
  }
}

function ExportProtocol() {
  var treeCell = GetSelectedTreeCell("protoTree");
  if (!treeCell)
    return;

  var protoName = treeCell.getAttribute("label");
    
  if (treeCell.getAttribute("type") == "PREDEFINED") {
    ProtoAlert("Cannot export predefined protocol "+protoName);
    return;
  }

  DEBUG_LOG("protoConfig.js: ExportProtocol: exportPath="+gActionBox.getAttribute("exportPath")+"\n");

  var xpiFile = ProtoFilePicker("Protozilla: Export protocol handler",
                                gActionBox.getAttribute("exportPath"),
                                true, ["XP Install", "*.xpi"]);
  if (!xpiFile)
    return;

  gActionBox.setAttribute("exportPath", xpiFile.parent.path);

  var handlerObj = window.pzilla.getHandlerByName(protoName, "protocol");

  // Export handler file/directory
  var handlerFile = protoDir.clone();

  if (handlerObj.schemeDirName) {
    handlerFile.append(handlerObj.schemeDirName);
  } else {
    handlerFile.append(handlerObj.clientLeafName);
  }

  var installTemplate = "\
var err = initInstall('/protozilla/protocol/%package% v0.1',  // name for install UI\n\
                      '/protozilla/protocol/%package%',       // registered name\n\
                      '0.1.0.0');                             // package version\n\
\n\
logComment('initInstall: ' + err);\n\
\n\
var fProfile = getFolder('Profile');\n\
\n\
// addDirectory: blank, archive_dir, install_dir, install_subdir\n\
err = addDirectory('', 'protozilla', fProfile,    'protozilla');\n\
\n\
if (err == SUCCESS)\n\
    performInstall();\n\
else {\n\
   alert('Error detected: '+err);\n\
   cancelInstall();\n\
}\n";

  var installScript = installTemplate.replace(/%package%/g, protoName);

  var installFile = window.pzilla.packageDir.clone();
  installFile.append("install.js");

  window.pzilla.writeFileContents(installFile, installScript, 0700);

  var scriptFile = window.pzilla.packageDir.clone();
  scriptFile.append("xpi.bat");
  var lineDelim = (window.pzilla.platform.search(/^win/i)==0) ? "\r\n" : "\n";

  var handlerPath = handlerFile.path;
  var protoOffset = handlerPath.search(/protozilla/);

  var handlerRelativePath = handlerPath.substr(protoOffset);

  var zipScript = "cd "+window.pzilla.packageDir.path+lineDelim+
                  "zip "+xpiFile.path+" install.js\n"+
                  "cd .."+lineDelim+
                  "zip -g -r "+xpiFile.path+" "+handlerRelativePath+lineDelim;

  window.pzilla.writeFileContents(scriptFile, zipScript, 0700);

  CONSOLE_LOG("Protozilla: Executing "+scriptFile.path+"\n");

  try {
    var zipOutput = window.pzilla.execSh(scriptFile.path);

    CONSOLE_LOG(zipOutput);

    ProtoAlert("Created Mozilla cross-platform install (XPI) file for"+
               " protocol "+protoName+": \n"+
               xpiFile.path);
  } catch (ex) {
  }
}


function RefreshConsole() {
  if (window.pzilla.console.hasNewData) {
    DEBUG_LOG("protoConfig.js: RefreshConsole()\n");

    window.pzilla.console.hasNewData = true;
    var console = document.getElementById('consoleText');

    if (!console.firstChild)
      console.appendChild(document.createTextNode(""));

    console.setAttribute("value", window.pzilla.console.data);
  }
  return false;
}

function OnLoadProtoConfig() {

  gActionBox = document.getElementById("actionBox");

  RefreshProtocols();

  DEBUG_LOG("protoConfig.js: OnLoadProtoConfig\n");

  //RefreshConsole();

  // Refresh console every 2 seconds (DISABLED: time hog!)
  // window.consoleIntervalId = window.setInterval(RefreshConsole, 2000);
}

function OnUnloadProtoConfig() {
  // Cancel console refresh
  //window.clearInterval(window.consoleIntervalId);
}

function CopyHandler(urlSpec) {
  if (!urlSpec) {
    ProtoError("Invalid URL");
    return;
  }

  var retStr = window.pzilla.copyHandlerFromURL(urlSpec,"protocol");

  if (retStr.search(/^Error - /) != -1) {
    ProtoError(retStr);
  } else {
    window.selectProtoName = retStr;
    RefreshProtocols();
  }
}

// Using URLDropObserver from protoCommon.js

var urlBoxObserver = new URLDropObserver(CopyURL);

var protoTreeObserver = new URLDropObserver(CopyHandler);

