// Uses: chrome://protozilla/content/protoCommon.js

var cgiDir = window.pzilla.packageDir.clone();
cgiDir.append("cgi+");

window.selectFileName = null;

var gActionBox;

function RefreshCGIList() {

  var cgiDirElement = document.getElementById("cgiDir");
  cgiDirElement.setAttribute("value", "Directory: "+cgiDir.path);

  if (!cgiDir.exists()) {
    ProtoAlert("CGI directory "+cgiDir.path+" not found\n");
    return;
  }
    
  var newTreeChildren = document.createElement("treechildren");
  newTreeChildren.setAttribute("id", "cgiTreeChildren");
  newTreeChildren.setAttribute("flex", "1");

  var selectItem = null;
  var fileList = cgiDir.directoryEntries;
  while (fileList && fileList.hasMoreElements()) {

    var fileObj = fileList.getNext().QueryInterface(nsILocalFile);

    var fileName = fileObj.leafName;

    // Ignore filenames starting with "." or ending with tilde (~)
    if (fileName.search(/^\.|~$/) != -1)
      continue;

    var fileType = "FILE";

    var fileCell = document.createElement("treecell");
    fileCell.setAttribute("label", fileName);
    fileCell.setAttribute("class", "treecell-filename treecell-indent");
    fileCell.setAttribute("indent","true");
    fileCell.setAttribute("type",  fileType);

    var fileComment = GetFirstLine(fileObj);

    var commentCell = document.createElement("treecell");
    commentCell.setAttribute("label", fileComment);

    var newTreeRow = document.createElement("treerow");
    newTreeRow.appendChild(fileCell);

    var newTreeItem = document.createElement("treeitem");
    newTreeItem.appendChild(newTreeRow);

    newTreeItem.setAttribute("class", "draggable-file");
    newTreeItem.setAttribute("dragURL", "file:"+fileObj.path);

    newTreeChildren.appendChild(newTreeItem);

    if (window.selectFileName &&
        (fileName == window.selectFileName))
      selectItem = newTreeItem;
  }

  var cgiTree = document.getElementById("cgiTree");

  var oldTreeChildren = document.getElementById("cgiTreeChildren");

  if (oldTreeChildren) {
    cgiTree.removeChild(oldTreeChildren);
    oldTreeChildren = null;
  }

  cgiTree.appendChild(newTreeChildren);

  if (selectItem) {
    cgiTree.selectItem(selectItem);
    //cgiTree.ensureElementIsVisible(selectItem); // Doesn't work (bug)!
  }

  window.selectFileName = null;
}

function ExecuteCGI() {
  var treeCell = GetSelectedTreeCell("cgiTree");
  if (!treeCell)
    return;

  var cgiName = treeCell.getAttribute("label");

  var urlSpec = "cgi+:/"+cgiName;

  LoadRestrictedURL(urlSpec);
}

function CopyCGI(urlSpec) {
  var  file = ProtoFilePicker("Protozilla: Copy CGI program",
                              gActionBox.getAttribute("copyPath"),
                              false, null);
  if (!file) return;

  CopyCGIFile("file:"+file.path);

  gActionBox.setAttribute("copyPath", file.parent.path);
}

function DeleteCGI() {
  var treeCell = GetSelectedTreeCell("cgiTree");
  if (!treeCell)
    return;

  var cgiName = treeCell.getAttribute("label");

  var confirm = ProtoConfirm("Do you wish to delete the CGI program "+
                             cgiName+"?");

  if (confirm) {
    // Delete CGI program
    var cgiFile = cgiDir.clone();
    cgiFile.append(cgiName);

    //WRITE_LOG("protoCGI.js: DeleteCGI: cgiFile = "+cgiFile.path+"\n");
    cgiFile["delete"](true);

    RefreshCGIList();
  }
}

function OnLoadCGIIndex() {
  DEBUG_LOG("protoCGI.js: OnLoadCGIIndex:\n");
  gActionBox = document.getElementById("actionBox");

  RefreshCGIList();
}

function OnUnloadCGIIndex() {
}


function CopyCGIFile(urlSpec) {
  if (!urlSpec) {
    ProtoError("Invalid URL");
    return;
  }

  var fileName = CopyFile(urlSpec, cgiDir);

  if (fileName) {
    window.selectFileName = fileName;
    RefreshCGIList();
  }
}

// Using URLDropObserver from protoCommon.js

var urlBoxObserver = new URLDropObserver(CopyURL);

var cgiTreeObserver = new URLDropObserver(CopyCGIFile);

