#!/usr/bin/perl -T -w
# Test CGI form submission

use strict;
use CGI 'unescape';

my $status_codes = {
   400 => "Bad Request",
};

sub exit_status {
    my ($status_code) = @_;
    my $status_string = $status_codes->{$status_code};
    print "Status: $status_code $status_string\n\n";
    exit;
}

my $buffer = "";
if ($ENV{'REQUEST_METHOD'} eq 'GET') {
    # GET method
    $buffer = $ENV{'QUERY_STRING'} if ($ENV{'QUERY_STRING'})

} elsif ($ENV{'REQUEST_METHOD'} eq 'POST') {
    # POST method
    my $cont_length = $ENV{'CONTENT_LENGTH'};
    if ($cont_length != read(STDIN, $buffer, $cont_length)) {
      exit_status(400);
    }
} else {
    # Unknown method
    &exit_status(400);
}

# Split each post data item and un-escape it to put form data in a hash
my %formdata = ();
my @items = split(/\&/,$buffer);
foreach my $postitem (@items) {
    my ($key, $value) = split(/=/,$postitem);

    $key = unescape($key);
    $value = unescape($value);

    if ($formdata{$key}) {
        $formdata{$key} .= ", $value";
    } else {
        $formdata{$key} .= $value;
    }
}

my @formkeys = sort keys(%formdata);

# Header
print "content-type: text/html\n";
print "\n";

# Content
print "<html><head></head><body>";
print "<h3>Protozilla-specific environment variables</h3><p>";
print "<b>URI_SPEC=$ENV{'URI_SPEC'}</b><p>";
print "<b>URI_DATA=$ENV{'URI_DATA'}</b><p>";
print "<b>URI_HOST=$ENV{'URI_HOST'}</b><p>";
print "<b>URI_PORT=$ENV{'URI_PORT'}</b><p>";
print "<b>SCRIPT_DIRECTORY=$ENV{'SCRIPT_DIRECTORY'}</b><p>";
print "<b>PROTOZILLA_PASS_ENV=$ENV{'PROTOZILLA_PASS_ENV'}</b><p>";
print "<hr>";
print "<h3>Standard CGI environment variables</h3><p>";
print "<b>SERVER_SOFTWARE=$ENV{'SERVER_SOFTWARE'}</b><p>";
print "<b>REQUEST_METHOD=$ENV{'REQUEST_METHOD'}</b><p>";
print "<b>SCRIPT_NAME=$ENV{'SCRIPT_NAME'}</b><p>";
print "<b>PATH_INFO=$ENV{'PATH_INFO'}</b><p>";
print "<b>QUERY_STRING=$ENV{'QUERY_STRING'}</b><p>";
print "<hr>";
print "<h3>System environment variables</h3><p>";
print "<b>DISPLAY=$ENV{'DISPLAY'}</b><p>";
print "<b>HOME=$ENV{'HOME'}</b><p>";
print "<b>LD_LIBRARY_PATH=$ENV{'LD_LIBRARY_PATH'}</b><p>";
print "<b>MOZILLA_FIVE_HOME=$ENV{'MOZILLA_FIVE_HOME'}</b><p>";
print "<b>PATH=$ENV{'PATH'}</b><p>";
print "<b>SHELL=$ENV{'SHELL'}</b><p>";
print "<hr>";

# Print out each item of form data
print "<h3>Parsed query string</h3><p>";
print "<table><tr><td><b>Field</b><td><b>Value</b>\n";
foreach my $key (@formkeys) {
    print "<tr><td>$key<td>$formdata{$key}\n";
}
print "</table>";
print "</body></html>";

close STDOUT;
