var err;

err = initInstall("Protozilla v0.70.0",  // name for install UI
                  "/protozilla",         // registered name
                  "0.70.0.0");           // package version

logComment("initInstall: " + err);

var fComponents = getFolder("Components");
var fChrome     = getFolder("Chrome");
var fProfile    = getFolder("Profile");

var delFile;

var delComps = [ "protozilla-service.js" ];  // Old component names

for (var j=0; j<delComps.length; j++) {
   delFile = getFolder(fComponents, delComps[j]);
   if (File.exists(delFile))
      File.remove(delFile);
}

var delProfs = [ "protozilla/protocol/cat.sh",
                 "protozilla/protocol/finger2.sh",
                 "protozilla/protocol/scp.sh" ];  // Old sample protocols

for (var j=0; j<delProfs.length; j++) {
   delFile = getFolder(fProfile, delProfs[j]);
   if (File.exists(delFile))
      File.remove(delFile);
}

// addDirectory: blank, archive_dir, install_dir, install_subdir
err = addDirectory("", "components", fComponents, "");
if (err != SUCCESS)
   cancelInstall(err);

err = addDirectory("", "chrome",     fChrome,     "");
if (err != SUCCESS)
   cancelInstall(err);

err = addDirectory("", "protozilla", fProfile,    "protozilla");
if (err != SUCCESS)
   cancelInstall(err);

// Register chrome
registerChrome(PACKAGE | DELAYED_CHROME, getFolder("Chrome","protozilla.jar"), "content/protozilla/");

registerChrome(   SKIN | DELAYED_CHROME, getFolder("Chrome","protozilla.jar"), "skin/modern/protozilla/");

registerChrome( LOCALE | DELAYED_CHROME, getFolder("Chrome","protozilla.jar"), "locale/en-US/protozilla/");

if (getLastError() == SUCCESS)
    performInstall();
else {
   alert("Error detected during installation setup: "+getLastError());
   cancelInstall();
}
