# Define `COFF' as 1 if you want to add i386-coff instead of i386-pe
# for Linux/ELF/ia32.
%define COFF 0
Summary: GNU Binary Utility Development Utilities
Name: binutils
%ifarch i386 i486 i586 i686
%if %{COFF}
Version: 2.10.0.18.coff
%else
Version: 2.10.0.18
%endif
%else
Version: 2.10.0.18
%endif
Release: 1
Copyright: GPL
Group: Development/Tools
URL: http://sourceware.cygnus.com/binutils
Source: ftp://ftp.valinux.com/pub/support/hjl/binutils/binutils-%{version}.tar.gz
Buildroot: /var/tmp/binutils-root

%description
Binutils is a collection of binary utilities, including ar (for creating,
modifying and extracting from archives), nm (for listing symbols from
object files), objcopy (for copying and translating object files),
objdump (for displaying information from object files), ranlib (for
generating an index for the contents of an archive), size (for listing
the section sizes of an object or archive file), strings (for listing
printable strings from files), strip (for discarding symbols), c++filt
(a filter for demangling encoded C++ symbols), addr2line (for converting
addresses to file and line), and nlmconv (for converting object code into
an NLM). 

Install binutils if you need to perform any of these types of actions on
binary files.  Most programmers will want to install binutils.

%prep
%setup -q

%build
if [ -x /usr/bin/getconf ] ; then
  NRPROC=$(/usr/bin/getconf _NPROCESSORS_ONLN)
   if [ $NRPROC -eq 0 ] ; then
    NRPROC=1
  fi
else
  NRPROC=1
fi
echo "MAKE=make -j $NRPROC" > makefile
echo "include Makefile" >> makefile
ADDITIONAL_TARGETS=""
%ifarch i386 i486 i586 i686
%if %{COFF}
ADDITIONAL_TARGETS="--enable-targets=i386-linuxaout,i386-coff"
%else
ADDITIONAL_TARGETS="--enable-targets=i386-linuxaout,i386-pe"
%endif
%else
%ifarch sparc
ADDITIONAL_TARGETS="--enable-targets=sparc64-linux"
%endif
%endif

CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" \
  ./configure --prefix=/usr --enable-shared $ADDITIONAL_TARGETS
make tooldir=/usr all info

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr
make prefix=$RPM_BUILD_ROOT/usr tooldir=$RPM_BUILD_ROOT/usr/ install install-info
./binutils/strip-new $RPM_BUILD_ROOT/usr/bin/*
gzip -q9f $RPM_BUILD_ROOT/usr/info/*.info*

#install -m 644 libiberty/libiberty.a $RPM_BUILD_ROOT/usr/lib
install -m 644 include/libiberty.h $RPM_BUILD_ROOT/usr/include

chmod +x $RPM_BUILD_ROOT/usr/lib/lib*.so*

# This one comes from egcs
# Use the one in binutils since it is more recent than the one
# in egcs.
#rm -f $RPM_BUILD_ROOT/usr/bin/c++filt

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
/sbin/install-info --info-dir=/usr/info /usr/info/as.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/bfd.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/binutils.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/gasp.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/gprof.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/ld.info.gz
/sbin/install-info --info-dir=/usr/info /usr/info/standards.info.gz

%preun
if [ $1 = 0 ] ;then
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/as.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/bfd.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/binutils.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/gasp.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/gprof.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/ld.info.gz
  /sbin/install-info --delete --info-dir=/usr/info /usr/info/standards.info.gz
fi

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc README
/usr/bin/*
/usr/man/man1/*
/usr/include/*
/usr/lib/*
/usr/info/*info*
