UNIT Vga256;

INTERFACE

CONST     xmax          =319;
          ymax          =199;

TYPE      dactype       =ARRAY[0..255,0..2] OF BYTE;

VAR       video         :WORD;
          oldx,oldy     :INTEGER;


{bob-object}
TYPE      bob=OBJECT
            sx,sy,ignore:BYTE; xp,yp :WORD;
            fg,bg :ARRAY[0..31,0..31] OF BYTE;
            PROCEDURE Put;
            PROCEDURE Save;
            PROCEDURE Restore;
          END;

{general}
PROCEDURE SetVga256Mode;
PROCEDURE SetTextMode;
PROCEDURE SetPix(Xpix,Ypix:WORD; Color:BYTE);
FUNCTION  GetPix(Xpix,Ypix:WORD):BYTE;
PROCEDURE Clear(Color:BYTE);
PROCEDURE Hline(Xstart,Xstop,Ypos:WORD; Color:BYTE);
PROCEDURE Vline(Xpos,Ystart,Ystop:WORD; Color:BYTE);
PROCEDURE Box(Xa,Ya,Xb,Yb:WORD; Color:BYTE);
PROCEDURE Fbox(Xa,Ya,Xb,Yb:WORD; Color:BYTE);
PROCEDURE Line(xa,ya,xb,yb:INTEGER; color:BYTE);
PROCEDURE LineTo(xb,yb:INTEGER; color:BYTE);

{colors}
PROCEDURE SetPal(N,R,G,B:BYTE);
PROCEDURE GetPal(VAR N,R,G,B:BYTE);
PROCEDURE DacLeft(VAR dac:DACTYPE; a,b:BYTE);
PROCEDURE DacRight(VAR dac:DACTYPE; a,b:BYTE);
PROCEDURE SetDacTable(VAR dac);
PROCEDURE GetDacTable(VAR dac);
PROCEDURE FadeOut(dac:DACTYPE; ms:WORD);
PROCEDURE FadeIn(dac:DACTYPE; ms:WORD);

IMPLEMENTATION

{* general ****************************************************************}

PROCEDURE SetVga256Mode; ASSEMBLER;
 ASM
     MOV  video,$A000
     MOV  AX,$0013
     INT  $10
 END;

PROCEDURE SetTextMode; ASSEMBLER;
 ASM
     MOV  AX,$0003
     INT  $10
 END;

PROCEDURE SetPix(Xpix,Ypix:WORD; Color:BYTE); ASSEMBLER;
 ASM
     CMP  Xpix,xmax
     JA   @Qt
     CMP  Ypix,ymax
     JA   @Qt
     MOV  ES,video
     MOV  AX,320
     MUL  Ypix
     MOV  BX,AX
     ADD  BX,Xpix
     MOV  AL,Color
     MOV  ES:[BX],AL
@Qt:
 END;

FUNCTION  GetPix(Xpix,Ypix:WORD):BYTE; ASSEMBLER;
 ASM
     MOV  ES,video
     MOV  AX,320
     MUL  Ypix
     MOV  BX,AX
     ADD  BX,Xpix
     MOV  AL,ES:[BX]
 END;

PROCEDURE Clear(Color:BYTE); ASSEMBLER;
 ASM
     MOV  ES,video
     MOV  DI,0
     MOV  CX,32000
     MOV  AH,Color
     MOV  AL,AH
     REP  STOSW
 END;

PROCEDURE Hline(Xstart,Xstop,Ypos:WORD; Color:BYTE); ASSEMBLER;
 ASM
     MOV  ES,video              { ES Video Segment }
     MOV  AX,320
     MUL  Ypos
     ADD  AX,Xstart
     MOV  DI,AX                 { DI Start Pixel Video Offset }
     MOV  CX,Xstop
     SUB  CX,Xstart             { CX Count pixels }
     INC  CX
     MOV  AL,Color              { AL Pixel Color }
     REP  STOSB
 END;

PROCEDURE Vline(Xpos,Ystart,Ystop:WORD; Color:BYTE); ASSEMBLER;
 ASM
     MOV  ES,video              { ES Video Segment }
     MOV  SI,Xpos
     MOV  AX,320
     MUL  Ystop
     MOV  Ystop,AX
     MOV  AX,320
     MUL  Ystart
     MOV  BX,AX
     MOV  AL,Color
@lp: MOV  ES:[BX+SI],AL
     ADD  BX,320
     CMP  BX,Ystop
     JBE  @lp
 END;

PROCEDURE Box(Xa,Ya,Xb,Yb:WORD; Color:BYTE); ASSEMBLER;
 ASM
     MOV  ES,video
     MOV  BX,Xa
     MOV  AX,320
     MUL  Ya
     MOV  SI,AX
     MOV  AX,320
     MUL  Yb
     MOV  DI,AX
     MOV  AL,Color
@lp: MOV  ES:[BX+SI],AL
     MOV  ES:[BX+DI],AL
     INC  BX
     CMP  BX,Xb
     JBE  @lp
     MOV  BX,SI
     MOV  CX,DI
     MOV  SI,Xa
     MOV  DI,Xb
@l2: MOV  ES:[BX+SI],AL
     MOV  ES:[BX+DI],AL
     ADD  BX,320
     CMP  BX,CX
     JBE  @l2

 END;

PROCEDURE Fbox(Xa,Ya,Xb,Yb:WORD; Color:BYTE); ASSEMBLER;
 ASM
     MOV  ES,video
     MOV  CX,Xb
     SUB  CX,Xa
     INC  CX
     MOV  SI,CX
@lp: MOV  AX,320
     MUL  Ya
     ADD  AX,Xa
     MOV  DI,AX
     MOV  AL,Color
     REP  STOSB
     MOV  CX,SI
     INC  Ya
     MOV  AX,Ya
     CMP  AX,Yb
     JBE  @lp
 END;

PROCEDURE Line(xa,ya,xb,yb:INTEGER; color:BYTE); ASSEMBLER;
 VAR d,dx,dy,bi,x,y:INTEGER; {SI=xi} {DI=yi} {CX=ai}
 ASM
     MOV  ES,video
     MOV  AX,xb         { AX=Abs(xb-xa) }
     MOV  oldx,AX
     SUB  AX,xa
     CMP  AX,0
     JGE  @n1
     NEG  AX
@n1: MOV  BX,yb         { BX=Abs(yb-ya) }
     MOV  oldy,BX
     SUB  BX,ya
     CMP  BX,0
     JGE  @n2
     NEG  BX
@n2: CMP  AX,BX         { IF AX<BX THEN continue ELSE jump to @p0 }
     JGE  @p0
     {--------}
     MOV  AX,ya         { IF ya>yb THEN swap parameters }
     CMP  AX,yb
     JLE  @n3
     XCHG AX,yb         { swap parameters }
     XCHG AX,ya
     MOV  AX,xa
     XCHG AX,xb
     XCHG AX,xa  
@n3: MOV  AX,xa         { IF xa<xb THEN Xi=1 ELSE Xi=-1 }
     MOV  si,-1
     CMP  AX,xb
     JGE  @n4
     MOV  si,1
@n4: MOV  AX,yb         { dy=yb-ya }
     SUB  AX,ya
     MOV  dy,AX
     MOV  AX,xb         { dx=Abs(xb-xa) }
     SUB  AX,xa
     CMP  AX,0
     JGE  @n5
     NEG  AX
@n5: MOV  dx,AX
     ADD  AX,AX         { bi=2*dx }
     MOV  bi,AX
     SUB  AX,dy         { d=2*dx-dy }
     MOV  d,AX
     MOV  AX,dx         { ai:=2*(dx-dy) }
     SUB  AX,dy
     ADD  AX,AX
     MOV  cx,AX
     MOV  AX,xa         { x=xa }
     MOV  x,AX
     MOV  AX,ya         { y=ya }
     MOV  y,AX
@px: CMP  x,xmax        { SetPix(x,y,color) }
     JA   @n6
     CMP  y,ymax
     JA   @n6
     MOV  AX,320
     MUL  y
     MOV  BX,AX
     ADD  BX,x
     MOV  AL,color
     MOV  ES:[BX],AL
@n6: INC  y             { y=y+1 (next pixel) }
     CMP  d,0           { IF (D>=0) THEN continue ELSE jump to @n7 }
     JL   @n7
     ADD  x,si          { Inc(x,xi) }
     ADD  d,cx          { Inc(d,ai) }
     JMP  @n8
@n7: MOV  AX,bi         { Inc(d,bi) }
     ADD  d,AX
@n8: MOV  AX,y          { IF y<=yb THEN draw next pixel }
     CMP  AX,yb
     JLE  @px
     JMP  @Qt
     {--------}
@p0: MOV  AX,xa         { IF xa>xb THEN swap parameters }
     CMP  AX,xb
     JLE  @p3
     XCHG AX,xb         { swap parameters }
     XCHG AX,xa
     MOV  AX,ya
     XCHG AX,yb
     XCHG AX,ya
@p3: MOV  AX,ya         { IF ya<yb THEN Yi=1 ELSE Yi=-1 }
     MOV  di,-1
     CMP  AX,yb
     JGE  @p4
     MOV  di,1
@p4: MOV  AX,xb         { dx=xb-xa }
     SUB  AX,xa
     MOV  dx,AX
     MOV  AX,yb         { dy=Abs(yb-ya) }
     SUB  AX,ya
     CMP  AX,0
     JGE  @p5
     NEG  AX
@p5: MOV  dy,AX
     ADD  AX,AX         { bi=2*dy }
     MOV  bi,AX
     SUB  AX,dx         { d=(2*dy)-dx }
     MOV  d,AX
     MOV  AX,dy         { ai=2*(dy-dx) }
     SUB  AX,dx
     ADD  AX,AX
     MOV  cx,AX
     MOV  AX,xa         { x=xa }
     MOV  x,AX
     MOV  AX,ya         { y=ya }
     MOV  y,AX
@py: CMP  x,xmax        { SetPix(x,y,color) }
     JA   @n6
     CMP  y,ymax
     JA   @p6
     MOV  AX,320
     MUL  y
     MOV  BX,AX
     ADD  BX,x
     MOV  AL,color
     MOV  ES:[BX],AL
@p6: INC  x             { x=x+1 (next pixel) }
     CMP  d,0           { IF D>=0 THEN continue ELSE jump to @p7 }
     JL   @p7
     ADD  y,di          { Inc(y,yi) }
     ADD  d,cx          { Inc(d,ai) }
     JMP  @p8
@p7: MOV  AX,bi         { Inc(d,bi) }
     ADD  d,AX
@p8: MOV  AX,x          { IF x<=xb THEN draw next pixel }
     CMP  AX,xb
     JLE  @py
@Qt:
 END;

PROCEDURE LineTo(xb,yb:INTEGER; color:BYTE);
 BEGIN
   Line(oldx,oldy,xb,yb,color);
 END;

{* colors *****************************************************************}

PROCEDURE SetPal(N,R,G,B:BYTE);
 BEGIN
   Port[$3C8]:=N;
   Port[$3C9]:=R;
   Port[$3C9]:=B;
   Port[$3C9]:=G;
 END;

PROCEDURE GetPal(VAR N,R,G,B:BYTE);
 BEGIN
   Port[$3C7]:=N;
   R:=Port[$3C9];
   G:=Port[$3C9];
   B:=Port[$3C9];
 END;

PROCEDURE SetDacTable(VAR dac); ASSEMBLER;
 ASM
     PUSH DS
     LDS  SI,dac
     MOV  DX,$3C8
     MOV  AL,0
     MOV  CX,768
     OUT  DX,AL
     INC  DX
     REP  OUTSB
     POP  DS
 END;

PROCEDURE GetDacTable(VAR dac); ASSEMBLER;
 ASM
     LES  DX,dac
     MOV  AX,$1017
     MOV  BX,$0000
     MOV  CX,$0100
     INT  $10
 END;

PROCEDURE DacLeft(VAR dac:DACTYPE; a,b:BYTE);
 VAR t,u:BYTE; v:ARRAY[0..2] OF BYTE;
 BEGIN
   v[0]:=dac[a,0]; v[1]:=dac[a,1]; v[2]:=dac[a,2];
   FOR t:=a+1 TO b DO FOR u:=0 TO 2 DO dac[t-1,u]:=dac[t,u];
   dac[b,0]:=v[0]; dac[b,1]:=v[1]; dac[b,2]:=v[2];
 END;

PROCEDURE DacRight(VAR dac:DACTYPE; a,b:BYTE);
 VAR t,u:BYTE; v:ARRAY[0..2] OF BYTE;
 BEGIN
   v[0]:=dac[b,0]; v[1]:=dac[b,1]; v[2]:=dac[b,2];

   FOR t:=b DOWNTO a+1 DO FOR u:=0 TO 2 DO dac[t,u]:=dac[t-1,u];

   dac[a,0]:=v[0]; dac[a,1]:=v[1]; dac[a,2]:=v[2];
 END;

PROCEDURE FadeOut(dac:DACTYPE; ms:WORD); 
 VAR finished:BOOLEAN; t,u:BYTE;
 BEGIN
   REPEAT
     finished:=TRUE;
     FOR t:=0 TO 255 DO FOR u:=0 TO 2 DO IF dac[t,u]>0 THEN
      BEGIN
        finished:=FALSE;
        Dec(dac[t,u]);
      END;
     SetDacTable(dac);
      ASM
       MOV AX,1000
       MUL ms
       MOV CX,DX
       MOV DX,AX
       MOV AH,$86
       INT $15
      END;
   UNTIL finished;
 END;

PROCEDURE FadeIn(dac:DACTYPE; ms:WORD);
 VAR t,u:BYTE; finished:BOOLEAN; tmp:DACTYPE;
 BEGIN
   FOR t:=0 TO 255 DO FOR u:=0 TO 2 DO tmp[t,u]:=0;
   REPEAT
     finished:=TRUE;
     FOR t:=0 TO 255 DO FOR u:=0 TO 2 DO IF dac[t,u]>tmp[t,u] THEN
      BEGIN
        finished:=FALSE;
        Inc(tmp[t,u]);
      END;
     SetDacTable(tmp);
      ASM
       MOV AX,1000
       MUL ms
       MOV CX,DX
       MOV DX,AX
       MOV AH,$86
       INT $15
      END;
   UNTIL finished;
 END;

{* bob-object *************************************************************}

PROCEDURE bob.Put;
 VAR tx,ty:BYTE;
 BEGIN
   FOR tx:=0 to sx DO for ty:=0 TO sy DO
   IF fg[tx,ty]<>ignore THEN SetPix(xp+tx,yp+ty,fg[tx,ty]);
 END;

PROCEDURE bob.Save;
 VAR tx,ty:BYTE;
 BEGIN
   FOR tx:=0 to sx DO for ty:=0 TO sy DO bg[tx,ty]:=GetPix(xp+tx,yp+ty);
 END;

PROCEDURE bob.Restore;
 VAR tx,ty:BYTE;
 BEGIN
   FOR tx:=0 to sx DO for ty:=0 TO sy DO SetPix(xp+tx,yp+ty,bg[tx,ty]);
 END;

BEGIN
END.