//SVGA example on how to write pixels to video memory.
//This example will fill the whole screen with pixels and give
//you the time it took to perform this task.
//By Tommy Grandefors

#include "svga.hh"

#include <iostream.h> 	//cout...
#include <conio.h> 	//getch()...
#include <time.h> 	//clock()...

#define TEXT		0

char GetMode(void);

void main(void) //The good old main...
{	
	char mode = GetMode(); //Get user input.

	if((mode < 1) || (mode > 4)) //Valid modes?
	{
		cout<<"Invalid mode chosen"<<endl;
		return;
	}	
	
	SVGA mySVGA; //Instantiate

	if(!mySVGA.SetResolution(mode)) //Try to set the chosen mode.
	{
		cout<<"Sorry, can't set the resolution"<<endl;
		return;
	}	

	mySVGA.ClearScreen(0); //Make it black!

	short int x = mySVGA.GetWidth(); //Get screen width in nr of pixels.
	short int y = mySVGA.GetHeight(); //Get screen height in nr of pixels.

	unsigned char color = 0;

	double time;
	clock_t first, second;
	first=clock(); //Start timer

	//Fill the whole screen with 256 colors using the 'PutPixel()' method.
	for(int i = 0; i < x; i++)
		for(int j = 0; j < y; j++)
			mySVGA.PutPixel(i,j,color++);
	
	second=clock(); //Stop timer
	time=(double)(second-first)/CLK_TCK; //Calculate total time duration

	getch(); //Wait for a keystroke.
	
	mySVGA.SetResolution(TEXT);

	cout<<"Using the method 'PutPixel()' to plot "<<x<<"*"<<y<<" pixels took:"<<endl;
	cout<<time<<" seconds."<<endl;
} //The end.

char GetMode(void)
{
	cout<<"\nWhat resolution do you want to use?\n"<<endl;
	cout<<"1. 640x480 with 256 colors"<<endl;
	cout<<"2. 800x600 with 256 colors"<<endl;
	cout<<"3. 1024x768 with 256 colors"<<endl;
	cout<<"4. 1024x1024 with 256 colors\n"<<endl;
	
	return (char)(getch() - 48);
}