Program threed;

Uses CRT,SPX_IMG,SPX_VGA,SPX_KEY,SPX_OBJ,SPX_T3D,SPX_TXT,SPX_FNC;

const
  pbeg : plist = nil;
  pend : plist = nil;
  path = '';    { default work path }
  xsize = 5;  ysize = 5;  zsize = 5;
  spacing = 5;
  recx1 = 20;  recx2 = 300;  recy1 = 40;  recy2 = 160;
  sw = 4; { 1/2 sprite width from center }
  xjump = 8;
  yjump = 8;

type
  Ppoint = ^Tpoint;
  Tpoint = object(Tobjs)
             x,y,z : integer;
             constructor init(nx,ny,nz:integer);
           end;

var
  oldexit   : pointer;
  d,m,r     : integer;
  pal   : RGBlist;
  balls : array[0..39] of pointer;
  xpos,ypos,zpos        : integer;
  xa,ya,za              : integer;
  NewSize  : pointer;
  dir      : integer;

procedure cleanup;far;
begin
  clean_plist(pbeg,pend);
  closemode;
  exitproc := oldexit;
end;

procedure setup;
begin
  openmode(3);
  setpageactive(3);
  loadpcx(path+'stars.pcx'); { load pcx file on page 3 }
  CopyRect(recx1,recy1,recx2,recy2,pages[3]^,pages[2]^);
  CopyRect(recx1,recy1,recx2,recy2,pages[3]^,pages[1]^);
  loadvsp(path+'ship.vsp',balls);
  loadcolors(path+'ship.pal',pal,256);
  fsetcolors(pal);  { palette }
  oldexit := exitproc; exitproc := @cleanup;
end;

procedure twodimto3d(lx1,lx2,ly1,ly2,page: integer);
var x,y,pcolor,
    xx,yy,zz                           : integer;
    p                                  : plist;
begin
   setpageactive(page);
   { grey scale image to derive depth }
   loadpcx(path+'test.pcx');   { load pcx file on page }
   for x:=lx1 to lx2 do begin
      for y:=ly1 to ly2 do begin
       if (x mod spacing =0) and (y mod spacing=0) then begin    { take every eigth point }
         pcolor:=point(x,y,page);
           new(p);
           p^.item := new(ppoint,init(x-(lx2 div 2),-(pcolor div 8),y-(ly2 div 2)));
           p^.item^.powner := p;
           addp(pbeg,pend,p);
       end;
      end;
   end;
end;

procedure setlevel;
begin
    twodimto3d(1,260,1,200,2);
end;

procedure drawlist;
var
  nx,ny,nz,
  ox,oy,oz : integer;
  p        : plist;
  dumx,dumy  :integer;
begin
  p := pbeg;
  while p<>nil do
    with ppoint(p^.item)^ do
      begin
        nx := x; ny := y; nz := z;
        rotate256xyz(nx,ny,nz,0,0,r);
        if p<>pbeg
          then
            begin
            { draw converted point }
              setpoints((nx),(ny),(nz),dumx,dumy);
              if (recx1-sw<dumx) and (dumx<recx2+sw)
                and (recy1-sw<dumy) and (dumy<recy2+sw)
                then ftput(dumx,dumy,balls[22]^,true);
            end;
        ox := nx; oy := ny; oz := nz;
        p := p^.next;
      end;
end;


procedure getkey;
begin
  if plus
    then r := (r+1)mod 256
    else
     if minus
       then r := (r+255)mod 256;

  {left or right}
  if np[4,2] and (xv>-300)
    then begin
      dir:=4;
    end
    else
      if np[6,2] and (xv<300)
        then begin
          dir:=2;
        end

  {up or down}
  else if np[8,2] and (yv>-300)
    then begin
      dir:=3;
    end
    else
      if np[2,2] and (yv<300)
        then begin
        dir:=1;
      end
  else dir:=0;

  {in or out}
  if np[4,1] and (m>-200)
    then dec(m,5)
    else
      if np[6,1] and (m<135)
        then inc(m,5);

  { jump is amount to move sprites }
  if dir=1 then inc(yv,yjump)
     else if dir=2 then inc(xv,xjump)
     else if dir=3 then dec(yv,yjump)
     else if dir=4 then dec(xv,xjump);
end;


procedure drawall(draw:boolean);
begin
  CopyRect(recx1,recy1,recx2,recy2,pages[3]^,pages[2]^);
  setpageactive(2);
  drawlist;
end;


procedure Animate;
begin
  setlevel; zv := 300; m := 0; r := 0;
  repeat
    getkey;
    drawall(true);
    CopyRect(recx1,recy1,recx2,recy2,pages[2]^,pages[1]^);
  until esc;
end;



(**) { tpoint methods }

constructor tpoint.init(nx,ny,nz:integer);
begin
  {inherited init;}
  x := nx; y := ny; z := nz;
end;



begin
  setup;
  Animate;
end.