
Program Tanks;

{$F+}

{ Written by Aaron Wacker using the SPX graphics library  }

Uses SPX_JOY,SPX_VGA,SPX_KEY,SPX_GEO,
     SPX_TXT,SPX_FNC,SPX_FLI,SPX_OBJ,SPX_SND,SPX_T3D;


const
  path  = '';
  gmx   = 50;                    { tile map size }
  gmy   = 50;
  gsx   = 16;                    { tile size }
  gsy   = 16;
  smx   = gmx*gsx;               { tile map size in pixels }
  smy   = gmy*gsy;
  speed : integer = 9;
  max  = 300;
  framerate  : integer = 20;    { NOT in fps! }


type
  putmode = (draw,erase,update);
  Pballs = ^Tballs;
  Tballs = object(Tobjs)
             width,height,              { dimension of sprite }
             kind,                      { sprite number }
             ox,oy,                     { old position }
             x2,y2,                     { new position }
             dx,dy : integer;           { direction }
             constructor init(nx,ny,k:integer);
             procedure drawitemobject;virtual;
             procedure calcitemobject;virtual;
          end;

  PMyMorph = ^TMyMorph;
  TMyMorph = object(TMorph)
               function geomap(x,y:integer):integer;virtual;
               procedure placegeo(x,y,geonum:integer);virtual;
               procedure nogogeo(x,y:integer); virtual;
             end;

var
  MyMorph : PMyMorph;
  gpic    : array[0..100] of pointer;
  map     : array[0..gmy-1,0..gmx-1] of byte;
  pal     : RGBlist;
  flip,
  geo_cnt,
  x,y     : integer; {updated page 1 coordinates}
  x2,y2   : integer; {non-updated global coordinates for objects}
  charx,
  chary   : integer; {coordinates of character}
  char2x,
  char2y   : integer; {coordinates of 2nd character}
  t,t2     : integer; {tile you stand on}
  players  : integer;    {number of players}
  charicon : integer;
  charicon2: integer;
  a        : boolean;
  ballpoints  : integer;
  ballpoints2 : integer;
  shipframe   : integer;
  shipframe2  : integer;
  machine     : integer;
  fuel, fuel2 : integer;
  shield, shield2 : integer;
  facing, facing2       : integer;
  xi,xi2,yi,yi2         : real;  {vector increment}
  vi,vi2                : integer;
  vx,vx2,vy,vy2         : integer;
  testshot, testshot2   : boolean;
  totalx2,totaly2   : integer;
  totalmen          : integer;
  averagemanx,
  averagemany       : integer;

  balls                 : array[0..60] of pointer;
  head,
  tail  : plist;
  p     : plist;

procedure setup;
var
  d : integer;

begin
  openmode(4);
  randomize;
  charx:=85; chary:=85;
  char2x:=195; char2y:=85;
  ballpoints  :=0;
  ballpoints2 :=0;
  shipframe  :=40;
  shipframe2 :=40;
  fuel:=100; fuel2:=100;
  shield:=50; shield2:=50;
  facing:=270; facing2:=270;
  xi:=0.0; xi2:=0.0; yi:=0.0; yi2:=0.0;
  vi:=0; vi2:=0;
  MyMorph := new(PMyMorph,init(gmx,gmy,19,12,16,16));
  setpageactive(2);
  geo_cnt := loadgmp(path+'game.gmp',gpic,map);
  loadcolors(path+'game.pal',pal,256);
  x := 200; y := 200;
  x2:= 200; y2:= 200;

  setpageactive(4);
  loadvsp(path+'game.vsp',balls);
  head := nil; tail := nil;


  {shots}
  for d:=1 to 20 do
  begin
       new(p);
       p^.item := new(Pballs,init(random(smx),random(smy),17));
       p^.item^.powner := p;
       addp(head,tail,p);
  end;

  {fuel boxes}
  for d:=1 to 10 do
  begin
       new(p);
       p^.item := new(Pballs,init(random(smx),random(smy),17));
       p^.item^.powner := p;
       addp(head,tail,p);
  end;

  {people-unhit}
  for d := 1 to max-1 do
    begin
      new(p);
      p^.item := new(Pballs,init(random(smy),random(smx),(random(4)+2)));
      p^.item^.powner := p;
      addp(head,tail,p);
    end;
end;

procedure placeballs(var head:plist;mode:putmode);
var
  p : plist;
begin
  p := head;
  while p<>nil do
    begin
      case mode of
        draw   : p^.item^.drawitemobject;
      end;
      p := p^.next;
    end;
end;


procedure changexy;

var avex,avey : integer;  {averages of character positions }
    oldx, oldy : integer;
    i: integer;  {increment to move character}
    turnspeed : integer;

begin
  if machine = 2 then begin
     i:=3;
     turnspeed:=10;
  end
  else if machine = 3 then begin
     i:=2;
     turnspeed:=7;
  end
  else begin
     i:=1;
     turnspeed:=5;
  end;

  {speed is a var from 1 to 9}
  if np[7,1] or np[8,1] or np[9,1]              {up}
    then begin
       if (vi<(4*i)) then vi:=vi+i;
    end
    else
      if np[1,1] or np[2,1] or np[3,1]          {down}
        then begin
           if (vi>-(4*i)) then vi:=vi-i;
        end;
  if np[7,1] or np[4,1] or np[1,1]              {left}
    then facing:=facing-turnspeed
   else
      if np[9,1] or np[6,1] or np[3,1]          {right}
        then facing:=facing+turnspeed;

if facing >360 then facing:=facing-360;
if facing <0 then facing:=facing+360;

xi:=cos(2*3.1416/360*facing)*vi;
yi:=sin(2*3.1416/360*facing)*vi;

if (charx>16) and (xi<0.0) then charx:=charx+round(xi)
   else if (charx<275) and (xi>0.0) then charx:=charx+round(xi);
if (chary>16) and (yi<0.0) then chary:=chary+round(yi)
   else if (chary<155) and (yi>0.0) then chary:=chary+round(yi);

  {player 2}
 if players = 2 then begin
  if np[7,2] or np[8,2] or np[9,2]              {up}
    then begin
         if (vi2<4*(i)) then vi2:=vi2+i;
    end
    else
      if np[1,2] or np[2,2] or np[3,2]          {down}
        then if (vi2>(-4*i)) then vi2:=vi2-i;

  if np[7,2] or np[4,2] or np[1,2]              {left}
    then facing2:=facing2-turnspeed
    else
      if np[9,2] or np[6,2] or np[3,2]          {right}
        then facing2:=facing2+turnspeed;
 end;

if facing2 >360 then facing2:=facing2-360;
if facing2 <0 then facing2:=facing2+360;

xi:=(cos(2*3.1416/360*facing2)*vi2);
yi:=(sin(2*3.1416/360*facing2)*vi2);

if (char2x>16) and (xi<0.0) then char2x:=char2x+round(xi)
   else if (char2x<275) and (xi>0.0) then char2x:=char2x+round(xi);
if (char2y>16) and (yi<0.0) then char2y:=char2y+round(yi)
   else if (char2y<155) and (yi>0.0) then char2y:=char2y+round(yi);

     avex:=(charx+char2x) div 2;
     avey:=(chary+char2y) div 2;

   if players <> 2 then begin
       avex:=charx;
       avey:=chary;
   end;

   oldx:=x;
   oldy:=y;
        if (avex > 240) or (avex < 60) or (avey > 140) or (avey < 40) then speed:=5
        else if (avex > 220) or (avex < 80) or (avey > 130) or (avey < 50) then speed:=4
        else if (avex > 200) or (avex < 100) or (avey > 120) or (avey < 60) then speed:=3
        else if (avex > 180) or (avex < 120) or (avey > 110) or (avey < 70) then speed:=2
        else if (avex > 160) or (avex < 140) or (avey > 100) or (avey < 80) then speed:=1
        else speed :=0;
   if speed <> 0 then begin
     if machine = 2 then speed:=speed+2
        else if machine = 3 then speed:=speed+1;

     if avex > 160 then inc(x,speed);
     if avex < 140 then dec(x,speed);
     if avey > 100 then inc(y,speed);
     if avey < 80 then dec(y,speed);

   end;

  charx:=charx+(oldx-x);
  chary:=chary+(oldy-y);
  char2x:=char2x+(oldx-x);
  char2y:=char2y+(oldy-y);

  if ch in ['1'..'9']
    then speed := vl(ch);
  ifix(x,0,smx-1); ifix(y,0,smy-1);
end;

procedure drawbox(sx,sy,w,h: integer);
var dum,
    dum2   : integer;
begin
     {top}
     dum:=0;
     ftput(sx,sy,gpic[69]^, false);
     if w>2 then begin
        repeat
           dum:=dum+1;
           ftput(sx+(dum*16), sy, gpic[70]^, false);
        until dum=(w-2);
        ftput(sx+((w-1)*16),sy,gpic[71]^, false);
     end;

     {middle}
     dum:=0;
     dum2:=0;
     if h>2 then repeat
       dum2:=dum2+1;
       ftput(sx,(sy+(dum2*16)),gpic[76]^, false);
       if w>2 then begin
          repeat
             dum:=dum+1;
             ftput(sx+(dum*16), (sy+(dum2*16)), gpic[77]^, false);
          until dum=(w-2);
       end;
       ftput(sx+((w-1)*16),(sy+(dum2*16)),gpic[72]^, false);
     until dum2=(h-2);

     {bottom}
     dum:=0;
     dum2:=dum2+1;
     ftput(sx,(sy+(dum2*(16))),gpic[75]^, false);
     if w>2 then begin
        repeat
           dum:=dum+1;
           ftput(sx+(dum*16), (sy+(dum2*(16))), gpic[74]^, false);
        until dum=(w-2);
        ftput(sx+((w-1)*16),(sy+(dum2*(16))),gpic[73]^, false);
     end;
end;


procedure drawmenus;
var i : integer; {indention of menu for player 2}
begin
     { top of menu }

     drawbox(20,20,4,2);

     { statistics }
     putletter(25,26,21,'Points = '+st(ballpoints));
     putletter(24,26,1,'Points = '+st(ballpoints));
     putletter(25,34,21,'Shields= '+st(Shield));
     putletter(24,33,1,'Shields= '+st(Shield));
     putletter(25,41,21,'Fuel = '+st(fuel));
     putletter(24,40,1,'Fuel = '+st(fuel));

     putletter(24,47,1,'tile = ' +st(t));
     putletter(24,54,1,'x,y = ' +st(x) + st(y));
     putletter(24,61,1,'ax,ay = ' +st(averagemanx) + st(averagemany));

     if players=2 then begin
        i:=213;

        drawbox(233,20,4,2);

        { statistics }
        putletter(25+i,26,21,'Points = '+st(ballpoints2));
        putletter(24+i,26,1,'Points = '+st(ballpoints2));
        putletter(25+i,34,21,'Shields= '+st(Shield2));
        putletter(24+i,33,1,'Shields= '+st(Shield2));
        putletter(25+i,41,21,'Fuel = '+st(fuel2));
        putletter(24+i,40,1,'Fuel = '+st(fuel2));
     end;
end;

procedure addbullet(x,y,kind:integer);
begin
       new(p);
       p^.item := new(Pballs,init(x,y,kind));
       p^.item^.powner := p;
       addp(head,tail,p);
end;

{***************************************************************}
procedure Animate;
var
  p : pointer;
  d : integer; {dummy}
  bulletnum : integer;

begin
  flip := 0;

  repeat

  setpageactive(2);

     flip := (flip+1)mod 3;
     changexy;
     MyMorph^.drawmap(x,y);

  if shield > 0 then begin
     if (facing>247) and (facing<293) then begin
        ftput(charx,chary, balls[39]^,true);
        bulletnum:=24;
        end
     else if (facing>292) and (facing<338) then begin
        ftput(charx,chary, balls[40]^,true);
        bulletnum:=26;
        end
     else if (facing>337) or (facing<23) then begin
        ftput(charx,chary, balls[41]^,true);
        bulletnum:=28;
        end
     else if (facing>22) and (facing<68) then begin
        ftput(charx,chary, balls[42]^,true);
        bulletnum:=30;
        end
     else if (facing>67) and (facing<91) then begin
        ftput(charx,chary, balls[43]^,true);
        bulletnum:=32;
        end
     else if (facing>90) and (facing<158) then begin
        ftput(charx,chary, balls[44]^,true);
        bulletnum:=34;
        end
     else if (facing>157) and (facing<203) then begin
        ftput(charx,chary, balls[45]^,true);
        bulletnum:=36;
        end
     else if (facing>202) and (facing<248) then begin
        ftput(charx,chary, balls[46]^,true);
        bulletnum:=38;
        end
  end
  else ftput(charx,chary, balls[3]^,true);

 if players = 2 then
   if shield2 > 0 then begin
     if (facing2>247) and (facing2<293) then
        ftput(char2x,char2y, balls[39]^,true)
     else if (facing2>292) and (facing2<338) then
        ftput(char2x,char2y, balls[40]^,true)
     else if (facing2>337) or (facing2<23) then
        ftput(char2x,char2y, balls[41]^,true)
     else if (facing2>22) and (facing2<68) then
        ftput(char2x,char2y, balls[42]^,true)
     else if (facing2>67) and (facing2<91) then
        ftput(char2x,char2y, balls[43]^,true)
     else if (facing2>90) and (facing2<158) then
        ftput(char2x,char2y, balls[44]^,true)
     else if (facing2>157) and (facing2<203) then
        ftput(char2x,char2y, balls[45]^,true)
     else if (facing2>202) and (facing2<248) then
        ftput(char2x,char2y, balls[46]^,true);
   end
  else ftput(char2x,char2y, balls[3]^,true);

     if np[5,1] then begin {* player 1 fires *}
        if fuel > 0  then begin
           testshot := true;
              vx:=charx+round((cos(2*3.1416/360*facing)*7));
              vy:=chary+round((sin(2*3.1416/360*facing)*7));
           line(charx,chary,vx,vy,32);
           ftput(vx,vy,gpic[85+flip]^,true);
           addbullet(x+charx,y+chary,bulletnum);
           if (abs(vx-char2x+8)<10) and (abs(vy-char2y+8)<10) then
              shield2:=shield2-3;
        fuel:=fuel-1;
        end
        else testshot:=false;
     end;
     if np[5,2] and (players=2) then begin {* player 2 fires *}
        if fuel2 > 0  then begin
           testshot2:=true;
              vx2:=char2x+round((cos(2*3.1416/360*facing2)*70));
              vy2:=char2y+round((sin(2*3.1416/360*facing2)*70));

           line(char2x,char2y,vx2,vy2,32);
           ftput(vx2,vy2,gpic[85+flip]^,true);
           if (abs(vx2-charx+8)<10) and (abs(vy2-chary+8)<10) then
              shield:=shield-3;

        fuel2:=fuel2-1;

        end
        else testshot2:=false;
     end;

     Colorcycle(pal,88,5,TRUE);
     {Colorcycle(pal,36,4,TRUE);      }
     fsetcolors(pal);

    totalmen:=0;
    totalx2:=0;
    totaly2:=0;

    calcitems(head);

    averagemanx:=totalx2 div totalmen;
    averagemany:=totaly2 div totalmen;


    placeballs(head,draw);

    {********************** stationary collision detect *********************}
    t:=map[(y div 16)-((100-chary+16) div 16),(x div 16)-((160-charx+8)div 16)];
    t2:=map[(y div 16)-((100-char2y+16) div 16),(x div 16)-((160-char2x+8)div 16)];
    if t <> 8 then begin
       if t = 84 then if fuel<100 then fuel :=fuel +1;
       if t2 = 84 then if fuel2 <100 then fuel2 :=fuel2 +1;
       if t = 49 then if shield>0 then shield :=shield-1;
       if t2 = 49 then if shield2>0 then shield2 :=shield2-1;
       if (t=57) or (t=1) then begin
          vi:=-vi;
       end;
       if (t2=57) or (t2=1) then begin
          vi2:=-vi2;
       end;
    end;


    drawmenus;

    copyRect(16,16,303,183,pages[2]^,pages[1]^);

  until esc;
end;

{****************** initialization of objects ********************}
constructor Tballs.init(nx,ny,k:integer);
begin
  Tobjs.init;
  kind := k;
  x2 := nx; y2 := ny;
  ox := x2; oy := y2;
  if (kind>23) and (kind<40) then begin
        dx := (vx-charx);               {direction increments}
        dy := (vy-chary);

  end
  else begin
       repeat
        dx := random(5)-3;               {direction increments}
        dy := random(5)-3;
        until (dx<>0) and (dy<>0);
  end;
  imagedims(balls[kind]^,width,height);
end;

procedure Tballs.drawitemobject;
begin
  ftput(x2-x,y2-y,balls[kind]^,true);
end;

{******************************* object calculations *********************}
procedure Tballs.calcitemobject;
var hit               : boolean;
    ballhitguy        : boolean;
    ballhitguy2       : boolean;

begin
  if kind = 17 then begin       {stationary objects}
  end

  else begin                    {moving objects}
       hit:=false;
       ox := x2; oy := y2;
       inc(x2,dx); inc(y2,dy);
       if ((x2 > smx) or (x2 < 16))
          then dx := -dx;
       if ((y2 > smy) or (y2 < 16))
          then dy := -dy;
  end;

  if (kind>18) and (kind<40) then begin  {*missiles*}

  end;

  if (kind>3) and (kind<7) then begin  {*people*}

    if x2 < averagemanx then if ((random(5)<2) and (dx<5)) then dx:=dx+1;
    if x2 > averagemanx then if ((random(5)<2) and (dx>-5)) then dx:=dx-1;
    if y2 < averagemany then if ((random(5)<2) and (dy<5)) then dy:=dy+1;
    if y2 > averagemany then if ((random(5)<2) and (dy>-5)) then dy:=dy-1;

    totalx2:=totalx2+(x2);
    totaly2:=totaly2+(y2);

     totalmen:=totalmen+1;
  end;

  {killed people}
  if kind = 3 then begin
        dx:=0; dy:=0;
     end
  else begin
      ballhitguy := (abs(x2-x-charx+8)<10) and (abs(y2-y-chary+8)<10);
      if ballhitguy then begin
         if kind = 4 then begin
            ballpoints:=ballpoints+1;
            kind:=random(4)+6;
            dx:=0; dy:=0;
            x2:=x2+round(cos(2*3.1416/360*facing)*vi); {skid}
            y2:=y2+round(sin(2*3.1416/360*facing)*vi);
            shield:=shield-1;  { guy damages hovertank }
         end;
      end;
        if testshot=true then begin
           ballhitguy := (abs(x2-x-vx+8)<10) and (abs(y2-y-vy+8)<10);
           if ballhitguy then begin
            if kind = 4 then begin
              ballpoints:=ballpoints+5;
              kind:=random(4)+6;
              dx:=0; dy:=0;
              x2:=x2+round(cos(2*3.1416/360*facing)*vi); {knock back}
              y2:=y2+round(sin(2*3.1416/360*facing)*vi);
            end;
           end;
        end;

      if players=2 then begin
        ballhitguy2 := (abs(x2-x-char2x+8)<10) and (abs(y2-y-char2x+8)<10);
        if ballhitguy2 then begin
           if kind = 4 then begin
              ballpoints2:=ballpoints2+1;
              kind:=random(4)+6;
              dx:=0; dy:=0;
              x2:=x2+round(cos(2*3.1416/360*facing)*vi); {skid}
              y2:=y2+round(sin(2*3.1416/360*facing)*vi);
              shield2:=shield2-1;    {guy damages hovertank}
           end;
        end;
        if testshot2=true then begin
           ballhitguy2 := (abs(x2-x-vx2+8)<10) and (abs(y2-y-vy2+8)<10);
           if ballhitguy2 then begin
            if kind = 4 then begin
              ballpoints2:=ballpoints2+1;
              kind:=random(4)+6;
              dx:=0; dy:=0;
              x2:=x2+round(cos(2*3.1416/360*facing)*vi); {knock back}
              y2:=y2+round(sin(2*3.1416/360*facing)*vi);
            end;
           end;
        end;

      end;
  end;


end;

(**) { TMyMorph methods }

function TMyMorph.geomap(x,y:integer):integer;
begin
  geomap := map[y,x];
end;


procedure TMyMorph.nogogeo(x,y:integer);
begin
  fput(x,y,gpic[0]^,false);
end;


procedure TMyMorph.placegeo(x,y,geonum:integer);
begin
  if geonum in [1..geo_cnt]
    then
      if geonum=2 then fput(x,y,gpic[1+flip]^,false)
        else if geonum=25 then fput(x,y,gpic[24+flip]^,false)
        else if geonum=28 then fput(x,y,gpic[27+flip]^,false)
        else if geonum=31 then fput(x,y,gpic[30+flip]^,false)
        else if geonum=34 then fput(x,y,gpic[33+flip]^,false)
        else if geonum=40 then fput(x,y,gpic[39+flip]^,false)
        else if geonum=43 then fput(x,y,gpic[42+flip]^,false)
        else if geonum=46 then fput(x,y,gpic[45+flip]^,false)
        else if geonum=58 then fput(x,y,gpic[57+flip]^,false)
        else if geonum=59 then fput(x,y,gpic[58+flip]^,false)
        else if geonum=79 then fput(x,y,gpic[78+flip]^,false)
        else if geonum=49 then fput(x,y,gpic[48+random(3)]^,false)
        else fput(x,y,gpic[geonum-1]^,false);
end;


procedure showit;
begin
   writeln;
   writeln('Keys:');
   writeln(' ESC          - quit demo');
   writeln(' Arrow keys   - scroll');
   writeln(' 0..9         - change speed');
   writeln;
end;


begin
  showit;

   clearkeyint;
   machine:=0; players:=0;
   write('Would you like a 1) Player game or a 2) Player game?');
   readln(players);
   if players = 1 then charicon:=39 else charicon:=22;
   clearkeyint;
   write('Are you using a 2)86, 3)86, or 4)86?');
   readln(machine);
   if machine = 2 then writeln('286');

   installkeyint;
   clearbuffer;

  setup;

  ballpoints2:=0;

  setpageactive(1);

  {a:= fli_play('title.fli',1,1);}
  pcopy(2,1);
  Animate;

  dispose(MyMorph,done);
  clean_plist(head,tail);
  closemode;
end.




























