Program threed;

Uses CRT,SPX_IMG,SPX_VGA,SPX_KEY,SPX_OBJ,SPX_T3D,SPX_TXT,SPX_FNC;

const
  pbeg : plist = nil;
  pend : plist = nil;
  path = '';    { default work path }
  xsize = 5;
  ysize = 5;
  zsize = 5;

type
  Ppoint = ^Tpoint;
  Tpoint = object(Tobjs)
             x,y,z : integer;
             constructor init(nx,ny,nz:integer);
           end;

var
  oldexit   : pointer;
  d,m,r     : integer;
  pal   : RGBlist;
  balls : array[0..39] of pointer;
  xpos,ypos,zpos        : integer;
  xa,ya,za              : integer;
  NewSize  : pointer;

procedure cleanup;far;
begin
  clean_plist(pbeg,pend);
  closemode;
  exitproc := oldexit;
end;

procedure setup;
begin
  getmem(NewSize,buffsize(200,200));
  openmode(3); randomize;
  setpageactive(3);
  loadpcx(path+'stars.pcx'); { load pcx file on page 3 }
  pcopy(3,2);
  pcopy(3,1);
  loadvsp(path+'btnsbls.vsp',balls);
  loadcolors(path+'buttons.pal',pal,256);
  fsetcolors(pal);  { palette }
  oldexit := exitproc; exitproc := @cleanup;
end;


procedure setlevel;
const
  lv1 : array[0..8,0..1] of integer =
        ((-3,-5),(3,-5),(5,-3),(5,3),(3,5),(-3,5),(-5,3),(-5,-3),(-3,-5));
var
  p : plist;
  d,e : integer;
begin
  for d := 0 to 8 do
    begin
      new(p);
      p^.item := new(ppoint,init(lv1[d,0]*10,lv1[d,1]*10,0));
      p^.item^.powner := p;
      addp(pbeg,pend,p);

    end;
end;

procedure addballs;
const
  lv1 : array[0..8,0..1] of integer =
        ((-3,-5),(3,-5),(5,-3),(5,3),(3,5),(-3,5),(-5,3),(-5,-3),(-3,-5));
var
  grid : array[1..100,0..1] of integer;
  p : plist;
  d,e : integer;
begin
      {new(p);
      p^.item := new(ppoint,init(lv1[d,0]*10,lv1[d,1]*10,0));
      p^.item^.powner := p;
      addp(pbeg,pend,p);}
      for d:=1 to 100 do begin
        if (d mod 3 = 0) then begin {every third one }
          new(p);
          p^.item := new(ppoint,init(lv1[d,0]*10,lv1[d,1]*10,0));
          p^.item^.powner := p;
          addp(pbeg,pend,p);
        end;
      end;
end;

procedure scale(typ,z,h,w: integer);
var
    vscale   : integer;
    factor   : integer;
begin
    { range of m is -200 to 135 }
    factor:=(200+((4*m)+(z)));
    {factor:=(200+m)+(z+100);}
    if factor<0 then factor:=0;
    vscale:=(factor div 30);
    if vscale<2 then vscale:=2;
    if vscale>195 then vscale:=195;
    {putletter(10,20,45,'vscale = '+st(vscale));}
    ScaleVSP(balls[typ]^,Newsize^,((vscale)+2),(vscale));  { Changes MySprite to be size 16x16 }
end;


procedure drawlist(c:integer);
var
  nx,ny,nz,
  ox,oy,oz : integer;
  p        : plist;
  dumx,dumy  :integer;
    vscale   : integer;

begin
  p := pbeg;
  while p<>nil do
    with ppoint(p^.item)^ do
      begin
        nx := x; ny := y; nz := z;
        rotate256xyz(nx,ny,nz,0,0,r);
        if p<>pbeg
          then
            begin
              line3D(ox,oy,100+m,nx,ny,100+m,c,true);
              line3D(ox,oy,-200+m,nx,ny,-200+m,c,true);
              line3D(nx,ny,100+m,nx,ny,-200+m,c,true);

    putletter(10,10,45,'M = '+st(m));

    scale(28,-200,8,8);
              setpoints((nx),(ny),(-200+m),dumx,dumy);
              ftput(dumx,dumy,Newsize^,true);

    scale(28,100,8,8);
              setpoints((nx),(ny),(100+m),dumx,dumy);
              ftput(dumx,dumy,Newsize^,true);

            end;
        ox := nx; oy := ny; oz := nz;
        p := p^.next;
      end;
end;


procedure getkey;
begin
  if plus
    then r := (r+1)mod 256
    else
     if minus
       then r := (r+255)mod 256;
  if np[4,2] and (xv>-300)
    then dec(xv,5)
    else
      if np[6,2] and (xv<300)
        then inc(xv,5);
  if np[4,1] and (m>-200)
    then dec(m,5)
    else
      if np[6,1] and (m<135)
        then inc(m,5);
  if np[8,2] and (yv>-300)
    then dec(yv,5)
    else
      if np[2,2] and (yv<300)
        then inc(yv,5);
end;


procedure drawall(draw:boolean);
var x,y  : integer;
begin
pcopy(3,2);
  setpageactive(2);
  for d := -10 to 10 do begin
    line3d(d*10,20,100,d*10,20,-100,ord(draw),true);
  end;

  drawlist(12*ord(draw));

  pset3d(-100,-50,100,15*ord(draw));
  pset3d(-100,50,100,15*ord(draw));
  pset3d(100,-50,100,15*ord(draw));
  pset3d(100,50,100,15*ord(draw));
  pset3d(-100,-50,-100,15*ord(draw));
  pset3d(-100,50,-100,15*ord(draw));
  pset3d(100,-50,-100,15*ord(draw));
  pset3d(100,50,-100,15*ord(draw));

end;


procedure Animate;
begin
  setlevel; zv := 300; m := 0; r := 0;
  repeat
    {drawall(false);}
    getkey;
    drawall(true);
    pcopy(2,1);
  until esc;
end;



procedure initarray;
var x,y,z: integer;
    dummy     : integer;
begin
  for x:=1 to xsize do begin
      for y:=1 to ysize do begin
          for z:=1 to zsize do begin
          xpos:=x;
          ypos:=y;
          zpos:=z;
          addballs;
          end;
      end;
  end;
end;

(**) { tpoint methods }

constructor tpoint.init(nx,ny,nz:integer);
begin
  {inherited init;}
  x := nx; y := ny; z := nz;
end;


procedure showit;
begin
   writeln;
   writeln('Keys:');
   writeln(' ESC          - quit demo');
   writeln(' Arrow keys   - change viewer''s postition');
   writeln(' A/D          - move object along Z');
   writeln(' +/-          - rotate object along Z axis');
   writeln;
   write('Press any key.');
   clearbuffer;
   repeat until anykey;
end;


begin
  showit;
  setup;
  Animate;
end.