/*  tables.c
 *
 *  Produces sine and cosine tables, and a random number table.
 */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "project.h"
#include "math.h"

void compute_sin(FILE *f)
{
  int angle;

  fprintf(f, "Fixedpoint sin_table[] = { ");
  for (angle = 0; angle < DEGREES; angle++) {
    if (angle % 5 == 0 && angle != 0)
      fprintf(f, ",\n                           ");
    else
      if (angle != 0)
        fprintf(f, ", ");
    fprintf(f, "0x%lxL", (long)(sin(deg2rad(angle)) * 65536L));
  }
  fprintf(f, "\n};\n");
}

void compute_cos(FILE *f)
{
  int angle;

  fprintf(f, "Fixedpoint cos_table[] = { ");
  for (angle = 0; angle < DEGREES; angle++) {
    if (angle % 5 == 0 && angle != 0)
      fprintf(f, ",\n                           ");
    else
      if (angle != 0)
        fprintf(f, ", ");
    fprintf(f, "0x%lxL", (long)(cos(deg2rad(angle)) * 65536L));
  }
  fprintf(f, "\n};\n");
}

void compute_rand(FILE *f)
{
  int num;

  randomize();
  fprintf(f, "int randtable[] = { ");
  for (num = 0; num < 2048; num++) {
    if (num % 16 == 0 && num != 0)
      fprintf(f, ",\n                    ");
    else
      if (num != 0)
        fprintf(f, ", ");
    fprintf(f, "%d", random(20));
  }
  fprintf(f, "\n};\n");
}

void main(void)
{
  FILE *f;

  f = fopen("sincos.inc", "w");
  compute_sin(f);
  fprintf(f, "\n");
  compute_cos(f);
  fclose(f);
  f = fopen("random.inc", "w");
  compute_rand(f);
  fclose(f);
}

